/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusGainedEvent;
import de.lessvoid.nifty.controls.FocusLostEvent;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public abstract class AbstractController
implements Controller,
NiftyControl {
    private Element element;
    private boolean bound = false;

    protected void bind(Element element) {
        this.element = element;
    }

    @Override
    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.bound = true;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void enable() {
        this.element.enable();
    }

    @Override
    public void disable() {
        this.element.disable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.element.enable();
        } else {
            this.element.disable();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    @Override
    public String getId() {
        return this.element.getId();
    }

    @Override
    public void setId(String id) {
        this.element.setId(id);
    }

    @Override
    public int getWidth() {
        return this.element.getWidth();
    }

    @Override
    public void setWidth(SizeValue width) {
        this.element.setConstraintWidth(width);
    }

    @Override
    public int getHeight() {
        return this.element.getHeight();
    }

    @Override
    public void setHeight(SizeValue height) {
        this.element.setConstraintHeight(height);
    }

    @Override
    public String getStyle() {
        return this.element.getStyle();
    }

    @Override
    public void setStyle(String style) {
        this.element.setStyle(this.element.getNifty().specialValuesReplace(style));
    }

    @Override
    public void setFocus() {
        this.element.setFocus();
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.element.setFocusable(focusable);
    }

    @Override
    public void onFocus(boolean getFocus) {
        if (this.element == null) {
            return;
        }
        if (getFocus) {
            this.element.getNifty().publishEvent(this.element.getId(), new FocusGainedEvent(this, this));
        } else {
            this.element.getNifty().publishEvent(this.element.getId(), new FocusLostEvent(this, this));
        }
    }

    @Override
    public boolean hasFocus() {
        if (this.getElement() == null) {
            return false;
        }
        return this.getElement() == this.getElement().getFocusHandler().getKeyboardFocusElement();
    }

    @Override
    public void layoutCallback() {
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }
}

