/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.Bone;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.animation.Skeleton;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;

public final class BoneTrack
implements Savable {
    private int targetBoneIndex;
    private CompactVector3Array translations;
    private CompactQuaternionArray rotations;
    private CompactVector3Array scales;
    private float[] times;
    private final transient Vector3f tempV = new Vector3f();
    private final transient Quaternion tempQ = new Quaternion();
    private final transient Vector3f tempS = new Vector3f();
    private final transient Vector3f tempV2 = new Vector3f();
    private final transient Quaternion tempQ2 = new Quaternion();
    private final transient Vector3f tempS2 = new Vector3f();

    public BoneTrack() {
    }

    public BoneTrack(int targetBoneIndex, float[] times, Vector3f[] translations, Quaternion[] rotations) {
        this.targetBoneIndex = targetBoneIndex;
        this.setKeyframes(times, translations, rotations);
    }

    public BoneTrack(int targetBoneIndex, float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.targetBoneIndex = targetBoneIndex;
        this.setKeyframes(times, translations, rotations, scales);
    }

    public BoneTrack(int targetBoneIndex) {
        this.targetBoneIndex = targetBoneIndex;
    }

    public int getTargetBoneIndex() {
        return this.targetBoneIndex;
    }

    public Quaternion[] getRotations() {
        return (Quaternion[])this.rotations.toObjectArray();
    }

    public Vector3f[] getScales() {
        return this.scales == null ? null : (Vector3f[])this.scales.toObjectArray();
    }

    public float[] getTimes() {
        return this.times;
    }

    public Vector3f[] getTranslations() {
        return (Vector3f[])this.translations.toObjectArray();
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations) {
        if (times.length == 0) {
            throw new RuntimeException("BoneTrack with no keyframes!");
        }
        assert (times.length == translations.length && times.length == rotations.length);
        this.times = times;
        this.translations = new CompactVector3Array();
        this.translations.add(translations);
        this.translations.freeze();
        this.rotations = new CompactQuaternionArray();
        this.rotations.add(rotations);
        this.rotations.freeze();
    }

    public void setKeyframes(float[] times, Vector3f[] translations, Quaternion[] rotations, Vector3f[] scales) {
        this.setKeyframes(times, translations, rotations);
        assert (times.length == scales.length);
        if (scales != null) {
            this.scales = new CompactVector3Array();
            this.scales.add(scales);
            this.scales.freeze();
        }
    }

    public void setTime(float time, Skeleton skeleton, float weight) {
        Bone target = skeleton.getBone(this.targetBoneIndex);
        int lastFrame = this.times.length - 1;
        if (time < 0.0f || lastFrame == 0) {
            this.rotations.get(0, this.tempQ);
            this.translations.get(0, this.tempV);
            if (this.scales != null) {
                this.scales.get(0, this.tempS);
            }
        } else if (time >= this.times[lastFrame]) {
            this.rotations.get(lastFrame, this.tempQ);
            this.translations.get(lastFrame, this.tempV);
            if (this.scales != null) {
                this.scales.get(lastFrame, this.tempS);
            }
        } else {
            int startFrame = 0;
            int endFrame = 1;
            for (int i = 0; i < lastFrame && this.times[i] < time; ++i) {
                startFrame = i;
                endFrame = i + 1;
            }
            float blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
            this.rotations.get(startFrame, this.tempQ);
            this.translations.get(startFrame, this.tempV);
            if (this.scales != null) {
                this.scales.get(startFrame, this.tempS);
            }
            this.rotations.get(endFrame, this.tempQ2);
            this.translations.get(endFrame, this.tempV2);
            if (this.scales != null) {
                this.scales.get(endFrame, this.tempS2);
            }
            this.tempQ.nlerp(this.tempQ2, blend);
            this.tempV.interpolate(this.tempV2, blend);
            this.tempS.interpolate(this.tempS2, blend);
        }
        if (weight != 1.0f) {
            target.blendAnimTransforms(this.tempV, this.tempQ, this.scales != null ? this.tempS : null, weight);
        } else {
            target.setAnimTransforms(this.tempV, this.tempQ, this.scales != null ? this.tempS : null);
        }
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.targetBoneIndex, "boneIndex", 0);
        oc.write(this.translations, "translations", null);
        oc.write(this.rotations, "rotations", null);
        oc.write(this.times, "times", (float[])null);
        oc.write(this.scales, "scales", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.targetBoneIndex = ic.readInt("boneIndex", 0);
        this.translations = (CompactVector3Array)ic.readSavable("translations", null);
        this.rotations = (CompactQuaternionArray)ic.readSavable("rotations", null);
        this.times = ic.readFloatArray("times", null);
        this.scales = (CompactVector3Array)ic.readSavable("scales", null);
        if (im.getFormatVersion() == 0) {
            Savable[] sav;
            if (this.translations == null && (sav = ic.readSavableArray("translations", null)) != null) {
                this.translations = new CompactVector3Array();
                Vector3f[] transCopy = new Vector3f[sav.length];
                System.arraycopy(sav, 0, transCopy, 0, sav.length);
                this.translations.add(transCopy);
                this.translations.freeze();
            }
            if (this.rotations == null && (sav = ic.readSavableArray("rotations", null)) != null) {
                this.rotations = new CompactQuaternionArray();
                Quaternion[] rotCopy = new Quaternion[sav.length];
                System.arraycopy(sav, 0, rotCopy, 0, sav.length);
                this.rotations.add(rotCopy);
                this.rotations.freeze();
            }
        }
    }
}

