/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class ThreadingManager {
    protected final ExecutorService executor = Executors.newFixedThreadPool(2, new LoadingThreadFactory());
    protected final AssetManager owner;
    protected int nextThreadId = 0;

    public ThreadingManager(AssetManager owner) {
        this.owner = owner;
    }

    public static boolean isLoadingThread() {
        return Thread.currentThread().getName().startsWith("pool");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LoadingTask
    implements Callable<Object> {
        private final String resourceName;

        public LoadingTask(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public Object call() throws Exception {
            return ThreadingManager.this.owner.loadAsset(new AssetKey(this.resourceName));
        }
    }

    protected class LoadingThreadFactory
    implements ThreadFactory {
        protected LoadingThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "pool" + ThreadingManager.this.nextThreadId++);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

