/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import android.content.res.Resources;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.system.JmeSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class AndroidLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(AndroidLocator.class.getName());
    private Resources resources = JmeSystem.getResources();
    private android.content.res.AssetManager androidManager = this.resources.getAssets();
    private String rootPath = "";

    @Override
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        InputStream in = null;
        String sAssetPath = this.rootPath + key.getName();
        if (sAssetPath.startsWith("/")) {
            sAssetPath = sAssetPath.substring(1);
        }
        sAssetPath = sAssetPath.replace("//", "/");
        try {
            in = this.androidManager.open(sAssetPath);
            if (in == null) {
                return null;
            }
            return new AndroidAssetInfo(manager, key, in);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private class AndroidAssetInfo
    extends AssetInfo {
        private final InputStream in;

        public AndroidAssetInfo(AssetManager manager, AssetKey<?> key, InputStream in) {
            super(manager, key);
            this.in = in;
        }

        @Override
        public InputStream openStream() {
            return this.in;
        }
    }
}

