/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.AudioData;
import com.jme3.audio.AudioRenderer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class AudioStream
extends AudioData
implements Closeable {
    protected InputStream in;
    protected float duration = -1.0f;
    protected boolean open = false;
    protected int[] ids;

    public void updateData(InputStream in, float duration) {
        if (this.id != -1 || this.in != null) {
            throw new IllegalStateException("Data already set!");
        }
        this.in = in;
        this.duration = duration;
        this.open = true;
    }

    public int readSamples(byte[] buf, int offset, int length) {
        if (!this.open) {
            return -1;
        }
        try {
            return this.in.read(buf, offset, length);
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public int readSamples(byte[] buf) {
        return this.readSamples(buf, 0, buf.length);
    }

    public float getDuration() {
        return this.duration;
    }

    public int getId() {
        throw new RuntimeException("Don't use getId() on streams");
    }

    public void setId(int id) {
        throw new RuntimeException("Don't use setId() on streams");
    }

    public void initIds(int count) {
        this.ids = new int[count];
    }

    public int getId(int index) {
        return this.ids[index];
    }

    public void setId(int index, int id) {
        this.ids[index] = id;
    }

    public int[] getIds() {
        return this.ids;
    }

    public void setIds(int[] ids) {
        this.ids = ids;
    }

    public AudioData.DataType getDataType() {
        return AudioData.DataType.Stream;
    }

    public void resetObject() {
        this.id = -1;
        this.ids = null;
        this.setUpdateNeeded();
    }

    public void deleteObject(AudioRenderer r) {
        r.deleteAudioData(this);
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        if (this.in != null && this.open) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } else {
            throw new RuntimeException("AudioStream is already closed!");
        }
        this.open = false;
    }
}

