/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.binary;

import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryClassField;
import com.jme3.export.binary.BinaryClassObject;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.ByteUtils;
import com.jme3.util.IntMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryOutputCapsule
implements OutputCapsule {
    public static final int NULL_OBJECT = -1;
    public static final int DEFAULT_OBJECT = -2;
    public static byte[] NULL_BYTES = new byte[]{-1};
    public static byte[] DEFAULT_BYTES = new byte[]{-2};
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected byte[] bytes;
    protected BinaryExporter exporter;
    protected BinaryClassObject cObj;

    public BinaryOutputCapsule(BinaryExporter exporter, BinaryClassObject bco) {
        this.exporter = exporter;
        this.cObj = bco;
    }

    @Override
    public void write(byte value, String name, byte defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)0);
        this.write(value);
    }

    @Override
    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)1);
        this.write(value);
    }

    @Override
    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)2);
        this.write(value);
    }

    @Override
    public void write(int value, String name, int defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)10);
        this.write(value);
    }

    @Override
    public void write(int[] value, String name, int[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)11);
        this.write(value);
    }

    @Override
    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)12);
        this.write(value);
    }

    @Override
    public void write(float value, String name, float defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)20);
        this.write(value);
    }

    @Override
    public void write(float[] value, String name, float[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)21);
        this.write(value);
    }

    @Override
    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)22);
        this.write(value);
    }

    @Override
    public void write(double value, String name, double defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)30);
        this.write(value);
    }

    @Override
    public void write(double[] value, String name, double[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)31);
        this.write(value);
    }

    @Override
    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)32);
        this.write(value);
    }

    @Override
    public void write(long value, String name, long defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)40);
        this.write(value);
    }

    @Override
    public void write(long[] value, String name, long[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)41);
        this.write(value);
    }

    @Override
    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)42);
        this.write(value);
    }

    @Override
    public void write(short value, String name, short defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)50);
        this.write(value);
    }

    @Override
    public void write(short[] value, String name, short[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)51);
        this.write(value);
    }

    @Override
    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)52);
        this.write(value);
    }

    @Override
    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)60);
        this.write(value);
    }

    @Override
    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)61);
        this.write(value);
    }

    @Override
    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)62);
        this.write(value);
    }

    @Override
    public void write(String value, String name, String defVal) throws IOException {
        if (value == null ? defVal == null : value.equals(defVal)) {
            return;
        }
        this.writeAlias(name, (byte)70);
        this.write(value);
    }

    @Override
    public void write(String[] value, String name, String[] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)71);
        this.write(value);
    }

    @Override
    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)72);
        this.write(value);
    }

    @Override
    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)80);
        this.write(value);
    }

    @Override
    public void write(Savable object, String name, Savable defVal) throws IOException {
        if (object == defVal) {
            return;
        }
        this.writeAlias(name, (byte)90);
        this.write(object);
    }

    @Override
    public void write(Savable[] objects, String name, Savable[] defVal) throws IOException {
        if (objects == defVal) {
            return;
        }
        this.writeAlias(name, (byte)91);
        this.write(objects);
    }

    @Override
    public void write(Savable[][] objects, String name, Savable[][] defVal) throws IOException {
        if (objects == defVal) {
            return;
        }
        this.writeAlias(name, (byte)92);
        this.write(objects);
    }

    @Override
    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)120);
        this.write(value);
    }

    @Override
    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)121);
        this.write(value);
    }

    @Override
    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)122);
        this.write(value);
    }

    @Override
    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.writeAlias(name, (byte)123);
        this.write(value);
    }

    @Override
    public void writeFloatBufferArrayList(ArrayList<FloatBuffer> array, String name, ArrayList<FloatBuffer> defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)110);
        this.writeFloatBufferArrayList(array);
    }

    @Override
    public void writeByteBufferArrayList(ArrayList<ByteBuffer> array, String name, ArrayList<ByteBuffer> defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)111);
        this.writeByteBufferArrayList(array);
    }

    @Override
    public void writeSavableArrayList(ArrayList array, String name, ArrayList defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)100);
        this.writeSavableArrayList(array);
    }

    @Override
    public void writeSavableArrayListArray(ArrayList[] array, String name, ArrayList[] defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)101);
        this.writeSavableArrayListArray(array);
    }

    @Override
    public void writeSavableArrayListArray2D(ArrayList[][] array, String name, ArrayList[][] defVal) throws IOException {
        if (array == defVal) {
            return;
        }
        this.writeAlias(name, (byte)102);
        this.writeSavableArrayListArray2D(array);
    }

    @Override
    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        if (map == defVal) {
            return;
        }
        this.writeAlias(name, (byte)105);
        this.writeSavableMap(map);
    }

    @Override
    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        if (map == defVal) {
            return;
        }
        this.writeAlias(name, (byte)106);
        this.writeStringSavableMap(map);
    }

    @Override
    public void writeIntSavableMap(IntMap<? extends Savable> map, String name, IntMap<? extends Savable> defVal) throws IOException {
        if (map == defVal) {
            return;
        }
        this.writeAlias(name, (byte)107);
        this.writeIntSavableMap(map);
    }

    protected void writeAlias(String name, byte fieldType) throws IOException {
        if (this.cObj.nameFields.get(name) == null) {
            this.generateAlias(name, fieldType);
        }
        byte alias = this.cObj.nameFields.get((Object)name).alias;
        this.write(alias);
    }

    protected void generateAlias(String name, byte type) {
        byte alias = (byte)this.cObj.nameFields.size();
        this.cObj.nameFields.put(name, new BinaryClassField(name, alias, type));
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof BinaryOutputCapsule)) {
            return false;
        }
        byte[] other = ((BinaryOutputCapsule)arg0).bytes;
        if (this.bytes.length != other.length) {
            return false;
        }
        return Arrays.equals(this.bytes, other);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.hashCode(this.bytes);
        return hash;
    }

    public void finish() {
        this.bytes = this.baos.toByteArray();
        this.baos = null;
    }

    protected void write(byte value) throws IOException {
        this.baos.write(value);
    }

    protected void writeForBuffer(byte value) throws IOException {
        this.baos.write(value);
    }

    protected void write(byte[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        this.baos.write(value);
    }

    protected void write(byte[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(int value) throws IOException {
        this.baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes(value)));
    }

    protected void writeForBuffer(int value) throws IOException {
        byte[] byteArray = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        this.baos.write(byteArray);
    }

    protected void write(int[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(int[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(float value) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(value));
    }

    protected void writeForBuffer(float value) throws IOException {
        int integer = Float.floatToIntBits(value);
        this.writeForBuffer(integer);
    }

    protected void write(float[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(float[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(double value) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(value));
    }

    protected void write(double[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(double[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(long value) throws IOException {
        this.baos.write(BinaryOutputCapsule.deflate(ByteUtils.convertToBytes(value)));
    }

    protected void write(long[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(long[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(short value) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(value));
    }

    protected void writeForBuffer(short value) throws IOException {
        byte[] byteArray = new byte[]{(byte)value, (byte)(value >> 8)};
        this.baos.write(byteArray);
    }

    protected void write(short[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(short[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(boolean value) throws IOException {
        this.baos.write(ByteUtils.convertToBytes(value));
    }

    protected void write(boolean[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(boolean[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(String value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        byte[] bytes = value.getBytes("UTF8");
        this.write(bytes.length);
        this.baos.write(bytes);
    }

    protected void write(String[] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(String[][] value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.length);
        for (int x = 0; x < value.length; ++x) {
            this.write(value[x]);
        }
    }

    protected void write(BitSet value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        this.write(value.size());
        int max = value.size();
        for (int x = 0; x < max; ++x) {
            this.write(value.get(x));
        }
    }

    protected static byte[] deflate(byte[] bytes) {
        int size = bytes.length;
        if (size == 4) {
            int possibleMagic = ByteUtils.convertIntFromBytes(bytes);
            if (possibleMagic == -1) {
                return NULL_BYTES;
            }
            if (possibleMagic == -2) {
                return DEFAULT_BYTES;
            }
        }
        for (int x = 0; x < bytes.length && bytes[x] == 0; ++x) {
            --size;
        }
        if (size == 0) {
            return new byte[1];
        }
        byte[] rVal = new byte[1 + size];
        rVal[0] = (byte)size;
        for (int x = 1; x < rVal.length; ++x) {
            rVal[x] = bytes[bytes.length - size - 1 + x];
        }
        return rVal;
    }

    protected void write(Savable object) throws IOException {
        if (object == null) {
            this.write(-1);
            return;
        }
        int id = this.exporter.processBinarySavable(object);
        this.write(id);
    }

    protected void write(Savable[] objects) throws IOException {
        if (objects == null) {
            this.write(-1);
            return;
        }
        this.write(objects.length);
        for (int x = 0; x < objects.length; ++x) {
            this.write(objects[x]);
        }
    }

    protected void write(Savable[][] objects) throws IOException {
        if (objects == null) {
            this.write(-1);
            return;
        }
        this.write(objects.length);
        for (int x = 0; x < objects.length; ++x) {
            this.write(objects[x]);
        }
    }

    protected void writeSavableArrayList(ArrayList array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (Object bs : array) {
            this.write((Savable)bs);
        }
    }

    protected void writeSavableArrayListArray(ArrayList[] array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.length);
        for (ArrayList bs : array) {
            this.writeSavableArrayList(bs);
        }
    }

    protected void writeSavableArrayListArray2D(ArrayList[][] array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.length);
        for (ArrayList[] bs : array) {
            this.writeSavableArrayListArray(bs);
        }
    }

    protected void writeSavableMap(Map<? extends Savable, ? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (Savable savable : array.keySet()) {
            this.write(new Savable[]{savable, array.get(savable)});
        }
    }

    protected void writeStringSavableMap(Map<String, ? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        String[] keys = array.keySet().toArray(new String[0]);
        this.write(keys);
        Savable[] values = array.values().toArray(new Savable[0]);
        this.write(values);
    }

    protected void writeIntSavableMap(IntMap<? extends Savable> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        int[] keys = new int[array.size()];
        Savable[] values = new Savable[keys.length];
        int i = 0;
        for (IntMap.Entry<? extends Savable> entry : array) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this.write(keys);
        this.write(values);
    }

    protected void writeFloatBufferArrayList(ArrayList<FloatBuffer> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (FloatBuffer buf : array) {
            this.write(buf);
        }
    }

    protected void writeByteBufferArrayList(ArrayList<ByteBuffer> array) throws IOException {
        if (array == null) {
            this.write(-1);
            return;
        }
        this.write(array.size());
        for (ByteBuffer buf : array) {
            this.write(buf);
        }
    }

    protected void write(FloatBuffer value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        value.rewind();
        int length = value.limit();
        this.write(length);
        for (int x = 0; x < length; ++x) {
            this.writeForBuffer(value.get());
        }
        value.rewind();
    }

    protected void write(IntBuffer value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        value.rewind();
        int length = value.limit();
        this.write(length);
        for (int x = 0; x < length; ++x) {
            this.writeForBuffer(value.get());
        }
        value.rewind();
    }

    protected void write(ByteBuffer value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        value.rewind();
        int length = value.limit();
        this.write(length);
        for (int x = 0; x < length; ++x) {
            this.writeForBuffer(value.get());
        }
        value.rewind();
    }

    protected void write(ShortBuffer value) throws IOException {
        if (value == null) {
            this.write(-1);
            return;
        }
        value.rewind();
        int length = value.limit();
        this.write(length);
        for (int x = 0; x < length; ++x) {
            this.writeForBuffer(value.get());
        }
        value.rewind();
    }

    @Override
    public void write(Enum value, String name, Enum defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        if (value == null) {
            return;
        }
        this.write(value.name(), name, null);
    }
}

