/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.ClientManager;
import com.jme3.network.connection.ConnectionRunnable;
import com.jme3.network.connection.ConnectorFilter;
import com.jme3.network.connection.TCPConnection;
import com.jme3.network.connection.UDPConnection;
import com.jme3.network.events.ConnectionListener;
import com.jme3.network.events.MessageListener;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import com.jme3.network.message.Message;
import com.jme3.network.service.ServiceManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Server
extends ServiceManager {
    protected Logger log = Logger.getLogger(Server.class.getName());
    protected static int serverIDCounter = 0;
    protected TCPConnection tcp = null;
    protected UDPConnection udp = null;
    protected String label;
    protected int serverID;
    protected boolean isBound = false;
    protected ConnectionRunnable thread;
    protected SocketAddress lastUDPAddress;
    protected SocketAddress lastTCPAddress;
    protected ClientManager clientManager = new ClientManager();
    protected MessageListener listener = new ServerMessageObserver();

    public Server() {
        super(false);
        this.serverID = ++serverIDCounter;
        this.label = "Server#" + this.serverID;
    }

    public Server(TCPConnection tcp, UDPConnection udp, SocketAddress tcpAddress, SocketAddress udpAddress) throws IOException {
        this();
        this.tcp = tcp;
        tcp.bind(tcpAddress);
        this.lastTCPAddress = tcpAddress;
        this.udp = udp;
        udp.bind(udpAddress);
        this.lastUDPAddress = udpAddress;
        this.isBound = true;
        this.registerInternalListeners();
    }

    public Server(TCPConnection tcp, SocketAddress tcpAddress) throws IOException {
        this();
        this.tcp = tcp;
        tcp.bind(tcpAddress);
        this.lastTCPAddress = tcpAddress;
        this.isBound = true;
        this.registerInternalListeners();
    }

    public Server(UDPConnection udp, SocketAddress udpAddress) throws IOException {
        this();
        this.udp = udp;
        udp.bind(udpAddress);
        this.lastUDPAddress = udpAddress;
        this.isBound = true;
        this.registerInternalListeners();
    }

    @Deprecated
    public Server(int tcpPort, int udpPort) throws IOException {
        this();
        this.tcp = new TCPConnection(this.label);
        this.lastTCPAddress = new InetSocketAddress(tcpPort);
        this.tcp.bind(this.lastTCPAddress);
        this.lastUDPAddress = new InetSocketAddress(udpPort);
        this.udp = new UDPConnection(this.label);
        this.udp.bind(this.lastUDPAddress);
        this.isBound = true;
        this.registerInternalListeners();
    }

    private void registerInternalListeners() {
        if (this.tcp != null) {
            this.tcp.addMessageListener(DisconnectMessage.class, this.listener);
            this.tcp.addMessageListener(ClientRegistrationMessage.class, this.clientManager);
            this.tcp.addConnectionListener(this.clientManager);
        }
        if (this.udp != null) {
            this.udp.addMessageListener(DisconnectMessage.class, this.listener);
            this.udp.addMessageListener(ClientRegistrationMessage.class, this.clientManager);
            this.udp.addConnectionListener(this.clientManager);
        }
    }

    public void bind(int tcpPort, int udpPort) throws IllegalArgumentException, IOException {
        if (tcpPort == -1 && udpPort == -1) {
            throw new IllegalArgumentException("No point in binding when you want to turn both the connections off.");
        }
        if (tcpPort != -1) {
            this.lastTCPAddress = new InetSocketAddress(tcpPort);
            this.tcp.bind(this.lastTCPAddress);
        }
        if (udpPort != -1) {
            this.lastUDPAddress = new InetSocketAddress(udpPort);
            this.udp.bind(this.lastUDPAddress);
        }
        this.registerInternalListeners();
        this.isBound = true;
    }

    public void broadcast(Message message) throws IOException {
        if (!this.isBound) {
            throw new IOException("Not bound yet. Use bind() first.");
        }
        if (message.isReliable()) {
            if (this.tcp == null) {
                throw new IOException("No TCP server.");
            }
            this.tcp.sendObject(message);
        } else {
            if (this.udp == null) {
                throw new IOException("No UDP server.");
            }
            this.udp.sendObject(message);
        }
    }

    public void broadcastExcept(Client except, Message message) throws IOException {
        if (!this.isBound) {
            throw new IOException("Not bound yet. Use bind() first.");
        }
        for (Client con : this.clientManager.getConnectors()) {
            if (con == except) continue;
            con.send(message);
        }
    }

    public void start() throws IOException {
        if (!this.isBound) {
            this.tcp.bind(this.lastTCPAddress);
            this.udp.bind(this.lastUDPAddress);
        }
        this.thread = new ConnectionRunnable(this.tcp, this.udp);
        new Thread(this.thread).start();
        this.log.log(Level.INFO, "[{0}][???] Started server.", this.label);
    }

    public void start(int sleep) throws IOException {
        if (!this.isBound) {
            this.tcp.bind(this.lastTCPAddress);
            this.udp.bind(this.lastUDPAddress);
        }
        this.thread = new ConnectionRunnable(this.tcp, this.udp, sleep);
        new Thread(this.thread).start();
        this.log.log(Level.INFO, "[{0}][???] Started server.", this.label);
    }

    public void stop() throws IOException {
        this.stop(new DisconnectMessage());
    }

    public void stop(DisconnectMessage message) throws IOException {
        this.log.log(Level.INFO, "[{0}][???] Server is shutting down..", this.label);
        if (message.getReason() == null) {
            message.setReason("Server shut down.");
        }
        if (message.getType() == null) {
            message.setType("Kick");
        }
        message.setReliable(true);
        this.broadcast(message);
        for (Client client : this.getConnectors()) {
            this.tcp.addToDisconnectionQueue(client);
        }
        this.tcp.selector.wakeup();
        this.log.log(Level.FINE, "[{0}][???] Sent disconnection messages to all clients.", this.label);
        this.thread.setKeepAlive(false);
        this.thread = null;
        this.log.log(Level.INFO, "[{0}][???] Server shut down.", this.label);
        this.isBound = false;
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isRunning();
    }

    public int getServerID() {
        return this.serverID;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public List<Client> getTCPConnectors() {
        if (this.tcp != null) {
            return this.tcp.getConnectors();
        }
        return null;
    }

    public List<Client> getUDPConnectors() {
        if (this.udp != null) {
            return this.udp.getConnectors();
        }
        return null;
    }

    public List<Client> getConnectors() {
        return this.clientManager.getConnectors();
    }

    public Client getClientByID(int clientID) {
        Client c = this.clientManager.getClientByClientID(clientID);
        return c;
    }

    public void addConnectorFilter(ConnectorFilter filter) {
        if (this.tcp != null) {
            this.tcp.addConnectorFilter(filter);
        }
        if (this.udp != null) {
            this.udp.addConnectorFilter(filter);
        }
    }

    public void removeConnectorFilter(ConnectorFilter filter) {
        if (this.tcp != null) {
            this.tcp.removeConnectorFilter(filter);
        }
        if (this.udp != null) {
            this.udp.removeConnectorFilter(filter);
        }
    }

    public void addLocalConnectionListener(ConnectionListener listener) {
        if (this.tcp != null) {
            this.tcp.addConnectionListener(listener);
        }
        if (this.udp != null) {
            this.udp.addConnectionListener(listener);
        }
    }

    public void removeLocalConnectionListener(ConnectionListener listener) {
        if (this.tcp != null) {
            this.tcp.removeConnectionListener(listener);
        }
        if (this.udp != null) {
            this.udp.removeConnectionListener(listener);
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.clientManager.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.clientManager.removeConnectionListener(listener);
    }

    public void addMessageListener(MessageListener listener) {
        if (this.tcp != null) {
            this.tcp.addMessageListener(listener);
        }
        if (this.udp != null) {
            this.udp.addMessageListener(listener);
        }
    }

    public void addMessageListener(MessageListener listener, Class ... classes) {
        for (Class c : classes) {
            if (this.tcp != null) {
                this.tcp.addMessageListener(c, listener);
            }
            if (this.udp == null) continue;
            this.udp.addMessageListener(c, listener);
        }
    }

    public void removeMessageListener(MessageListener listener) {
        if (this.tcp != null) {
            this.tcp.removeMessageListener(listener);
        }
        if (this.udp != null) {
            this.udp.removeMessageListener(listener);
        }
    }

    public void removeMessageListener(MessageListener listener, Class ... classes) {
        for (Class c : classes) {
            if (this.tcp != null) {
                this.tcp.removeMessageListener(c, listener);
            }
            if (this.udp == null) continue;
            this.udp.removeMessageListener(c, listener);
        }
    }

    protected class ServerMessageObserver
    implements MessageListener {
        protected ServerMessageObserver() {
        }

        public void messageReceived(Message message) {
            DisconnectMessage dcMessage = (DisconnectMessage)message;
            Client client = dcMessage.getClient();
            if (Server.this.clientManager.isClientConnected(client)) {
                Server.this.log.log(Level.INFO, "[{0}][???] Client {1} disconnected ({2}: {3}).", new Object[]{Server.this.label, client, dcMessage.getType(), dcMessage.getReason() != null ? dcMessage.getReason() : "No description"});
            }
            dcMessage.getConnection().addToDisconnectionQueue(client);
        }

        public void messageSent(Message message) {
        }

        public void objectReceived(Object object) {
        }

        public void objectSent(Object object) {
        }
    }
}

