/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.niftygui;

import com.jme3.input.InputManager;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.spi.input.InputSystem;
import java.util.ArrayList;

public class InputSystemJme
implements InputSystem,
RawInputListener {
    private final ArrayList<InputEvent> inputQueue = new ArrayList();
    private InputManager inputManager;
    private boolean pressed = false;
    private int buttonIndex;
    private int x;
    private int y;
    private int height;
    private boolean shiftDown = false;
    private boolean ctrlDown = false;
    private Nifty nifty;

    public InputSystemJme(InputManager inputManager) {
        this.inputManager = inputManager;
    }

    public void setNifty(Nifty nifty) {
        this.nifty = nifty;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setMousePosition(int x, int y) {
    }

    public void beginInput() {
    }

    public void endInput() {
        boolean result = this.nifty.update();
    }

    public void onJoyAxisEvent(JoyAxisEvent evt) {
    }

    public void onJoyButtonEvent(JoyButtonEvent evt) {
    }

    private void onMouseMotionEventQueued(MouseMotionEvent evt, NiftyInputConsumer nic) {
        this.x = evt.getX();
        this.y = this.height - evt.getY();
        nic.processMouseEvent(this.x, this.y, evt.getDeltaWheel(), this.buttonIndex, this.pressed);
    }

    public void onMouseMotionEvent(MouseMotionEvent evt) {
        if (this.inputManager.isCursorVisible() && (evt.getDX() != 0 || evt.getDY() != 0 || evt.getDeltaWheel() != 0)) {
            this.inputQueue.add(evt);
        }
    }

    private void onMouseButtonEventQueued(MouseButtonEvent evt, NiftyInputConsumer nic) {
        this.buttonIndex = evt.getButtonIndex();
        this.pressed = evt.isPressed();
        if (nic.processMouseEvent(this.x, this.y, 0, this.buttonIndex, this.pressed)) {
            evt.setConsumed();
        }
    }

    public void onMouseButtonEvent(MouseButtonEvent evt) {
        if (this.inputManager.isCursorVisible() && evt.getButtonIndex() >= 0 || evt.getButtonIndex() <= 2) {
            this.inputQueue.add(evt);
        }
    }

    private void onKeyEventQueued(KeyInputEvent evt, NiftyInputConsumer nic) {
        int code = evt.getKeyCode();
        if (code == 42 || code == 54) {
            this.shiftDown = evt.isPressed();
        } else if (code == 29 || code == 157) {
            this.ctrlDown = evt.isPressed();
        }
        KeyboardInputEvent keyEvt = new KeyboardInputEvent(code, evt.getKeyChar(), evt.isPressed(), this.shiftDown, this.ctrlDown);
        if (nic.processKeyboardEvent(keyEvt)) {
            evt.setConsumed();
        }
    }

    public void onKeyEvent(KeyInputEvent evt) {
        this.inputQueue.add(evt);
    }

    public void forwardEvents(NiftyInputConsumer nic) {
        int queueSize = this.inputQueue.size();
        for (int i = 0; i < queueSize; ++i) {
            InputEvent evt = this.inputQueue.get(i);
            if (evt instanceof MouseMotionEvent) {
                this.onMouseMotionEventQueued((MouseMotionEvent)evt, nic);
                continue;
            }
            if (evt instanceof MouseButtonEvent) {
                this.onMouseButtonEventQueued((MouseButtonEvent)evt, nic);
                continue;
            }
            if (!(evt instanceof KeyInputEvent)) continue;
            this.onKeyEventQueued((KeyInputEvent)evt, nic);
        }
        this.inputQueue.clear();
    }

    public void onTouchEvent(TouchEvent evt) {
    }
}

