/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class FogFilter
extends Filter {
    private ColorRGBA fogColor = ColorRGBA.White.clone();
    private float fogDensity = 0.7f;
    private float fogDistance = 1000.0f;

    public FogFilter() {
        super("FogFilter");
    }

    public FogFilter(ColorRGBA fogColor, float fogDensity, float fogDistance) {
        this();
        this.fogColor = fogColor;
        this.fogDensity = fogDensity;
        this.fogDistance = fogDistance;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "Common/MatDefs/Post/Fog.j3md");
        this.material.setColor("FogColor", this.fogColor);
        this.material.setFloat("FogDensity", this.fogDensity);
        this.material.setFloat("FogDistance", this.fogDistance);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public ColorRGBA getFogColor() {
        return this.fogColor;
    }

    public void setFogColor(ColorRGBA fogColor) {
        if (this.material != null) {
            this.material.setColor("FogColor", fogColor);
        }
        this.fogColor = fogColor;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public void setFogDensity(float fogDensity) {
        if (this.material != null) {
            this.material.setFloat("FogDensity", fogDensity);
        }
        this.fogDensity = fogDensity;
    }

    public float getFogDistance() {
        return this.fogDistance;
    }

    public void setFogDistance(float fogDistance) {
        if (this.material != null) {
            this.material.setFloat("FogDistance", fogDistance);
        }
        this.fogDistance = fogDistance;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.fogColor, "fogColor", ColorRGBA.White.clone());
        oc.write(this.fogDensity, "fogDensity", 0.7f);
        oc.write(this.fogDistance, "fogDistance", 1000.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.fogColor = (ColorRGBA)ic.readSavable("fogColor", ColorRGBA.White.clone());
        this.fogDensity = ic.readFloat("fogDensity", 0.7f);
        this.fogDistance = ic.readFloat("fogDistance", 1000.0f);
    }
}

