/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.Timer;

public class NanoTimer
extends Timer {
    private static final long TIMER_RESOLUTION = 1000000000L;
    private static final float INVERSE_TIMER_RESOLUTION = 1.0E-9f;
    private long startTime = System.nanoTime();
    private long previousTime;
    private float tpf;
    private float fps;

    public float getTimeInSeconds() {
        return (float)this.getTime() * 1.0E-9f;
    }

    public long getTime() {
        return System.nanoTime() - this.startTime;
    }

    public long getResolution() {
        return 1000000000L;
    }

    public float getFrameRate() {
        return this.fps;
    }

    public float getTimePerFrame() {
        return this.tpf;
    }

    public void update() {
        this.tpf = (float)(this.getTime() - this.previousTime) * 1.0E-9f;
        this.fps = 1.0f / this.tpf;
        this.previousTime = this.getTime();
    }

    public void reset() {
        this.startTime = System.nanoTime();
        this.previousTime = this.getTime();
    }
}

