/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.FastMath;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.terrain.GeoMap;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class LODGeomap
extends GeoMap {
    public LODGeomap() {
    }

    public LODGeomap(int size, FloatBuffer heightMap) {
        super(heightMap, null, size, size, 1);
    }

    public Mesh createMesh(Vector3f scale, Vector2f tcScale, Vector2f tcOffset, float offsetAmount, int totalSize, boolean center) {
        return this.createMesh(scale, tcScale, tcOffset, offsetAmount, totalSize, center, 1, false, false, false, false);
    }

    public Mesh createMesh(Vector3f scale, Vector2f tcScale, Vector2f tcOffset, float offsetAmount, int totalSize, boolean center, int lod, boolean rightLod, boolean topLod, boolean leftLod, boolean bottomLod) {
        FloatBuffer pb = this.writeVertexArray(null, scale, center);
        FloatBuffer texb = this.writeTexCoordArray(null, tcOffset, tcScale, offsetAmount, totalSize);
        FloatBuffer nb = this.writeNormalArray(null, scale);
        IntBuffer ib = this.writeIndexArrayLodDiff(null, lod, rightLod, topLod, leftLod, bottomLod);
        FloatBuffer bb = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        FloatBuffer tanb = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        this.writeTangentArray(tanb, bb, texb, scale);
        Mesh m = new Mesh();
        m.setMode(Mesh.Mode.TriangleStrip);
        m.setBuffer(VertexBuffer.Type.Position, 3, pb);
        m.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        m.setBuffer(VertexBuffer.Type.Tangent, 3, tanb);
        m.setBuffer(VertexBuffer.Type.Binormal, 3, bb);
        m.setBuffer(VertexBuffer.Type.TexCoord, 2, texb);
        m.setBuffer(VertexBuffer.Type.Index, 3, ib);
        m.setStatic();
        m.updateBound();
        return m;
    }

    protected void removeNormalBuffer() {
        this.ndata = null;
    }

    public FloatBuffer writeTexCoordArray(FloatBuffer store, Vector2f offset, Vector2f scale, float offsetAmount, int totalSize) {
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 2) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 2);
        }
        if (offset == null) {
            offset = new Vector2f();
        }
        Vector2f tcStore = new Vector2f();
        for (int y = this.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.getUV(x, y, tcStore, offset, offsetAmount, totalSize);
                float tx = tcStore.x * scale.x;
                float ty = tcStore.y * scale.y;
                store.put(tx);
                store.put(ty);
            }
        }
        return store;
    }

    public Vector2f getUV(int x, int y, Vector2f store, Vector2f offset, float offsetAmount, int totalSize) {
        float offsetX = offset.x + offsetAmount * 1.0f;
        float offsetY = -offset.y + offsetAmount * 1.0f;
        store.set(((float)x + offsetX) / (float)totalSize, ((float)y + offsetY) / (float)totalSize);
        return store;
    }

    public IntBuffer writeIndexArrayLodDiff(IntBuffer store, int lod, boolean rightLod, boolean topLod, boolean leftLod, boolean bottomLod) {
        int col;
        int row;
        int idx;
        IntBuffer buffer2 = store;
        int numIndexes = this.calculateNumIndexesLodDiff(lod);
        if (store == null) {
            buffer2 = BufferUtils.createIntBuffer(numIndexes);
        }
        VerboseIntBuffer buffer = new VerboseIntBuffer(buffer2);
        for (int r = lod; r < this.getWidth() - 2 * lod; r += lod) {
            int rowIdx = r * this.getWidth();
            int nextRowIdx = (r + 1 * lod) * this.getWidth();
            for (int c = lod; c < this.getWidth() - 1 * lod; c += lod) {
                int idx2 = rowIdx + c;
                buffer.put(idx2);
                idx2 = nextRowIdx + c;
                buffer.put(idx2);
            }
            if (r >= this.getWidth() - 3 * lod) continue;
            idx = nextRowIdx + this.getWidth() - 1 * lod - 1;
            buffer.put(idx);
            idx = nextRowIdx + 1 * lod;
            buffer.put(idx);
        }
        int br = this.getWidth() * (this.getWidth() - lod) - 1 - lod;
        buffer.put(br);
        int corner = this.getWidth() * this.getWidth() - 1;
        buffer.put(corner);
        if (rightLod) {
            for (row = this.getWidth() - lod; row >= 1 + lod; row -= 2 * lod) {
                idx = row * this.getWidth() - 1 - lod;
                buffer.put(idx);
                idx = (row - lod) * this.getWidth() - 1;
                buffer.put(idx);
                if (row <= lod + 1) continue;
                idx = (row - lod) * this.getWidth() - 1 - lod;
                buffer.put(idx);
                idx = (row - lod) * this.getWidth() - 1;
                buffer.put(idx);
            }
        } else {
            buffer.put(corner);
            for (row = this.getWidth() - lod; row > lod; row -= lod) {
                idx = row * this.getWidth() - 1;
                buffer.put(idx);
                buffer.put(idx - lod);
            }
        }
        buffer.put(this.getWidth() - 1);
        if (topLod) {
            if (rightLod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1; col >= lod; col -= 2 * lod) {
                idx = lod * this.getWidth() + col - lod;
                buffer.put(idx);
                idx = col - 2 * lod;
                buffer.put(idx);
                if (col <= lod * 2) continue;
                idx = lod * this.getWidth() + col - 2 * lod;
                buffer.put(idx);
                idx = col - 2 * lod;
                buffer.put(idx);
            }
        } else {
            if (rightLod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1 - lod; col > 0; col -= lod) {
                idx = col + lod * this.getWidth();
                buffer.put(idx);
                idx = col;
                buffer.put(idx);
            }
            buffer.put(0);
        }
        buffer.put(0);
        if (leftLod) {
            if (topLod) {
                buffer.put(0);
            }
            for (row = 0; row < this.getWidth() - lod; row += 2 * lod) {
                idx = (row + lod) * this.getWidth() + lod;
                buffer.put(idx);
                idx = (row + 2 * lod) * this.getWidth();
                buffer.put(idx);
                if (row >= this.getWidth() - lod - 2 - 1) continue;
                idx = (row + 2 * lod) * this.getWidth() + lod;
                buffer.put(idx);
                idx = (row + 2 * lod) * this.getWidth();
                buffer.put(idx);
            }
        } else {
            if (!topLod) {
                buffer.put(0);
            }
            for (row = lod; row < this.getWidth() - lod; row += lod) {
                idx = row * this.getWidth();
                buffer.put(idx);
                idx = row * this.getWidth() + lod;
                buffer.put(idx);
            }
        }
        buffer.put(this.getWidth() * (this.getWidth() - 1));
        if (bottomLod) {
            if (leftLod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = 0; col < this.getWidth() - lod; col += 2 * lod) {
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col + lod;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col + 2 * lod;
                buffer.put(idx);
                if (col >= this.getWidth() - 1 - 2 * lod) continue;
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col + 2 * lod;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col + 2 * lod;
                buffer.put(idx);
            }
        } else {
            if (leftLod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = lod; col < this.getWidth() - lod; col += lod) {
                idx = this.getWidth() * (this.getWidth() - 1 - lod) + col;
                buffer.put(idx);
                idx = this.getWidth() * (this.getWidth() - 1) + col;
                buffer.put(idx);
            }
        }
        buffer.put(this.getWidth() * this.getWidth() - 1);
        for (int i = buffer.getCount(); i < numIndexes; ++i) {
            buffer.put(this.getWidth() * this.getWidth() - 1);
        }
        return buffer.delegate;
    }

    public IntBuffer writeIndexArrayLodVariable(IntBuffer store, int lod, int rightLod, int topLod, int leftLod, int bottomLod) {
        int col;
        int row;
        int idxB;
        int j;
        int i;
        int lodDiff;
        int it;
        int idx;
        int idx2;
        IntBuffer buffer2 = store;
        int numIndexes = this.calculateNumIndexesLodDiff(lod);
        if (store == null) {
            buffer2 = BufferUtils.createIntBuffer(numIndexes);
        }
        VerboseIntBuffer buffer = new VerboseIntBuffer(buffer2);
        for (int r = lod; r < this.getWidth() - 2 * lod; r += lod) {
            int rowIdx = r * this.getWidth();
            int nextRowIdx = (r + 1 * lod) * this.getWidth();
            for (int c = lod; c < this.getWidth() - 1 * lod; c += lod) {
                int idx3 = rowIdx + c;
                buffer.put(idx3);
                idx3 = nextRowIdx + c;
                buffer.put(idx3);
            }
            if (r >= this.getWidth() - 3 * lod) continue;
            idx2 = nextRowIdx + this.getWidth() - 1 * lod - 1;
            buffer.put(idx2);
            idx2 = nextRowIdx + 1 * lod;
            buffer.put(idx2);
        }
        int br = this.getWidth() * (this.getWidth() - lod) - 1 - lod;
        buffer.put(br);
        int corner = this.getWidth() * this.getWidth() - 1;
        buffer.put(corner);
        if (rightLod > lod) {
            idx = corner;
            it = (this.getWidth() - 1) / rightLod;
            lodDiff = rightLod / lod;
            for (i = it; i > 0; --i) {
                idx = this.getWidth() * (i * rightLod + 1) - 1;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx - this.getWidth() * (j * lod) - lod;
                    if (j == lodDiff && i == 1) {
                        buffer.put(this.getWidth() - 1);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idxB + lod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
            buffer.put(this.getWidth() * (lod + 1) - lod - 1);
            buffer.put(this.getWidth() - 1);
        } else {
            buffer.put(corner);
            for (row = this.getWidth() - lod; row > lod; row -= lod) {
                idx2 = row * this.getWidth() - 1;
                buffer.put(idx2);
                buffer.put(idx2 - lod);
            }
            buffer.put(this.getWidth() - 1);
        }
        if (topLod > lod) {
            if (rightLod > lod) {
                buffer.put(this.getWidth() - 1);
                buffer.put(this.getWidth() * lod - 1);
                buffer.put(this.getWidth() - 1);
            }
            idx = this.getWidth() - 1;
            it = (this.getWidth() - 1) / topLod;
            lodDiff = topLod / lod;
            for (i = it; i > 0; --i) {
                idx = i * topLod;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = lod * this.getWidth() + i * topLod - j * lod;
                    if (j == lodDiff && i == 1) {
                        buffer.put(0);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idx - topLod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            if (rightLod > lod) {
                buffer.put(this.getWidth() - 1);
            }
            for (col = this.getWidth() - 1 - lod; col > 0; col -= lod) {
                idx2 = col + lod * this.getWidth();
                buffer.put(idx2);
                idx2 = col;
                buffer.put(idx2);
            }
            buffer.put(0);
        }
        buffer.put(0);
        if (leftLod > lod) {
            idx = 0;
            it = (this.getWidth() - 1) / leftLod;
            lodDiff = leftLod / lod;
            for (i = 0; i < it; ++i) {
                idx = this.getWidth() * (i * leftLod);
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx + this.getWidth() * (j * lod) + lod;
                    if (j == lodDiff && i == it - 1) {
                        buffer.put(this.getWidth() * this.getWidth() - this.getWidth());
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idxB - lod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            buffer.put(0);
            buffer.put(this.getWidth() * lod + lod);
            buffer.put(0);
            for (row = lod; row < this.getWidth() - lod; row += lod) {
                idx2 = row * this.getWidth();
                buffer.put(idx2);
                idx2 = row * this.getWidth() + lod;
                buffer.put(idx2);
            }
            buffer.put(this.getWidth() * (this.getWidth() - 1));
        }
        if (bottomLod > lod) {
            if (leftLod > lod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
                buffer.put(this.getWidth() * (this.getWidth() - lod));
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            idx = this.getWidth() * this.getWidth() - this.getWidth();
            it = (this.getWidth() - 1) / bottomLod;
            lodDiff = bottomLod / lod;
            for (i = 0; i < it; ++i) {
                idx = this.getWidth() * this.getWidth() - this.getWidth() + i * bottomLod;
                for (j = 1; j <= lodDiff; ++j) {
                    idxB = idx - this.getWidth() * lod + j * lod;
                    if (j == lodDiff && i == it - 1) {
                        buffer.put(this.getWidth() * this.getWidth() - 1);
                        continue;
                    }
                    if (j == lodDiff) {
                        buffer.put(idxB);
                        buffer.put(idx + bottomLod);
                        continue;
                    }
                    buffer.put(idxB);
                    buffer.put(idx);
                }
            }
        } else {
            if (leftLod > lod) {
                buffer.put(this.getWidth() * (this.getWidth() - 1));
                buffer.put(this.getWidth() * this.getWidth() - this.getWidth() * lod + lod);
                buffer.put(this.getWidth() * (this.getWidth() - 1));
            }
            for (col = lod; col < this.getWidth() - lod; col += lod) {
                idx2 = this.getWidth() * (this.getWidth() - 1 - lod) + col;
                buffer.put(idx2);
                idx2 = this.getWidth() * (this.getWidth() - 1) + col;
                buffer.put(idx2);
            }
        }
        buffer.put(this.getWidth() * this.getWidth() - 1);
        for (int i2 = buffer.getCount(); i2 < numIndexes; ++i2) {
            buffer.put(this.getWidth() * this.getWidth() - 1);
        }
        return buffer.delegate;
    }

    private int calculateNumIndexesLodDiff(int lod) {
        if (lod == 0) {
            lod = 1;
        }
        int length = this.getWidth() - 1;
        int side = length / lod + 1 - 2;
        int num = side * side * 2;
        num -= 2 * side;
        int degenerates = 2 * (side - 2);
        num += degenerates;
        num += this.getWidth() / lod * 2 * 4;
        ++num;
        return num += 10;
    }

    public FloatBuffer[] writeTangentArray(FloatBuffer tangentStore, FloatBuffer binormalStore, FloatBuffer textureBuffer, Vector3f scale) {
        if (!this.isLoaded()) {
            throw new NullPointerException();
        }
        if (tangentStore != null) {
            if (tangentStore.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            tangentStore = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        tangentStore.rewind();
        if (binormalStore != null) {
            if (binormalStore.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            binormalStore = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        binormalStore.rewind();
        Vector3f tangent = new Vector3f();
        Vector3f binormal = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        Vector2f t1 = new Vector2f();
        Vector2f t2 = new Vector2f();
        Vector2f t3 = new Vector2f();
        scale = Vector3f.UNIT_XYZ;
        for (int r = 0; r < this.getHeight(); ++r) {
            for (int c = 0; c < this.getWidth(); ++c) {
                int texIdx = ((this.getHeight() - 1 - r) * this.getWidth() + c) * 2;
                int texIdxPrev = ((this.getHeight() - 1 - (r - 1)) * this.getWidth() + c) * 2;
                int texIdxNext = ((this.getHeight() - 1 - (r + 1)) * this.getWidth() + c) * 2;
                v1.set(c, this.getValue(c, r), r);
                t1.set(textureBuffer.get(texIdx), textureBuffer.get(texIdx + 1));
                if (r == 0) {
                    v3.set(c, this.getValue(c, r), r);
                    t3.set(textureBuffer.get(texIdxNext), textureBuffer.get(texIdxNext + 1));
                } else {
                    v3.set(c, this.getValue(c, r - 1), r - 1);
                    t3.set(textureBuffer.get(texIdxPrev), textureBuffer.get(texIdxPrev + 1));
                }
                if (c == this.getWidth() - 1) {
                    v2.set(c + 1, this.getValue(c, r), r);
                    t2.set(textureBuffer.get(texIdx), textureBuffer.get(texIdx + 1));
                } else {
                    v2.set(c + 1, this.getValue(c + 1, r), r);
                    t2.set(textureBuffer.get(texIdx + 2), textureBuffer.get(texIdx + 3));
                }
                LODGeomap.calculateTangent(new Vector3f[]{v1.mult(scale), v2.mult(scale), v3.mult(scale)}, new Vector2f[]{t1, t2, t3}, tangent, binormal);
                BufferUtils.setInBuffer(tangent, tangentStore, r * this.getWidth() + c);
                BufferUtils.setInBuffer(binormal, binormalStore, r * this.getWidth() + c);
            }
        }
        return new FloatBuffer[]{tangentStore, binormalStore};
    }

    public static Vector3f calculateTangent(Vector3f[] v, Vector2f[] t, Vector3f tangent, Vector3f binormal) {
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector2f edge1uv = new Vector2f();
        Vector2f edge2uv = new Vector2f();
        t[2].subtract(t[0], edge2uv);
        t[1].subtract(t[0], edge1uv);
        float det = edge1uv.x * edge2uv.y;
        boolean normalize = true;
        if (Math.abs(det) < 1.0E-7f) {
            det = 1.0f;
            normalize = true;
        }
        v[1].subtract(v[0], edge1);
        v[2].subtract(v[0], edge2);
        tangent.set(edge1);
        tangent.normalizeLocal();
        binormal.set(edge2);
        binormal.normalizeLocal();
        float factor = 1.0f / det;
        tangent.x = edge2uv.y * edge1.x * factor;
        tangent.y = 0.0f;
        tangent.z = edge2uv.y * edge1.z * factor;
        if (normalize) {
            tangent.normalizeLocal();
        }
        binormal.x = 0.0f;
        binormal.y = edge1uv.x * edge2.y * factor;
        binormal.z = edge1uv.x * edge2.z * factor;
        if (normalize) {
            binormal.normalizeLocal();
        }
        return tangent;
    }

    public FloatBuffer writeNormalArray(FloatBuffer store, Vector3f scale) {
        if (!this.isLoaded()) {
            throw new NullPointerException();
        }
        if (store != null) {
            if (store.remaining() < this.getWidth() * this.getHeight() * 3) {
                throw new BufferUnderflowException();
            }
        } else {
            store = BufferUtils.createFloatBuffer(this.getWidth() * this.getHeight() * 3);
        }
        store.rewind();
        Vector3f rootPoint = new Vector3f();
        Vector3f rightPoint = new Vector3f();
        Vector3f leftPoint = new Vector3f();
        Vector3f topPoint = new Vector3f();
        Vector3f bottomPoint = new Vector3f();
        for (int r = 0; r < this.getHeight(); ++r) {
            for (int c = 0; c < this.getWidth(); ++c) {
                Vector3f n2;
                Vector3f n1;
                rootPoint.set(c, this.getValue(c, r), r);
                Vector3f normal = new Vector3f();
                if (r == 0) {
                    if (c == 0) {
                        rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                        bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                        normal.set(this.getNormal(bottomPoint, rootPoint, rightPoint, scale));
                    } else if (c == this.getWidth() - 1) {
                        leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                        bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                        normal.set(this.getNormal(leftPoint, rootPoint, bottomPoint, scale));
                    } else {
                        leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                        rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                        bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                        n1 = this.getNormal(leftPoint, rootPoint, bottomPoint, scale);
                        n2 = this.getNormal(bottomPoint, rootPoint, rightPoint, scale);
                        normal.set(n1.add(n2).normalizeLocal());
                    }
                } else if (r == this.getHeight() - 1) {
                    if (c == 0) {
                        topPoint.set(c, this.getValue(c, r - 1), r - 1);
                        rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                        normal.set(this.getNormal(rightPoint, rootPoint, topPoint, scale));
                    } else if (c == this.getWidth() - 1) {
                        topPoint.set(c, this.getValue(c, r - 1), r - 1);
                        leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                        normal.set(this.getNormal(topPoint, rootPoint, leftPoint, scale));
                    } else {
                        topPoint.set(c, this.getValue(c, r - 1), r - 1);
                        leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                        rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                        n1 = this.getNormal(topPoint, rootPoint, leftPoint, scale);
                        n2 = this.getNormal(rightPoint, rootPoint, topPoint, scale);
                        normal.set(n1.add(n2).normalizeLocal());
                    }
                } else if (c == 0) {
                    topPoint.set(c, this.getValue(c, r - 1), r - 1);
                    rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                    bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                    n1 = this.getNormal(rightPoint, rootPoint, topPoint, scale);
                    n2 = this.getNormal(bottomPoint, rootPoint, rightPoint, scale);
                    normal.set(n1.add(n2).normalizeLocal());
                } else if (c == this.getWidth() - 1) {
                    topPoint.set(c, this.getValue(c, r - 1), r - 1);
                    leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                    bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                    n1 = this.getNormal(topPoint, rootPoint, leftPoint, scale);
                    n2 = this.getNormal(leftPoint, rootPoint, bottomPoint, scale);
                    normal.set(n1.add(n2).normalizeLocal());
                } else {
                    topPoint.set(c, this.getValue(c, r - 1), r - 1);
                    leftPoint.set(c - 1, this.getValue(c - 1, r), r);
                    rightPoint.set(c + 1, this.getValue(c + 1, r), r);
                    bottomPoint.set(c, this.getValue(c, r + 1), r + 1);
                    n1 = this.getNormal(topPoint, rootPoint, leftPoint, scale);
                    n2 = this.getNormal(leftPoint, rootPoint, bottomPoint, scale);
                    Vector3f n3 = this.getNormal(bottomPoint, rootPoint, rightPoint, scale);
                    Vector3f n4 = this.getNormal(rightPoint, rootPoint, topPoint, scale);
                    normal.set(n1.add(n2).add(n3).add(n4).normalizeLocal());
                }
                BufferUtils.setInBuffer(normal, store, r * this.getWidth() + c);
            }
        }
        return store;
    }

    private Vector3f getNormal(Vector3f firstPoint, Vector3f rootPoint, Vector3f secondPoint, Vector3f scale) {
        Vector3f normal = new Vector3f();
        normal.set(firstPoint.mult(scale)).subtractLocal(rootPoint.mult(scale)).crossLocal(secondPoint.mult(scale).subtract(rootPoint.mult(scale))).normalizeLocal();
        return normal;
    }

    protected Triangle getTriangleAtPoint(float x, float z, Vector3f scale, Vector3f translation) {
        Triangle tri = this.getTriangleAtPoint(x, z);
        if (tri != null) {
            tri.get1().multLocal(scale).addLocal(translation);
            tri.get2().multLocal(scale).addLocal(translation);
            tri.get3().multLocal(scale).addLocal(translation);
        }
        return tri;
    }

    protected Triangle[] getGridTrianglesAtPoint(float x, float z, Vector3f scale, Vector3f translation) {
        Triangle[] tris = this.getGridTrianglesAtPoint(x, z);
        if (tris != null) {
            tris[0].get1().multLocal(scale).addLocal(translation);
            tris[0].get2().multLocal(scale).addLocal(translation);
            tris[0].get3().multLocal(scale).addLocal(translation);
            tris[1].get1().multLocal(scale).addLocal(translation);
            tris[1].get2().multLocal(scale).addLocal(translation);
            tris[1].get3().multLocal(scale).addLocal(translation);
        }
        return tris;
    }

    protected Triangle[] getGridTrianglesAtPoint(float x, float z) {
        int gridX = (int)x;
        int gridY = (int)z;
        int index = this.findClosestHeightIndex(gridX, gridY);
        if (index < 0) {
            return null;
        }
        Triangle t = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
        Triangle t2 = new Triangle(new Vector3f(), new Vector3f(), new Vector3f());
        float h1 = this.hdata.get(index);
        float h2 = this.hdata.get(index + 1);
        float h3 = this.hdata.get(index + this.width);
        float h4 = this.hdata.get(index + this.width + 1);
        if (gridX == 0 && gridY == 0 || gridX == this.width - 1 && gridY == this.width - 1) {
            t.get((int)0).x = gridX;
            t.get((int)0).y = h1;
            t.get((int)0).z = gridY;
            t.get((int)1).x = gridX;
            t.get((int)1).y = h3;
            t.get((int)1).z = gridY + 1;
            t.get((int)2).x = gridX + 1;
            t.get((int)2).y = h4;
            t.get((int)2).z = gridY + 1;
            t2.get((int)0).x = gridX;
            t2.get((int)0).y = h1;
            t2.get((int)0).z = gridY;
            t2.get((int)1).x = gridX + 1;
            t2.get((int)1).y = h4;
            t2.get((int)1).z = gridY + 1;
            t2.get((int)2).x = gridX + 1;
            t2.get((int)2).y = h2;
            t2.get((int)2).z = gridY;
        } else {
            t.get((int)0).x = gridX;
            t.get((int)0).y = h1;
            t.get((int)0).z = gridY;
            t.get((int)1).x = gridX;
            t.get((int)1).y = h3;
            t.get((int)1).z = gridY + 1;
            t.get((int)2).x = gridX + 1;
            t.get((int)2).y = h2;
            t.get((int)2).z = gridY;
            t2.get((int)0).x = gridX + 1;
            t2.get((int)0).y = h2;
            t2.get((int)0).z = gridY;
            t2.get((int)1).x = gridX;
            t2.get((int)1).y = h3;
            t2.get((int)1).z = gridY + 1;
            t2.get((int)2).x = gridX + 1;
            t2.get((int)2).y = h4;
            t2.get((int)2).z = gridY + 1;
        }
        return new Triangle[]{t, t2};
    }

    protected Triangle getTriangleAtPoint(float x, float z) {
        Triangle[] triangles = this.getGridTrianglesAtPoint(x, z);
        if (triangles == null) {
            System.out.println("x,z: " + x + "," + z);
            return null;
        }
        Vector2f t1 = new Vector2f(triangles[0].get1().x, triangles[0].get1().z);
        Vector2f t2 = new Vector2f(triangles[0].get2().x, triangles[0].get2().z);
        Vector2f t3 = new Vector2f(triangles[0].get3().x, triangles[0].get3().z);
        Vector2f point = new Vector2f(x, z);
        if (0 != FastMath.pointInsideTriangle(t1, t2, t3, point)) {
            return triangles[0];
        }
        t1.set(triangles[1].get1().x, triangles[1].get1().z);
        t1.set(triangles[1].get2().x, triangles[1].get2().z);
        t1.set(triangles[1].get3().x, triangles[1].get3().z);
        if (0 != FastMath.pointInsideTriangle(t1, t2, t3, point)) {
            return triangles[1];
        }
        return null;
    }

    protected int findClosestHeightIndex(int x, int z) {
        if (x < 0 || x >= this.width - 1) {
            return -1;
        }
        if (z < 0 || z >= this.width - 1) {
            return -1;
        }
        return z * this.width + x;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
    }

    public class VerboseIntBuffer {
        private IntBuffer delegate;
        int count = 0;

        public VerboseIntBuffer(IntBuffer d) {
            this.delegate = d;
        }

        public void put(int value) {
            try {
                this.delegate.put(value);
                ++this.count;
            }
            catch (BufferOverflowException bufferOverflowException) {
                // empty catch block
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

