/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.RagdollCollisionListener;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.ragdoll.HumanoidRagdollPreset;
import com.jme3.bullet.control.ragdoll.RagdollPreset;
import com.jme3.bullet.control.ragdoll.RagdollUtils;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KinematicRagdollControl
implements PhysicsControl,
PhysicsCollisionListener {
    protected static final Logger logger = Logger.getLogger(KinematicRagdollControl.class.getName());
    protected Map<String, PhysicsBoneLink> boneLinks = new HashMap<String, PhysicsBoneLink>();
    protected Skeleton skeleton;
    protected PhysicsSpace space;
    protected boolean enabled = true;
    protected boolean debug = false;
    protected PhysicsRigidBody baseRigidBody;
    protected float weightThreshold = -1.0f;
    protected Spatial targetModel;
    protected Vector3f initScale;
    protected Mode mode = Mode.Kinetmatic;
    protected boolean blendedControl = false;
    protected float blendTime = 1.0f;
    protected float blendStart = 0.0f;
    protected List<RagdollCollisionListener> listeners;
    protected float eventDispatchImpulseThreshold = 10.0f;
    protected RagdollPreset preset = new HumanoidRagdollPreset();
    protected Set<String> boneList = new TreeSet<String>();
    protected Vector3f modelPosition = new Vector3f();
    protected Quaternion modelRotation = new Quaternion();
    protected float rootMass = 15.0f;
    protected float totalMass = 0.0f;
    protected boolean added = false;

    public KinematicRagdollControl() {
    }

    public KinematicRagdollControl(float f) {
        this.weightThreshold = f;
    }

    public KinematicRagdollControl(RagdollPreset ragdollPreset, float f) {
        this.preset = ragdollPreset;
        this.weightThreshold = f;
    }

    public KinematicRagdollControl(RagdollPreset ragdollPreset) {
        this.preset = ragdollPreset;
    }

    public void update(float f) {
        if (!this.enabled) {
            return;
        }
        TempVars tempVars = TempVars.get();
        assert (tempVars.lock());
        Quaternion quaternion = tempVars.quat1;
        Quaternion quaternion2 = tempVars.quat2;
        if (this.mode == Mode.Ragdoll) {
            for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
                Vector3f vector3f = tempVars.vect1;
                Vector3f vector3f2 = physicsBoneLink.rigidBody.getMotionState().getWorldLocation();
                this.targetModel.getWorldTransform().transformInverseVector(vector3f2, vector3f);
                Quaternion quaternion3 = physicsBoneLink.rigidBody.getMotionState().getWorldRotationQuat();
                quaternion.set(quaternion3).multLocal(physicsBoneLink.initalWorldRotation);
                quaternion2.set(this.targetModel.getWorldRotation()).inverseLocal().mult(quaternion, quaternion);
                quaternion.normalizeLocal();
                if (physicsBoneLink.bone.getParent() == null) {
                    this.modelPosition.set(vector3f2).subtractLocal(physicsBoneLink.bone.getInitialPos());
                    this.modelRotation.set(quaternion3).multLocal(quaternion2.set(physicsBoneLink.bone.getInitialRot()).inverseLocal());
                    this.targetModel.setLocalTranslation(this.modelPosition);
                    this.targetModel.setLocalRotation(this.modelRotation);
                    physicsBoneLink.bone.setUserTransformsWorld(vector3f, quaternion);
                    continue;
                }
                if (this.boneList.isEmpty()) {
                    physicsBoneLink.bone.setUserTransformsWorld(vector3f, quaternion);
                    continue;
                }
                RagdollUtils.setTransform(physicsBoneLink.bone, vector3f, quaternion, false, this.boneList);
            }
        } else {
            for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
                Vector3f vector3f = tempVars.vect1;
                if (this.blendedControl) {
                    Vector3f vector3f3 = tempVars.vect2;
                    vector3f.set(physicsBoneLink.startBlendingPos);
                    quaternion.set(physicsBoneLink.startBlendingRot);
                    quaternion2.set(quaternion).slerp(physicsBoneLink.bone.getModelSpaceRotation(), this.blendStart / this.blendTime);
                    vector3f3.set(vector3f).interpolate(physicsBoneLink.bone.getModelSpacePosition(), this.blendStart / this.blendTime);
                    quaternion.set(quaternion2);
                    vector3f.set(vector3f3);
                    if (this.boneList.isEmpty()) {
                        physicsBoneLink.bone.setUserControl(true);
                        physicsBoneLink.bone.setUserTransformsWorld(vector3f, quaternion);
                        physicsBoneLink.bone.setUserControl(false);
                    } else {
                        RagdollUtils.setTransform(physicsBoneLink.bone, vector3f, quaternion, true, this.boneList);
                    }
                }
                this.matchPhysicObjectToBone(physicsBoneLink, vector3f, quaternion);
            }
            if (this.blendedControl) {
                this.blendStart += f;
                if (this.blendStart > this.blendTime) {
                    this.blendedControl = false;
                }
            }
        }
        assert (tempVars.unlock());
    }

    private void matchPhysicObjectToBone(PhysicsBoneLink physicsBoneLink, Vector3f vector3f, Quaternion quaternion) {
        this.targetModel.getWorldTransform().transformVector(physicsBoneLink.bone.getModelSpacePosition(), vector3f);
        quaternion.set(physicsBoneLink.bone.getModelSpaceRotation()).multLocal(physicsBoneLink.bone.getWorldBindInverseRotation());
        this.targetModel.getWorldRotation().mult(quaternion, quaternion);
        quaternion.normalizeLocal();
        physicsBoneLink.rigidBody.setPhysicsLocation(vector3f);
        physicsBoneLink.rigidBody.setPhysicsRotation(quaternion);
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reBuild() {
        this.setSpatial(this.targetModel);
        this.addToPhysicsSpace();
    }

    public void setSpatial(Spatial spatial) {
        if (spatial == null) {
            this.removeFromPhysicsSpace();
            this.clearData();
            return;
        }
        this.targetModel = spatial;
        Node node = spatial.getParent();
        Vector3f vector3f = spatial.getLocalTranslation().clone();
        Quaternion quaternion = spatial.getLocalRotation().clone();
        this.initScale = spatial.getLocalScale().clone();
        spatial.removeFromParent();
        spatial.setLocalTranslation(Vector3f.ZERO);
        spatial.setLocalRotation(Quaternion.IDENTITY);
        spatial.setLocalScale(1.0f);
        SkeletonControl skeletonControl = (SkeletonControl)spatial.getControl(SkeletonControl.class);
        spatial.removeControl((Control)skeletonControl);
        spatial.addControl((Control)skeletonControl);
        this.removeFromPhysicsSpace();
        this.clearData();
        this.scanSpatial(spatial);
        if (node != null) {
            node.attachChild(spatial);
        }
        spatial.setLocalTranslation(vector3f);
        spatial.setLocalRotation(quaternion);
        spatial.setLocalScale(this.initScale);
        logger.log(Level.INFO, "Created physics ragdoll for skeleton {0}", this.skeleton);
    }

    public void addBoneName(String string) {
        this.boneList.add(string);
    }

    private void scanSpatial(Spatial spatial) {
        AnimControl animControl = (AnimControl)spatial.getControl(AnimControl.class);
        Map<Integer, List<Float>> map = null;
        if (this.weightThreshold == -1.0f) {
            map = RagdollUtils.buildPointMap(spatial);
        }
        this.skeleton = animControl.getSkeleton();
        this.skeleton.resetAndUpdate();
        for (int i = 0; i < this.skeleton.getRoots().length; ++i) {
            Bone bone = this.skeleton.getRoots()[i];
            if (bone.getParent() != null) continue;
            logger.log(Level.INFO, "Found root bone in skeleton {0}", this.skeleton);
            this.baseRigidBody = new PhysicsRigidBody(new BoxCollisionShape(Vector3f.UNIT_XYZ.mult(0.1f)), 1.0f);
            this.baseRigidBody.setKinematic(this.mode == Mode.Kinetmatic);
            this.boneRecursion(spatial, bone, this.baseRigidBody, 1, map);
        }
    }

    private void boneRecursion(Spatial spatial, Bone bone, PhysicsRigidBody physicsRigidBody, int n, Map<Integer, List<Float>> map) {
        PhysicsRigidBody physicsRigidBody2 = physicsRigidBody;
        if (this.boneList.isEmpty() || this.boneList.contains(bone.getName())) {
            PhysicsBoneLink physicsBoneLink = new PhysicsBoneLink();
            physicsBoneLink.bone = bone;
            Object object = null;
            object = map != null ? RagdollUtils.makeShapeFromPointMap(map, RagdollUtils.getBoneIndices(physicsBoneLink.bone, this.skeleton, this.boneList), this.initScale, physicsBoneLink.bone.getModelSpacePosition()) : RagdollUtils.makeShapeFromVerticeWeights(spatial, RagdollUtils.getBoneIndices(physicsBoneLink.bone, this.skeleton, this.boneList), this.initScale, physicsBoneLink.bone.getModelSpacePosition(), this.weightThreshold);
            PhysicsRigidBody physicsRigidBody3 = new PhysicsRigidBody((CollisionShape)object, this.rootMass / (float)n);
            physicsRigidBody3.setKinematic(this.mode == Mode.Kinetmatic);
            this.totalMass += this.rootMass / (float)n;
            physicsBoneLink.rigidBody = physicsRigidBody3;
            physicsBoneLink.initalWorldRotation = bone.getModelSpaceRotation().clone();
            if (physicsRigidBody != null) {
                Vector3f vector3f = new Vector3f();
                if (bone.getParent() != null) {
                    bone.getModelSpacePosition().subtract(bone.getParent().getModelSpacePosition(), vector3f).multLocal(this.initScale);
                }
                SixDofJoint sixDofJoint = new SixDofJoint(physicsRigidBody, physicsRigidBody3, vector3f, new Vector3f(0.0f, 0.0f, 0.0f), true);
                this.preset.setupJointForBone(bone.getName(), sixDofJoint);
                physicsBoneLink.joint = sixDofJoint;
                sixDofJoint.setCollisionBetweenLinkedBodys(false);
            }
            this.boneLinks.put(bone.getName(), physicsBoneLink);
            physicsRigidBody3.setUserObject(physicsBoneLink);
            physicsRigidBody2 = physicsRigidBody3;
        }
        for (Object object : bone.getChildren()) {
            this.boneRecursion(spatial, (Bone)object, physicsRigidBody2, n + 1, map);
        }
    }

    public void setJointLimit(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        PhysicsBoneLink physicsBoneLink = this.boneLinks.get(string);
        if (physicsBoneLink != null) {
            RagdollUtils.setJointLimit(physicsBoneLink.joint, f, f2, f3, f4, f5, f6);
        } else {
            logger.log(Level.WARNING, "Not joint was found for bone {0}. make sure you call spatial.addControl(ragdoll) before setting joints limit", string);
        }
    }

    public SixDofJoint getJoint(String string) {
        PhysicsBoneLink physicsBoneLink = this.boneLinks.get(string);
        if (physicsBoneLink != null) {
            return physicsBoneLink.joint;
        }
        logger.log(Level.WARNING, "Not joint was found for bone {0}. make sure you call spatial.addControl(ragdoll) before setting joints limit", string);
        return null;
    }

    private void clearData() {
        this.boneLinks.clear();
        this.baseRigidBody = null;
    }

    private void addToPhysicsSpace() {
        if (this.space == null) {
            return;
        }
        if (this.baseRigidBody != null) {
            this.space.add(this.baseRigidBody);
            this.added = true;
        }
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            if (physicsBoneLink.rigidBody == null) continue;
            this.space.add(physicsBoneLink.rigidBody);
            if (physicsBoneLink.joint != null) {
                this.space.add(physicsBoneLink.joint);
            }
            this.added = true;
        }
    }

    protected void removeFromPhysicsSpace() {
        if (this.space == null) {
            return;
        }
        if (this.baseRigidBody != null) {
            this.space.remove(this.baseRigidBody);
        }
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            if (physicsBoneLink.joint == null) continue;
            this.space.remove(physicsBoneLink.joint);
            if (physicsBoneLink.rigidBody == null) continue;
            this.space.remove(physicsBoneLink.rigidBody);
        }
        this.added = false;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        if (!bl && this.space != null) {
            this.removeFromPhysicsSpace();
        } else if (bl && this.space != null) {
            this.addToPhysicsSpace();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void attachDebugShape(AssetManager assetManager) {
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            physicsBoneLink.rigidBody.createDebugShape(assetManager);
        }
        this.debug = true;
    }

    protected void detachDebugShape() {
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            physicsBoneLink.rigidBody.detachDebugShape();
        }
        this.debug = false;
    }

    public void render(RenderManager renderManager, ViewPort viewPort) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (!this.debug) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
                Spatial spatial = physicsBoneLink.rigidBody.debugShape();
                if (spatial == null) continue;
                spatial.setLocalTranslation(physicsBoneLink.rigidBody.getMotionState().getWorldLocation());
                spatial.setLocalRotation(physicsBoneLink.rigidBody.getMotionState().getWorldRotationQuat());
                spatial.updateGeometricState();
                renderManager.renderScene(spatial, viewPort);
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace physicsSpace) {
        if (physicsSpace == null) {
            this.removeFromPhysicsSpace();
            this.space = physicsSpace;
        } else {
            if (this.space == physicsSpace) {
                return;
            }
            this.space = physicsSpace;
            this.addToPhysicsSpace();
        }
        this.space.addCollisionListener(this);
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    public void write(JmeExporter jmeExporter) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void read(JmeImporter jmeImporter) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void collision(PhysicsCollisionEvent physicsCollisionEvent) {
        Object object;
        PhysicsCollisionObject physicsCollisionObject = physicsCollisionEvent.getObjectA();
        PhysicsCollisionObject physicsCollisionObject2 = physicsCollisionEvent.getObjectB();
        if (physicsCollisionEvent.getNodeA() == null && physicsCollisionEvent.getNodeB() == null) {
            return;
        }
        if (physicsCollisionEvent.getAppliedImpulse() < this.eventDispatchImpulseThreshold) {
            return;
        }
        boolean bl = false;
        Bone bone = null;
        PhysicsCollisionObject physicsCollisionObject3 = null;
        if (physicsCollisionObject.getUserObject() instanceof PhysicsBoneLink && (object = (PhysicsBoneLink)physicsCollisionObject.getUserObject()) != null) {
            bl = true;
            bone = ((PhysicsBoneLink)object).bone;
            physicsCollisionObject3 = physicsCollisionObject2;
        }
        if (physicsCollisionObject2.getUserObject() instanceof PhysicsBoneLink && (object = (PhysicsBoneLink)physicsCollisionObject2.getUserObject()) != null) {
            bl = true;
            bone = ((PhysicsBoneLink)object).bone;
            physicsCollisionObject3 = physicsCollisionObject;
        }
        if (bl) {
            for (RagdollCollisionListener ragdollCollisionListener : this.listeners) {
                ragdollCollisionListener.collide(bone, physicsCollisionObject3, physicsCollisionEvent);
            }
        }
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
        AnimControl animControl = (AnimControl)this.targetModel.getControl(AnimControl.class);
        animControl.setEnabled(mode == Mode.Kinetmatic);
        this.baseRigidBody.setKinematic(mode == Mode.Kinetmatic);
        TempVars tempVars = TempVars.get();
        assert (tempVars.lock());
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            physicsBoneLink.rigidBody.setKinematic(mode == Mode.Kinetmatic);
            if (mode != Mode.Ragdoll) continue;
            Quaternion quaternion = tempVars.quat1;
            Bone bone = tempVars.vect1;
            this.matchPhysicObjectToBone(physicsBoneLink, (Vector3f)bone, quaternion);
        }
        assert (tempVars.unlock());
        for (Bone bone : this.skeleton.getRoots()) {
            RagdollUtils.setUserControl(bone, mode == Mode.Ragdoll);
        }
    }

    public void blendToKinematicMode(float f) {
        if (this.mode == Mode.Kinetmatic) {
            return;
        }
        this.blendedControl = true;
        this.blendTime = f;
        this.mode = Mode.Kinetmatic;
        AnimControl animControl = (AnimControl)this.targetModel.getControl(AnimControl.class);
        animControl.setEnabled(true);
        TempVars tempVars = TempVars.get();
        assert (tempVars.lock());
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            Vector3f vector3f = physicsBoneLink.rigidBody.getMotionState().getWorldLocation();
            Vector3f vector3f2 = tempVars.vect1;
            this.targetModel.getWorldTransform().transformInverseVector(vector3f, vector3f2);
            Quaternion quaternion = physicsBoneLink.rigidBody.getMotionState().getWorldRotationQuat();
            Quaternion quaternion2 = tempVars.quat1;
            Quaternion quaternion3 = tempVars.quat2;
            quaternion2.set(quaternion).multLocal(physicsBoneLink.initalWorldRotation).normalizeLocal();
            quaternion3.set(this.targetModel.getWorldRotation()).inverseLocal().mult(quaternion2, quaternion2);
            quaternion2.normalizeLocal();
            physicsBoneLink.startBlendingPos.set(vector3f2);
            physicsBoneLink.startBlendingRot.set(quaternion2);
            physicsBoneLink.rigidBody.setKinematic(true);
        }
        assert (tempVars.unlock());
        for (Bone bone : this.skeleton.getRoots()) {
            RagdollUtils.setUserControl(bone, false);
        }
        this.blendStart = 0.0f;
    }

    public void setKinematicMode() {
        if (this.mode != Mode.Kinetmatic) {
            this.setMode(Mode.Kinetmatic);
        }
    }

    public void setRagdollMode() {
        if (this.mode != Mode.Ragdoll) {
            this.setMode(Mode.Ragdoll);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addCollisionListener(RagdollCollisionListener ragdollCollisionListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RagdollCollisionListener>();
        }
        this.listeners.add(ragdollCollisionListener);
    }

    public void setRootMass(float f) {
        this.rootMass = f;
    }

    public float getTotalMass() {
        return this.totalMass;
    }

    public float getWeightThreshold() {
        return this.weightThreshold;
    }

    public void setWeightThreshold(float f) {
        this.weightThreshold = f;
    }

    public float getEventDispatchImpulseThreshold() {
        return this.eventDispatchImpulseThreshold;
    }

    public void setEventDispatchImpulseThreshold(float f) {
        this.eventDispatchImpulseThreshold = f;
    }

    protected class PhysicsBoneLink {
        protected Bone bone;
        protected Quaternion initalWorldRotation;
        protected SixDofJoint joint;
        protected PhysicsRigidBody rigidBody;
        protected Quaternion startBlendingRot = new Quaternion();
        protected Vector3f startBlendingPos = new Vector3f();

        protected PhysicsBoneLink() {
        }
    }

    public static enum Mode {
        Kinetmatic,
        Ragdoll;

    }
}

