/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Point2PointJoint
extends PhysicsJoint {
    public Point2PointJoint() {
    }

    public Point2PointJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.createJoint();
    }

    public void setDamping(float f) {
        this.setDamping(this.objectId, f);
    }

    private native void setDamping(long var1, float var3);

    public void setImpulseClamp(float f) {
        this.setImpulseClamp(this.objectId, f);
    }

    private native void setImpulseClamp(long var1, float var3);

    public void setTau(float f) {
        this.setTau(this.objectId, f);
    }

    private native void setTau(long var1, float var3);

    public float getDamping() {
        return this.getDamping(this.objectId);
    }

    private native float getDamping(long var1);

    public float getImpulseClamp() {
        return this.getImpulseClamp(this.objectId);
    }

    private native float getImpulseClamp(long var1);

    public float getTau() {
        return this.getTau(this.objectId);
    }

    private native float getTau(long var1);

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.getDamping(), "damping", 1.0f);
        outputCapsule.write(this.getTau(), "tau", 0.3f);
        outputCapsule.write(this.getImpulseClamp(), "impulseClamp", 0.0f);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        this.createJoint();
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.setDamping(inputCapsule.readFloat("damping", 1.0f));
        this.setDamping(inputCapsule.readFloat("tau", 0.3f));
        this.setDamping(inputCapsule.readFloat("impulseClamp", 0.0f));
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.pivotB);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Vector3f var6);
}

