/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SixDofJoint
extends PhysicsJoint {
    Matrix3f rotA;
    Matrix3f rotB;
    boolean useLinearReferenceFrameA;
    LinkedList<RotationalLimitMotor> rotationalMotors = new LinkedList();
    TranslationalLimitMotor translationalMotor;
    Vector3f angularUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    Vector3f angularLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);
    Vector3f linearUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    Vector3f linearLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);

    public SixDofJoint() {
    }

    public SixDofJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2, Matrix3f matrix3f, Matrix3f matrix3f2, boolean bl) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.useLinearReferenceFrameA = bl;
        this.rotA = matrix3f;
        this.rotB = matrix3f2;
        this.objectId = this.createJoint(physicsRigidBody.getObjectId(), physicsRigidBody2.getObjectId(), vector3f, matrix3f, vector3f2, matrix3f2, bl);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
    }

    public SixDofJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2, boolean bl) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.useLinearReferenceFrameA = bl;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.objectId = this.createJoint(physicsRigidBody.getObjectId(), physicsRigidBody2.getObjectId(), vector3f, this.rotA, vector3f2, this.rotB, bl);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
    }

    private void gatherMotors() {
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rotationalLimitMotor = new RotationalLimitMotor(this.getRotationalLimitMotor(this.objectId, i));
            this.rotationalMotors.add(rotationalLimitMotor);
        }
        this.translationalMotor = new TranslationalLimitMotor(this.getTranslationalLimitMotor(this.objectId));
    }

    private native long getRotationalLimitMotor(long var1, int var3);

    private native long getTranslationalLimitMotor(long var1);

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.translationalMotor;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int n) {
        return this.rotationalMotors.get(n);
    }

    public void setLinearUpperLimit(Vector3f vector3f) {
        this.linearUpperLimit.set(vector3f);
        this.setLinearUpperLimit(this.objectId, vector3f);
    }

    private native void setLinearUpperLimit(long var1, Vector3f var3);

    public void setLinearLowerLimit(Vector3f vector3f) {
        this.linearLowerLimit.set(vector3f);
        this.setLinearLowerLimit(this.objectId, vector3f);
    }

    private native void setLinearLowerLimit(long var1, Vector3f var3);

    public void setAngularUpperLimit(Vector3f vector3f) {
        this.angularUpperLimit.set(vector3f);
        this.setAngularUpperLimit(this.objectId, vector3f);
    }

    private native void setAngularUpperLimit(long var1, Vector3f var3);

    public void setAngularLowerLimit(Vector3f vector3f) {
        this.angularLowerLimit.set(vector3f);
        this.setAngularLowerLimit(this.objectId, vector3f);
    }

    private native void setAngularLowerLimit(long var1, Vector3f var3);

    native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
        this.setAngularUpperLimit((Vector3f)inputCapsule.readSavable("angularUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setAngularLowerLimit((Vector3f)inputCapsule.readSavable("angularLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        this.setLinearUpperLimit((Vector3f)inputCapsule.readSavable("linearUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setLinearLowerLimit((Vector3f)inputCapsule.readSavable("linearLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rotationalLimitMotor = this.getRotationalLimitMotor(i);
            rotationalLimitMotor.setBounce(inputCapsule.readFloat("rotMotor" + i + "_Bounce", 0.0f));
            rotationalLimitMotor.setDamping(inputCapsule.readFloat("rotMotor" + i + "_Damping", 1.0f));
            rotationalLimitMotor.setERP(inputCapsule.readFloat("rotMotor" + i + "_ERP", 0.5f));
            rotationalLimitMotor.setHiLimit(inputCapsule.readFloat("rotMotor" + i + "_HiLimit", Float.POSITIVE_INFINITY));
            rotationalLimitMotor.setLimitSoftness(inputCapsule.readFloat("rotMotor" + i + "_LimitSoftness", 0.5f));
            rotationalLimitMotor.setLoLimit(inputCapsule.readFloat("rotMotor" + i + "_LoLimit", Float.NEGATIVE_INFINITY));
            rotationalLimitMotor.setMaxLimitForce(inputCapsule.readFloat("rotMotor" + i + "_MaxLimitForce", 300.0f));
            rotationalLimitMotor.setMaxMotorForce(inputCapsule.readFloat("rotMotor" + i + "_MaxMotorForce", 0.1f));
            rotationalLimitMotor.setTargetVelocity(inputCapsule.readFloat("rotMotor" + i + "_TargetVelocity", 0.0f));
            rotationalLimitMotor.setEnableMotor(inputCapsule.readBoolean("rotMotor" + i + "_EnableMotor", false));
        }
        this.getTranslationalLimitMotor().setAccumulatedImpulse((Vector3f)inputCapsule.readSavable("transMotor_AccumulatedImpulse", (Savable)Vector3f.ZERO));
        this.getTranslationalLimitMotor().setDamping(inputCapsule.readFloat("transMotor_Damping", 1.0f));
        this.getTranslationalLimitMotor().setLimitSoftness(inputCapsule.readFloat("transMotor_LimitSoftness", 0.7f));
        this.getTranslationalLimitMotor().setLowerLimit((Vector3f)inputCapsule.readSavable("transMotor_LowerLimit", (Savable)Vector3f.ZERO));
        this.getTranslationalLimitMotor().setRestitution(inputCapsule.readFloat("transMotor_Restitution", 0.5f));
        this.getTranslationalLimitMotor().setUpperLimit((Vector3f)inputCapsule.readSavable("transMotor_UpperLimit", (Savable)Vector3f.ZERO));
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.angularUpperLimit, "angularUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY));
        outputCapsule.write((Savable)this.angularLowerLimit, "angularLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY));
        outputCapsule.write((Savable)this.linearUpperLimit, "linearUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY));
        outputCapsule.write((Savable)this.linearLowerLimit, "linearLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY));
        int n = 0;
        for (RotationalLimitMotor rotationalLimitMotor : this.rotationalMotors) {
            outputCapsule.write(rotationalLimitMotor.getBounce(), "rotMotor" + n + "_Bounce", 0.0f);
            outputCapsule.write(rotationalLimitMotor.getDamping(), "rotMotor" + n + "_Damping", 1.0f);
            outputCapsule.write(rotationalLimitMotor.getERP(), "rotMotor" + n + "_ERP", 0.5f);
            outputCapsule.write(rotationalLimitMotor.getHiLimit(), "rotMotor" + n + "_HiLimit", Float.POSITIVE_INFINITY);
            outputCapsule.write(rotationalLimitMotor.getLimitSoftness(), "rotMotor" + n + "_LimitSoftness", 0.5f);
            outputCapsule.write(rotationalLimitMotor.getLoLimit(), "rotMotor" + n + "_LoLimit", Float.NEGATIVE_INFINITY);
            outputCapsule.write(rotationalLimitMotor.getMaxLimitForce(), "rotMotor" + n + "_MaxLimitForce", 300.0f);
            outputCapsule.write(rotationalLimitMotor.getMaxMotorForce(), "rotMotor" + n + "_MaxMotorForce", 0.1f);
            outputCapsule.write(rotationalLimitMotor.getTargetVelocity(), "rotMotor" + n + "_TargetVelocity", 0.0f);
            outputCapsule.write(rotationalLimitMotor.isEnableMotor(), "rotMotor" + n + "_EnableMotor", false);
            ++n;
        }
        outputCapsule.write((Savable)this.getTranslationalLimitMotor().getAccumulatedImpulse(), "transMotor_AccumulatedImpulse", (Savable)Vector3f.ZERO);
        outputCapsule.write(this.getTranslationalLimitMotor().getDamping(), "transMotor_Damping", 1.0f);
        outputCapsule.write(this.getTranslationalLimitMotor().getLimitSoftness(), "transMotor_LimitSoftness", 0.7f);
        outputCapsule.write((Savable)this.getTranslationalLimitMotor().getLowerLimit(), "transMotor_LowerLimit", (Savable)Vector3f.ZERO);
        outputCapsule.write(this.getTranslationalLimitMotor().getRestitution(), "transMotor_Restitution", 0.5f);
        outputCapsule.write((Savable)this.getTranslationalLimitMotor().getUpperLimit(), "transMotor_UpperLimit", (Savable)Vector3f.ZERO);
    }
}

