/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd.nativebullet;

import com.jme3.animation.Bone;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import projectkyoto.jme3.mmd.PMDNode;

public class PMDRigidBody
extends PhysicsRigidBody {
    final PMDNode pmdNode;
    final Bone bone;
    final int rigidBodyType;
    final Vector3f pos = new Vector3f();
    final Quaternion rot = new Quaternion();
    final Vector3f invPos = new Vector3f();
    final Quaternion invRot = new Quaternion();
    final Vector3f tmpV = new Vector3f();
    final Quaternion tmpQ = new Quaternion();
    final Bone centerBone;
    final boolean centerFlag;
    Matrix4f m = new Matrix4f();
    Matrix4f invM = new Matrix4f();
    Matrix4f m2 = new Matrix4f();
    Matrix4f m3 = new Matrix4f();

    public PMDRigidBody(PMDNode pmdNode, Bone bone, int rigidBodyType, Vector3f pos, Quaternion rot, CollisionShape cs, float f) {
        super(cs, f);
        this.pmdNode = pmdNode;
        this.bone = bone;
        this.rigidBodyType = rigidBodyType;
        this.pos.set(pos);
        this.rot.set(rot);
        this.invPos.set(pos);
        this.invPos.negateLocal();
        this.invRot.set(rot);
        this.invRot.inverseLocal();
        this.invM.setTransform(pos, new Vector3f(1.0f, 1.0f, 1.0f), rot.toRotationMatrix());
        this.m.set(this.invM);
        this.invM.invertLocal();
        this.m2.loadIdentity();
        this.centerBone = pmdNode.getSkeleton().getBone("\u30bb\u30f3\u30bf\u30fc");
        this.centerFlag = bone == this.centerBone;
    }

    public void update() {
        if (this.isKinematic()) {
            this.updateFromBoneMatrix();
        } else {
            this.updateToBoneMatrix();
        }
    }

    public void updateFromBoneMatrix() {
        if (this.bone != null) {
            this.tmpV.set(this.bone.getModelSpacePosition());
            this.tmpV.addLocal(this.pos);
            this.tmpQ.set(this.bone.getModelSpaceRotation());
            this.tmpQ.multLocal(this.rot);
            this.m2.setTranslation(this.bone.getModelSpacePosition());
            this.m2.setRotationQuaternion(this.bone.getModelSpaceRotation());
            this.m2.multLocal(this.m);
            super.setPhysicsLocation(this.m2.toTranslationVector());
            super.setPhysicsRotation(this.m2.toRotationQuat());
        } else {
            this.tmpV.set(this.centerBone.getModelSpacePosition());
            this.tmpV.addLocal(this.pos);
            this.tmpQ.set(this.centerBone.getModelSpaceRotation());
            this.tmpQ.multLocal(this.rot);
            this.m2.setTranslation(this.centerBone.getModelSpacePosition());
            this.m2.setRotationQuaternion(this.centerBone.getModelSpaceRotation());
            this.m2.multLocal(this.m);
            super.setPhysicsRotation(this.m2.toRotationQuat());
            super.setPhysicsLocation(this.m2.toTranslationVector());
        }
    }

    public void reset() {
        this.updateFromBoneMatrix();
        this.setLinearVelocity(Vector3f.ZERO);
        this.setAngularVelocity(Vector3f.ZERO);
        this.clearForces();
    }

    public void updateToBoneMatrix() {
        if (this.bone != null) {
            if (this.rigidBodyType == 2) {
                this.tmpV.set(super.getPhysicsLocation());
                this.tmpQ.set(super.getPhysicsRotation());
                this.m2.setRotationQuaternion(this.tmpQ);
                this.m2.setTranslation(this.tmpV);
                this.m2.multLocal(this.invM);
                this.bone.getModelSpaceRotation().set(this.m2.toRotationQuat());
            } else if (this.rigidBodyType == 1 && !this.centerFlag) {
                this.tmpV.set(super.getPhysicsLocation());
                this.tmpQ.set(super.getPhysicsRotation());
                this.m2.setRotationQuaternion(this.tmpQ);
                this.m2.setTranslation(this.tmpV);
                this.m2.multLocal(this.invM);
                this.bone.getModelSpaceRotation().set(this.m2.toRotationQuat());
                this.bone.getModelSpacePosition().set(this.m2.toTranslationVector());
            }
        }
    }

    public PMDNode getPmdNode() {
        return this.pmdNode;
    }

    public Bone getBone() {
        return this.bone;
    }

    public Vector3f getInvPos() {
        return this.invPos;
    }

    public Quaternion getInvRot() {
        return this.invRot;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Quaternion getRot() {
        return this.rot;
    }
}

