/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.util.ArrayList;
import java.util.List;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.util2.MeshConverter;

public class MeshData {
    PMDModel model;
    int maxBoneSize;
    PMDMaterial material;
    List<Integer> boneList = new ArrayList<Integer>();
    List<PMDVertex> vertexList = new ArrayList<PMDVertex>();
    List<Integer> indexList = new ArrayList<Integer>();

    public MeshData(PMDModel model, int maxBoneSize, PMDMaterial material) {
        this.model = model;
        this.maxBoneSize = maxBoneSize;
        this.material = material;
    }

    public boolean addTriangle(MeshConverter mc, int i1, int i2, int i3) {
        int boneListSizeBefore = this.boneList.size();
        this.addBoneList(i1);
        this.addBoneList(i2);
        this.addBoneList(i3);
        if (this.boneList.size() <= this.maxBoneSize) {
            this.addVertex(mc, i1);
            this.addVertex(mc, i2);
            this.addVertex(mc, i3);
            return true;
        }
        for (int i = this.boneList.size(); i > boneListSizeBefore; --i) {
            this.boneList.remove(i - 1);
        }
        return false;
    }

    private void addBoneList(int vertIndex) {
        PMDVertex v = this.model.getVertexList()[vertIndex];
        if (!this.boneList.contains(v.getBoneNum1())) {
            this.boneList.add(v.getBoneNum1());
        }
        if (!this.boneList.contains(v.getBoneNum2())) {
            this.boneList.add(v.getBoneNum2());
        }
    }

    private void addVertex(MeshConverter mc, int vertIndex) {
        int newVertIndex;
        PMDVertex v = this.model.getVertexList()[vertIndex];
        Integer index = mc.meshTmpVertMap.get(v);
        if (index != null) {
            newVertIndex = index;
        } else {
            newVertIndex = this.vertexList.size();
            this.vertexList.add(v);
            mc.meshTmpVertMap.put(v, index);
        }
        this.indexList.add(newVertIndex);
    }

    public List<Integer> getBoneList() {
        return this.boneList;
    }

    public void setBoneList(List<Integer> boneList) {
        this.boneList = boneList;
    }

    public List<Integer> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<Integer> indexList) {
        this.indexList = indexList;
    }

    public PMDMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(PMDMaterial material) {
        this.material = material;
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public List<PMDVertex> getVertexList() {
        return this.vertexList;
    }

    public void setVertexList(List<PMDVertex> vertexList) {
        this.vertexList = vertexList;
    }

    public void printTrinangles() {
        for (int i = 0; i < this.indexList.size(); ++i) {
            PMDVertex v = this.vertexList.get(this.indexList.get(i));
            System.out.println(v);
        }
    }
}

