/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.BlockMapping;
import com.fluendo.jheora.CodingMode;
import com.fluendo.jheora.Coordinate;
import com.fluendo.jheora.MotionVector;
import com.fluendo.jheora.PixelFormat;
import com.fluendo.jheora.Playback;

public class FrInit {
    static void InitializeFragCoordinates(Playback pbi) {
        int ThisFrag;
        int j;
        int i;
        int HorizFrags = pbi.HFragments;
        int VertFrags = pbi.VFragments;
        int StartFrag = 0;
        for (i = 0; i < VertFrags; ++i) {
            for (j = 0; j < HorizFrags; ++j) {
                ThisFrag = i * HorizFrags + j;
                pbi.FragCoordinates[ThisFrag] = new Coordinate(j * 8, i * 8);
            }
        }
        HorizFrags >>= pbi.UVShiftX;
        VertFrags >>= pbi.UVShiftY;
        StartFrag = pbi.YPlaneFragments;
        for (i = 0; i < VertFrags; ++i) {
            for (j = 0; j < HorizFrags; ++j) {
                ThisFrag = StartFrag + i * HorizFrags + j;
                pbi.FragCoordinates[ThisFrag] = new Coordinate(j * 8, i * 8);
            }
        }
        StartFrag = pbi.YPlaneFragments + pbi.UVPlaneFragments;
        for (i = 0; i < VertFrags; ++i) {
            for (j = 0; j < HorizFrags; ++j) {
                ThisFrag = StartFrag + i * HorizFrags + j;
                pbi.FragCoordinates[ThisFrag] = new Coordinate(j * 8, i * 8);
            }
        }
    }

    static void CalcPixelIndexTable(Playback pbi) {
        int i;
        int[] PixelIndexTablePtr = pbi.pixel_index_table;
        for (i = 0; i < pbi.YPlaneFragments; ++i) {
            PixelIndexTablePtr[i] = i / pbi.HFragments * 8 * pbi.info.width;
            int n = i;
            PixelIndexTablePtr[n] = PixelIndexTablePtr[n] + i % pbi.HFragments * 8;
        }
        int off = pbi.YPlaneFragments;
        for (i = 0; i < (pbi.HFragments >> pbi.UVShiftX) * pbi.VFragments; ++i) {
            PixelIndexTablePtr[i + off] = i / (pbi.HFragments >> pbi.UVShiftX) * (8 * (pbi.info.width >> pbi.UVShiftX));
            int n = i + off;
            PixelIndexTablePtr[n] = PixelIndexTablePtr[n] + (i % (pbi.HFragments >> pbi.UVShiftX) * 8 + pbi.YPlaneSize);
        }
        PixelIndexTablePtr = pbi.recon_pixel_index_table;
        for (i = 0; i < pbi.YPlaneFragments; ++i) {
            PixelIndexTablePtr[i] = i / pbi.HFragments * 8 * pbi.YStride;
            int n = i;
            PixelIndexTablePtr[n] = PixelIndexTablePtr[n] + (i % pbi.HFragments * 8 + pbi.ReconYDataOffset);
        }
        off = pbi.YPlaneFragments;
        for (i = 0; i < pbi.UVPlaneFragments; ++i) {
            PixelIndexTablePtr[i + off] = i / (pbi.HFragments >> pbi.UVShiftX) * (8 * pbi.UVStride);
            int n = i + off;
            PixelIndexTablePtr[n] = PixelIndexTablePtr[n] + (i % (pbi.HFragments >> pbi.UVShiftX) * 8 + pbi.ReconUDataOffset);
        }
        off = pbi.YPlaneFragments + pbi.UVPlaneFragments;
        for (i = 0; i < pbi.UVPlaneFragments; ++i) {
            PixelIndexTablePtr[i + off] = i / (pbi.HFragments >> pbi.UVShiftX) * (8 * pbi.UVStride);
            int n = i + off;
            PixelIndexTablePtr[n] = PixelIndexTablePtr[n] + (i % (pbi.HFragments >> pbi.UVShiftX) * 8 + pbi.ReconVDataOffset);
        }
    }

    static void ClearFragmentInfo(Playback pbi) {
        pbi.display_fragments = null;
        pbi.pixel_index_table = null;
        pbi.recon_pixel_index_table = null;
        pbi.FragTokenCounts = null;
        pbi.CodedBlockList = null;
        pbi.FragMVect = null;
        pbi.FragCoefEOB = null;
        pbi.QFragData = null;
        pbi.FragCodingMethod = null;
        pbi.FragCoordinates = null;
        pbi.FragQIndex = null;
        pbi.BlockMap = null;
        pbi.SBCodedFlags = null;
        pbi.SBFullyFlags = null;
        pbi.MBFullyFlags = null;
        pbi.MBCodedFlags = null;
    }

    static void InitFragmentInfo(Playback pbi) {
        FrInit.ClearFragmentInfo(pbi);
        pbi.display_fragments = new byte[pbi.UnitFragments];
        pbi.pixel_index_table = new int[pbi.UnitFragments];
        pbi.recon_pixel_index_table = new int[pbi.UnitFragments];
        pbi.FragTokenCounts = new int[pbi.UnitFragments];
        pbi.CodedBlockList = new int[pbi.UnitFragments];
        pbi.FragMVect = new MotionVector[pbi.UnitFragments];
        for (int i = 0; i < pbi.UnitFragments; ++i) {
            pbi.FragMVect[i] = new MotionVector();
        }
        pbi.FragQs = new byte[pbi.UnitFragments];
        pbi.FragCoefEOB = new byte[pbi.UnitFragments];
        pbi.QFragData = new short[pbi.UnitFragments][64];
        pbi.FragCodingMethod = new CodingMode[pbi.UnitFragments];
        pbi.FragCoordinates = new Coordinate[pbi.UnitFragments];
        pbi.FragQIndex = new int[pbi.UnitFragments];
        pbi.SBCodedFlags = new byte[pbi.SuperBlocks];
        pbi.SBFullyFlags = new byte[pbi.SuperBlocks];
        pbi.MBCodedFlags = new byte[pbi.MacroBlocks];
        pbi.MBFullyFlags = new byte[pbi.MacroBlocks];
    }

    static void ClearFrameInfo(Playback pbi) {
        pbi.ThisFrameRecon = null;
        pbi.GoldenFrame = null;
        pbi.LastFrameRecon = null;
        pbi.PostProcessBuffer = null;
    }

    static void InitFrameInfo(Playback pbi, int FrameSize) {
        FrInit.ClearFrameInfo(pbi);
        pbi.ThisFrameRecon = new short[FrameSize];
        pbi.GoldenFrame = new short[FrameSize];
        pbi.LastFrameRecon = new short[FrameSize];
        pbi.PostProcessBuffer = new short[FrameSize];
    }

    static void InitFrameDetails(Playback pbi) {
        pbi.PostProcessingLevel = 0;
        pbi.UVShiftY = 1;
        pbi.UVShiftX = 1;
        if (pbi.info.pixel_fmt == PixelFormat.TH_PF_422) {
            pbi.UVShiftY = 0;
        }
        if (pbi.info.pixel_fmt == PixelFormat.TH_PF_444) {
            pbi.UVShiftY = 0;
            pbi.UVShiftX = 0;
        }
        int uv_fact = 1 << pbi.UVShiftX + pbi.UVShiftY;
        pbi.YPlaneSize = pbi.info.width * pbi.info.height;
        pbi.UVPlaneSize = pbi.YPlaneSize / uv_fact;
        pbi.HFragments = pbi.info.width / 8;
        pbi.VFragments = pbi.info.height / 8;
        pbi.YPlaneFragments = pbi.HFragments * pbi.VFragments;
        pbi.UVPlaneFragments = pbi.YPlaneFragments / uv_fact;
        pbi.UnitFragments = pbi.YPlaneFragments + 2 * pbi.UVPlaneFragments;
        pbi.YStride = pbi.info.width + 32;
        pbi.UVStride = pbi.YStride >> pbi.UVShiftX;
        pbi.ReconYPlaneSize = pbi.YStride * (pbi.info.height + 32);
        pbi.ReconUVPlaneSize = pbi.ReconYPlaneSize / uv_fact;
        int FrameSize = pbi.ReconYPlaneSize + 2 * pbi.ReconUVPlaneSize;
        pbi.YDataOffset = 0;
        pbi.UDataOffset = pbi.YPlaneSize;
        pbi.VDataOffset = pbi.YPlaneSize + pbi.UVPlaneSize;
        pbi.ReconYDataOffset = pbi.YStride * 16 + 16;
        pbi.ReconUDataOffset = pbi.ReconYPlaneSize + pbi.UVStride * (16 >> pbi.UVShiftY) + (16 >> pbi.UVShiftX);
        pbi.ReconVDataOffset = pbi.ReconYPlaneSize + pbi.ReconUVPlaneSize + pbi.UVStride * (16 >> pbi.UVShiftY) + (16 >> pbi.UVShiftX);
        pbi.YSBRows = pbi.info.height / 32 + (pbi.info.height % 32 != 0 ? 1 : 0);
        pbi.YSBCols = pbi.info.width / 32 + (pbi.info.width % 32 != 0 ? 1 : 0);
        pbi.UVSBRows = (pbi.info.height >> pbi.UVShiftY) / 32 + ((pbi.info.height >> pbi.UVShiftY) % 32 != 0 ? 1 : 0);
        pbi.UVSBCols = (pbi.info.width >> pbi.UVShiftX) / 32 + ((pbi.info.width >> pbi.UVShiftX) % 32 != 0 ? 1 : 0);
        pbi.YSuperBlocks = pbi.YSBRows * pbi.YSBCols;
        pbi.UVSuperBlocks = pbi.UVSBRows * pbi.UVSBCols;
        pbi.SuperBlocks = pbi.YSuperBlocks + 2 * pbi.UVSuperBlocks;
        pbi.YMacroBlocks = (pbi.VFragments + 1) / 2 * ((pbi.HFragments + 1) / 2);
        pbi.UVMacroBlocks = ((pbi.VFragments >> pbi.UVShiftY) + 1) / 2 * (((pbi.HFragments >> pbi.UVShiftX) + 1) / 2);
        pbi.MacroBlocks = pbi.YMacroBlocks + 2 * pbi.UVMacroBlocks;
        FrInit.InitFragmentInfo(pbi);
        FrInit.InitFrameInfo(pbi, FrameSize);
        FrInit.InitializeFragCoordinates(pbi);
        pbi.BlockMap = new BlockMapping(pbi.YSuperBlocks, pbi.UVSuperBlocks, pbi.HFragments, pbi.VFragments, pbi.UVShiftX, pbi.UVShiftY);
        FrInit.CalcPixelIndexTable(pbi);
    }
}

