/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Element;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class ElementFactory {
    private static String[] components = new String[]{"com.fluendo.plugin.HTTPSrc", "com.fluendo.plugin.VideoSink", "com.fluendo.plugin.AudioSinkJ2", "com.fluendo.plugin.AudioSinkSA", "com.fluendo.plugin.Queue", "com.fluendo.plugin.FakeSink", "com.fluendo.plugin.Overlay", "com.fluendo.plugin.Selector", "com.fluendo.plugin.OggDemux", "com.fluendo.plugin.TheoraDec", "com.fluendo.plugin.VorbisDec", "com.fluendo.plugin.KateDec", "com.fluendo.plugin.KateOverlay"};
    private static Vector elements = new Vector();

    public static void loadElements() {
        try {
            for (int i = 0; i < components.length; ++i) {
                String str = components[i];
                try {
                    Class<?> cl = Class.forName(str);
                    Debug.log(3, "registered plugin: " + str);
                    Element pl = (Element)cl.newInstance();
                    elements.addElement(pl);
                    continue;
                }
                catch (Throwable t) {
                    Debug.log(3, "Failed to register plugin: " + str);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Element dup(Element element, String name) {
        Element result = null;
        Class<?> cl = element.getClass();
        try {
            result = (Element)cl.newInstance();
            if (result != null && name != null) {
                result.setName(name);
            }
            Debug.log(3, "create element: " + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static final Element findTypeFind(byte[] data, int offset, int length) {
        int best = -1;
        Element result = null;
        Enumeration e = elements.elements();
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            int rank = element.typeFind(data, offset, length);
            if (rank <= best) continue;
            best = rank;
            result = element;
        }
        return result;
    }

    public static final String typeFindMime(byte[] data, int offset, int length) {
        String result = null;
        Element elem = ElementFactory.findTypeFind(data, offset, length);
        if (elem != null) {
            result = elem.getMime();
        }
        return result;
    }

    public static final Element makeTypeFind(byte[] data, int offset, int length, String name) {
        Element result = null;
        result = ElementFactory.findTypeFind(data, offset, length);
        if (result != null) {
            result = ElementFactory.dup(result, name);
        }
        return result;
    }

    public static final Element makeByMime(String mime, String name) {
        Element result = null;
        Enumeration e = elements.elements();
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            if (!mime.equals(element.getMime())) continue;
            result = ElementFactory.dup(element, name);
            break;
        }
        return result;
    }

    public static final Element makeByName(String name, String elemName) {
        Element result = null;
        Enumeration e = elements.elements();
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            if (!name.equals(element.getFactoryName())) continue;
            result = ElementFactory.dup(element, elemName);
            break;
        }
        return result;
    }

    static {
        ElementFactory.loadElements();
    }
}

