/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Event;
import com.fluendo.jkate.KateSpaceMetric;
import com.fluendo.jkate.Region;
import com.fluendo.jkate.Style;
import com.fluendo.utils.Debug;
import java.awt.Dimension;

public final class Tracker {
    private Dimension window;
    private Dimension frame;
    public Event ev = null;
    public boolean[] has = new boolean[64];
    public static final int has_region = 0;
    public static final int has_text_alignment_int = 1;
    public static final int has_text_alignment_ext = 2;
    public float region_x;
    public float region_y;
    public float region_w;
    public float region_h;

    public Tracker(Event ev) {
        this.ev = ev;
    }

    public boolean update(double t, Dimension window, Dimension frame) {
        this.window = window;
        this.frame = frame;
        Region kr = this.ev.kr;
        Style ks = this.ev.ks;
        if (ks == null && kr != null && kr.style >= 0) {
            ks = this.ev.ki.styles[kr.style];
        }
        for (int n = 0; n < this.has.length; ++n) {
            this.has[n] = false;
        }
        if (kr != null) {
            if (kr.metric == KateSpaceMetric.kate_metric_percentage) {
                this.region_x = (float)(kr.x * frame.width) / 100.0f;
                this.region_y = (float)(kr.y * frame.height) / 100.0f;
                this.region_w = (float)(kr.w * frame.width) / 100.0f;
                this.region_h = (float)(kr.h * frame.height) / 100.0f;
            } else if (kr.metric == KateSpaceMetric.kate_metric_millionths) {
                this.region_x = (float)(kr.x * frame.width) / 1000000.0f;
                this.region_y = (float)(kr.y * frame.height) / 1000000.0f;
                this.region_w = (float)(kr.w * frame.width) / 1000000.0f;
                this.region_h = (float)(kr.h * frame.height) / 1000000.0f;
            } else if (kr.metric == KateSpaceMetric.kate_metric_pixels) {
                this.region_x = kr.x;
                this.region_y = kr.y;
                this.region_w = kr.w;
                this.region_h = kr.h;
            } else {
                Debug.debug("Invalid metrics");
                return false;
            }
            this.has[0] = true;
        }
        return true;
    }
}

