/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.video.plugins.jheora;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jme3.audio.AudioStream;
import com.jme3.util.IntMap;
import com.jme3.video.Clock;
import com.jme3.video.SystemClock;
import com.jme3.video.VQueue;
import com.jme3.video.plugins.jheora.ADecoder;
import com.jme3.video.plugins.jheora.VDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class AVThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(AVThread.class.getName());
    private static final int BUFFSIZE = 8192;
    private Page page;
    private Packet packet;
    private SyncState syncState;
    private InputStream oggStream;
    private AtomicBoolean cancel = new AtomicBoolean(false);
    private IntMap<StreamState> streams = new IntMap();
    private int theoraSerial;
    private int vorbisSerial;
    private ADecoder audioDecoder;
    private VDecoder videoDecoder;
    private Clock masterClock;
    private Clock systemClock;

    public AVThread(InputStream oggStream, VQueue videoQueue) {
        this.oggStream = oggStream;
        this.videoDecoder = new VDecoder(videoQueue);
        this.audioDecoder = new ADecoder();
        this.systemClock = new SystemClock();
        this.masterClock = this.audioDecoder;
        this.audioDecoder.setMasterClock(this.masterClock);
        this.videoDecoder.setMasterClock(this.masterClock);
    }

    public AudioStream getAudioStream() {
        return this.audioDecoder.getAudioStream();
    }

    public void stop() {
        this.cancel.set(true);
    }

    private void done() {
        this.videoDecoder.close();
        this.audioDecoder.close();
        try {
            this.oggStream.close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error while closing Ogg Video", ex);
        }
    }

    public Clock getMasterClock() {
        return this.masterClock;
    }

    public Clock getSystemClock() {
        return this.systemClock;
    }

    public Clock getVideoClock() {
        return this.videoDecoder;
    }

    public Clock getAudioClock() {
        return this.audioDecoder;
    }

    public void run() {
        this.page = new Page();
        this.packet = new Packet();
        this.syncState = new SyncState();
        while (!this.cancel.get()) {
            int res;
            int read;
            int index = this.syncState.buffer(8192);
            try {
                read = this.oggStream.read(this.syncState.data, index, 8192);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while decoding Ogg Video", ex);
                return;
            }
            if (read < 0) break;
            this.syncState.wrote(read);
            while (!this.cancel.get() && (res = this.syncState.pageout(this.page)) != 0) {
                if (res == -1) continue;
                int serial = this.page.serialno();
                StreamState state = this.streams.get(serial);
                boolean newStream = false;
                if (state == null) {
                    state = new StreamState();
                    state.init(serial);
                    state.reset();
                    this.streams.put(serial, state);
                    newStream = true;
                }
                if ((res = state.pagein(this.page)) < 0) {
                    System.err.println("Error reading first page of Ogg bitstream data.");
                    return;
                }
                while (!this.cancel.get() && (res = state.packetout(this.packet)) != 0) {
                    if (res == -1) continue;
                    if (newStream) {
                        byte[] packetBase = this.packet.packet_base;
                        int packetId = this.packet.packet;
                        if (packetBase[packetId + 1] == 118) {
                            this.vorbisSerial = serial;
                        } else if (this.packet.packet_base[this.packet.packet + 1] == 115) {
                            logger.log(Level.WARNING, "Smoke video detected. Unsupported!");
                        } else if (this.packet.packet_base[this.packet.packet + 1] == 116) {
                            this.theoraSerial = serial;
                        }
                    }
                    if (serial == this.theoraSerial) {
                        this.videoDecoder.decode(this.packet);
                        continue;
                    }
                    if (serial != this.vorbisSerial) continue;
                    this.audioDecoder.decode(this.packet);
                }
            }
        }
        this.done();
    }
}

