/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.ConnectionRunnable;
import com.jme3.network.connection.TCPConnection;
import com.jme3.network.connection.UDPConnection;
import com.jme3.network.events.ConnectionListener;
import com.jme3.network.events.MessageListener;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import com.jme3.network.message.DiscoverHostMessage;
import com.jme3.network.message.Message;
import com.jme3.network.queue.MessageQueue;
import com.jme3.network.serializing.Serializer;
import com.jme3.network.service.ServiceManager;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Client
extends ServiceManager {
    protected Logger log = Logger.getLogger(Client.class.getName());
    protected static int clientIDCounter = 0;
    protected int clientID;
    protected long playerID = -1L;
    protected String label;
    protected boolean isConnected;
    protected TCPConnection tcp;
    protected UDPConnection udp;
    protected ConnectionRunnable thread;
    protected MessageQueue messageQueue;
    protected SocketChannel tcpChannel;
    protected DatagramChannel udpChannel;
    protected SocketAddress udpTarget;
    protected boolean isConnector;
    protected ClientObserver listener = new ClientObserver();

    @Deprecated
    public Client() {
        this(false);
    }

    Client(boolean connector) {
        super(true);
        this.clientID = ++clientIDCounter;
        this.label = "Client#" + this.clientID;
        this.isConnector = connector;
        if (connector) {
            this.isConnected = true;
        } else {
            if (this.tcp == null) {
                this.tcp = new TCPConnection(this.label);
            }
            if (this.udp == null) {
                this.udp = new UDPConnection(this.label);
            }
        }
        this.messageQueue = new MessageQueue();
    }

    public Client(TCPConnection tcp, UDPConnection udp, SocketAddress tcpAddress, SocketAddress udpAddress) throws IOException {
        this();
        this.tcp = tcp;
        tcp.connect(tcpAddress);
        this.udp = udp;
        udp.connect(udpAddress);
        this.isConnected = true;
        this.registerInternalListeners();
    }

    public Client(TCPConnection tcp, SocketAddress tcpAddress) throws IOException {
        this();
        this.tcp = tcp;
        tcp.connect(tcpAddress);
        this.isConnected = true;
        this.registerInternalListeners();
    }

    public Client(UDPConnection udp, SocketAddress updAddress) throws IOException {
        this();
        this.udp = udp;
        udp.connect(updAddress);
        this.isConnected = true;
        this.registerInternalListeners();
    }

    @Deprecated
    public Client(String ip, int tcpPort, int udpPort) throws IOException {
        this();
        this.tcp = new TCPConnection(this.label);
        this.tcp.connect(new InetSocketAddress(ip, tcpPort));
        this.udp = new UDPConnection(this.label);
        this.udp.connect(new InetSocketAddress(ip, udpPort));
        this.isConnected = true;
        this.registerInternalListeners();
    }

    public void connect(String ip, int tcpPort, int udpPort) throws IllegalArgumentException, IOException {
        if (tcpPort == -1 && udpPort == -1) {
            throw new IllegalArgumentException("No point in connect when you want to turn both the connections off.");
        }
        if (tcpPort != -1) {
            this.tcp.connect(new InetSocketAddress(ip, tcpPort));
        }
        if (udpPort != -1) {
            this.udp.connect(new InetSocketAddress(ip, udpPort));
        }
        this.registerInternalListeners();
        this.isConnected = true;
    }

    private void registerInternalListeners() {
        if (this.tcp != null) {
            this.tcp.addConnectionListener(this.listener);
            this.tcp.socketChannel.keyFor(this.tcp.selector).attach(this);
        }
        this.addMessageListener(this.listener, DisconnectMessage.class);
    }

    public void send(Message message) throws IOException {
        if (!this.isConnected) {
            throw new IOException("Not connected yet. Use connect() first.");
        }
        try {
            if (message.isReliable()) {
                this.messageQueue.add(message);
                if (!this.isConnector) {
                    this.tcp.socketChannel.keyFor(this.tcp.selector).interestOps(5);
                } else {
                    this.tcpChannel.keyFor(this.tcp.selector).interestOps(5);
                }
            } else {
                this.udp.sendObject(message);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void disconnect(String type) throws IOException {
        if (this.isConnector) {
            return;
        }
        DisconnectMessage msg = new DisconnectMessage();
        msg.setType(type);
        this.tcp.sendObject(msg);
        this.udp.sendObject(msg);
        this.thread.setKeepAlive(false);
        this.thread = null;
        this.log.log(Level.INFO, "[{0}][???] Disconnected.", this.label);
        this.isConnected = false;
    }

    public void disconnect(DisconnectMessage msg) throws IOException {
        if (this.isConnector) {
            return;
        }
        this.tcp.sendObject(msg);
        this.udp.sendObject(msg);
        this.thread.setKeepAlive(false);
        this.thread = null;
        this.log.log(Level.INFO, "[{0}][???] Disconnected.", this.label);
        this.isConnected = false;
    }

    public void disconnect() throws IOException {
        this.disconnect("User requested");
    }

    public void kick(String reason) throws IOException {
        if (!this.isConnector) {
            return;
        }
        DisconnectMessage message = new DisconnectMessage();
        message.setType("Kick");
        message.setReason(reason);
        message.setReliable(true);
        this.send(message);
        this.tcp.addToDisconnectionQueue(this);
        this.log.log(Level.INFO, "[Server#?][???] {0} got kicked with reason: {1}.", new Object[]{this, reason});
    }

    public void kick(DisconnectMessage message) throws IOException {
        if (!this.isConnector) {
            return;
        }
        message.setReliable(true);
        this.send(message);
        this.tcp.addToDisconnectionQueue(this);
        this.log.log(Level.INFO, "[Server#?][???] {0} got kicked with reason: {1}.", new Object[]{this, message.getReason()});
    }

    private void disconnectInternal(DisconnectMessage message) throws IOException {
        DisconnectMessage dcMessage = message;
        String type = dcMessage.getType();
        String reason = dcMessage.getReason();
        this.log.log(Level.INFO, "[{0}][???] We got disconnected from the server ({1}: {2}).", new Object[]{this.label, type, reason});
        this.thread.setKeepAlive(false);
        this.thread = null;
        this.isConnected = false;
    }

    public List<InetAddress> discoverHosts(int port, int timeout) throws IOException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        DatagramSocket socket = new DatagramSocket();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Serializer.writeClass(buffer, DiscoverHostMessage.class);
        buffer.flip();
        byte[] data = new byte[buffer.limit()];
        buffer.get(data);
        for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            for (InetAddress address : Collections.list(iface.getInetAddresses())) {
                if (address instanceof Inet6Address || address.isLoopbackAddress()) continue;
                byte[] ip = address.getAddress();
                ip[3] = -1;
                socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), port));
                ip[2] = -1;
                socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), port));
            }
        }
        this.log.log(Level.FINE, "[{0}][UDP] Started discovery on port {1}.", new Object[]{this.label, port});
        long targetTime = System.currentTimeMillis() + (long)timeout;
        DatagramPacket packet = new DatagramPacket(new byte[0], 0);
        socket.setSoTimeout(1000);
        while (System.currentTimeMillis() < targetTime) {
            try {
                socket.receive(packet);
                if (addresses.contains(packet.getAddress())) continue;
                addresses.add(packet.getAddress());
                this.log.log(Level.FINE, "[{0}][UDP] Discovered server on {1}.", new Object[]{this.label, packet.getAddress()});
            }
            catch (SocketTimeoutException ste) {}
        }
        return addresses;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSocketChannel(SocketChannel channel) {
        this.tcpChannel = channel;
    }

    public SocketChannel getSocketChannel() {
        return this.tcpChannel;
    }

    public void setDatagramChannel(DatagramChannel channel) {
        this.udpChannel = channel;
    }

    public DatagramChannel getDatagramChannel() {
        return this.udpChannel;
    }

    public void setDatagramReceiver(SocketAddress address) {
        this.udpTarget = address;
    }

    public SocketAddress getDatagramReceiver() {
        return this.udpTarget;
    }

    public void setTCPConnection(TCPConnection con) {
        this.tcp = con;
    }

    public void setUDPConnection(UDPConnection con) {
        this.udp = con;
    }

    public TCPConnection getTCPConnection() {
        return this.tcp;
    }

    public UDPConnection getUDPConnection() {
        return this.udp;
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public void start() {
        this.thread = new ConnectionRunnable(this.tcp, this.udp);
        new Thread(this.thread).start();
    }

    public void start(int sleep) {
        this.thread = new ConnectionRunnable(this.tcp, this.udp, sleep);
        new Thread(this.thread).start();
    }

    public int getClientID() {
        return this.clientID;
    }

    public long getPlayerID() {
        return this.playerID;
    }

    public void setPlayerID(long id) {
        this.playerID = id;
    }

    public String toString() {
        return this.label;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (this.tcp != null) {
            this.tcp.addConnectionListener(listener);
        }
        if (this.udp != null) {
            this.udp.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (this.tcp != null) {
            this.tcp.removeConnectionListener(listener);
        }
        if (this.udp != null) {
            this.udp.removeConnectionListener(listener);
        }
    }

    public void addMessageListener(MessageListener listener) {
        if (this.tcp != null) {
            this.tcp.addMessageListener(listener);
        }
        if (this.udp != null) {
            this.udp.addMessageListener(listener);
        }
    }

    public void addMessageListener(MessageListener listener, Class ... classes) {
        for (Class c : classes) {
            if (this.tcp != null) {
                this.tcp.addMessageListener(c, listener);
            }
            if (this.udp == null) continue;
            this.udp.addMessageListener(c, listener);
        }
    }

    public void removeMessageListener(MessageListener listener) {
        if (this.tcp != null) {
            this.tcp.removeMessageListener(listener);
        }
        if (this.udp != null) {
            this.udp.removeMessageListener(listener);
        }
    }

    public void removeMessageListener(MessageListener listener, Class ... classes) {
        for (Class c : classes) {
            if (this.tcp != null) {
                this.tcp.removeMessageListener(c, listener);
            }
            if (this.udp == null) continue;
            this.udp.removeMessageListener(c, listener);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Client) && !(obj instanceof Integer)) {
            return false;
        }
        if (obj instanceof Client) {
            return ((Client)obj).getClientID() == this.getClientID();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue() == this.getClientID();
        }
        return false;
    }

    protected class ClientObserver
    implements MessageListener,
    ConnectionListener {
        protected ClientObserver() {
        }

        public void messageReceived(Message message) {
            try {
                Client.this.disconnectInternal((DisconnectMessage)message);
            }
            catch (IOException e) {
                Client.this.log.log(Level.WARNING, "[{0}][???] Could not disconnect.", Client.this.label);
            }
        }

        public void messageSent(Message message) {
        }

        public void objectReceived(Object object) {
        }

        public void objectSent(Object object) {
        }

        public void clientConnected(Client client) {
            long time;
            if (!Client.this.isConnected) {
                return;
            }
            Client.this.playerID = time = System.currentTimeMillis();
            ClientRegistrationMessage message = new ClientRegistrationMessage();
            message.setId(time);
            try {
                message.setReliable(false);
                Client.this.send(message);
                message.setReliable(true);
                Client.this.send(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                Client.this.log.log(Level.SEVERE, "[{0}][???] Could not sent client registration message. Disconnecting.", Client.this.label);
                try {
                    Client.this.disconnect("Error");
                }
                catch (IOException ie) {
                    // empty catch block
                }
            }
        }

        public void clientDisconnected(Client client) {
            if (Client.this.thread != null) {
                Client.this.thread.setKeepAlive(false);
                Client.this.thread = null;
            }
        }
    }
}

