/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.controls;

import com.jme3.input.controls.Trigger;

public class JoyAxisTrigger
implements Trigger {
    private final int joyId;
    private final int axisId;
    private final boolean negative;

    public JoyAxisTrigger(int joyId, int axisId, boolean negative) {
        this.joyId = joyId;
        this.axisId = axisId;
        this.negative = negative;
    }

    public static int joyAxisHash(int joyId, int joyAxis, boolean negative) {
        assert (joyAxis >= 0 && joyAxis <= 255);
        return 2048 * joyId | (negative ? 1280 : 1024) | joyAxis & 0xFF;
    }

    public int getAxisId() {
        return this.axisId;
    }

    public int getJoyId() {
        return this.joyId;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public String getName() {
        return "JoyAxis[joyId=" + this.joyId + ", axisId=" + this.axisId + ", neg=" + this.negative + "]";
    }

    public int triggerHashCode() {
        return JoyAxisTrigger.joyAxisHash(this.joyId, this.axisId, this.negative);
    }
}

