/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.ErrorListener;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.kernel.Connector;
import com.jme3.network.kernel.ConnectorException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorAdapter
extends Thread {
    private static final int OUTBOUND_BACKLOG = 16000;
    private Connector connector;
    private MessageListener<Object> dispatcher;
    private ErrorListener<Object> errorHandler;
    private AtomicBoolean go = new AtomicBoolean(true);
    private BlockingQueue<ByteBuffer> outbound;
    private WriterThread writer;
    private boolean reliable;

    public ConnectorAdapter(Connector connector, MessageListener<Object> dispatcher, ErrorListener<Object> errorHandler, boolean reliable) {
        super(String.valueOf(connector));
        this.connector = connector;
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.reliable = reliable;
        this.setDaemon(true);
        this.outbound = new ArrayBlockingQueue<ByteBuffer>(16000);
        this.writer = new WriterThread();
        this.writer.start();
    }

    public void close() {
        this.go.set(false);
        this.writer.shutdown();
        this.connector.close();
    }

    protected void dispatch(Message m) {
        this.dispatcher.messageReceived(null, m);
    }

    public void write(ByteBuffer data) {
        try {
            this.outbound.put(data);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for queue to drain", e);
        }
    }

    protected void handleError(Exception e) {
        if (!this.go.get()) {
            return;
        }
        this.errorHandler.handleError(this, e);
    }

    @Override
    public void run() {
        MessageProtocol protocol = new MessageProtocol();
        try {
            while (this.go.get()) {
                ByteBuffer buffer = this.connector.read();
                if (buffer == null) {
                    if (this.go.get()) {
                        throw new ConnectorException("Connector closed.");
                    }
                    break;
                }
                protocol.addBuffer(buffer);
                Message m = null;
                while ((m = protocol.getMessage()) != null) {
                    m.setReliable(this.reliable);
                    this.dispatch(m);
                }
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected class WriterThread
    extends Thread {
        public WriterThread() {
            super(String.valueOf(ConnectorAdapter.this.connector) + "-writer");
        }

        public void shutdown() {
            this.interrupt();
        }

        private void write(ByteBuffer data) {
            try {
                ConnectorAdapter.this.connector.write(data);
            }
            catch (Exception e) {
                ConnectorAdapter.this.handleError(e);
            }
        }

        public void run() {
            while (ConnectorAdapter.this.go.get()) {
                try {
                    ByteBuffer data = (ByteBuffer)ConnectorAdapter.this.outbound.take();
                    this.write(data);
                }
                catch (InterruptedException e) {
                    if (!ConnectorAdapter.this.go.get()) {
                        return;
                    }
                    throw new RuntimeException("Interrupted waiting for data", e);
                }
            }
        }
    }
}

