/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.Skeleton;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.CalculationBone;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.ArrayList;
import java.util.logging.Logger;

class ConstraintInverseKinematics
extends Constraint {
    private static final Logger LOGGER = Logger.getLogger(ConstraintInverseKinematics.class.getName());
    private static final float IK_SOLVER_ERROR = 0.5f;

    public ConstraintInverseKinematics(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, DataRepository dataRepository) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, dataRepository);
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation) {
        try {
            Bone ownerBone = (Bone)this.dataRepository.getLoadedFeature(this.boneOMA, DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
            Object targetObject = this.getTarget(DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
            Vector3f pt = null;
            if (targetObject instanceof Bone) {
                pt = ((Bone)targetObject).getModelSpacePosition();
            } else if (targetObject instanceof Node) {
                pt = ((Node)targetObject).getWorldTranslation();
            } else if (targetObject instanceof Skeleton) {
                Structure armatureNodeStructure = (Structure)this.getTarget(DataRepository.LoadedFeatureDataType.LOADED_STRUCTURE);
                ObjectHelper objectHelper = (ObjectHelper)this.dataRepository.getHelper(ObjectHelper.class);
                Transform transform = objectHelper.getTransformation(armatureNodeStructure, this.dataRepository);
                pt = transform.getTranslation();
            } else {
                throw new IllegalStateException("Unknown target object type! Should be Node, Bone or Skeleton and there is: " + targetObject.getClass().getName());
            }
            int maxIterations = ((Number)this.data.getFieldValue("iterations")).intValue();
            CalculationBone[] bones = this.getBonesToCalculate(ownerBone, skeleton, boneAnimation);
            Quaternion rotation = new Quaternion();
            int framesCount = bones[0].getBoneFramesCount();
            assert (framesCount >= 1);
            for (int frame = 0; frame < framesCount; ++frame) {
                float error = 0.5f;
                for (int iteration = 0; error >= 0.5f && iteration <= maxIterations; ++iteration) {
                    for (int i = 0; i < bones.length - 1; ++i) {
                        Vector3f pe = bones[i].getEndPoint();
                        Vector3f pc = bones[i + 1].getWorldTranslation().clone();
                        Vector3f peSUBpc = pe.subtract(pc).normalizeLocal();
                        Vector3f ptSUBpc = pt.subtract(pc).normalizeLocal();
                        float theta = FastMath.acos(peSUBpc.dot(ptSUBpc));
                        Vector3f direction = peSUBpc.cross(ptSUBpc).normalizeLocal();
                        bones[i].rotate(rotation.fromAngleAxis(theta, direction), frame);
                    }
                    error = pt.subtract(bones[0].getEndPoint()).length();
                }
            }
            for (CalculationBone bone : bones) {
                bone.applyCalculatedTracks();
            }
        }
        catch (BlenderFileException e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
    }

    private CalculationBone[] getBonesToCalculate(Bone bone, Skeleton skeleton, BoneAnimation boneAnimation) {
        ArrayList<CalculationBone> bonesList = new ArrayList<CalculationBone>();
        Bone currentBone = bone;
        do {
            bonesList.add(new CalculationBone(currentBone, 1));
        } while ((currentBone = currentBone.getParent()) != null);
        CalculationBone[] result = bonesList.toArray(new CalculationBone[bonesList.size()]);
        for (int i = result.length - 1; i > 0; --i) {
            result[i].attachChild(result[i - 1]);
        }
        return result;
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_KINEMATIC;
    }
}

