/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.RenderState;
import com.jme3.renderer.Caps;
import com.jme3.shader.DefineList;
import com.jme3.shader.UniformBinding;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechniqueDef
implements Savable {
    private EnumSet<Caps> requiredCaps = EnumSet.noneOf(Caps.class);
    private String name;
    private String vertName;
    private String fragName;
    private String shaderLang;
    private DefineList presetDefines;
    private boolean usesShaders;
    private RenderState renderState;
    private LightMode lightMode = LightMode.Disable;
    private ShadowMode shadowMode = ShadowMode.Disable;
    private HashMap<String, String> defineParams;
    private ArrayList<UniformBinding> worldBinds;

    public TechniqueDef(String name) {
        this.name = name == null ? "Default" : name;
    }

    public TechniqueDef() {
    }

    public String getName() {
        return this.name;
    }

    public LightMode getLightMode() {
        return this.lightMode;
    }

    public void setLightMode(LightMode lightMode) {
        this.lightMode = lightMode;
    }

    public ShadowMode getShadowMode() {
        return this.shadowMode;
    }

    public void setShadowMode(ShadowMode shadowMode) {
        this.shadowMode = shadowMode;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public void setRenderState(RenderState renderState) {
        this.renderState = renderState;
    }

    public boolean isUsingShaders() {
        return this.usesShaders;
    }

    public EnumSet<Caps> getRequiredCaps() {
        return this.requiredCaps;
    }

    public void setShaderFile(String vertexShader, String fragmentShader, String shaderLanguage) {
        this.vertName = vertexShader;
        this.fragName = fragmentShader;
        this.shaderLang = shaderLanguage;
        Caps langCap = Caps.valueOf(shaderLanguage);
        this.requiredCaps.add(langCap);
        this.usesShaders = true;
    }

    public String getShaderParamDefine(String paramName) {
        if (this.defineParams == null) {
            return null;
        }
        return this.defineParams.get(paramName);
    }

    public void addShaderParamDefine(String paramName, String defineName) {
        if (this.defineParams == null) {
            this.defineParams = new HashMap();
        }
        this.defineParams.put(paramName, defineName);
    }

    public DefineList getShaderPresetDefines() {
        return this.presetDefines;
    }

    public void addShaderPresetDefine(String defineName, VarType type, Object value) {
        if (this.presetDefines == null) {
            this.presetDefines = new DefineList();
        }
        this.presetDefines.set(defineName, type, value);
    }

    public String getFragmentShaderName() {
        return this.fragName;
    }

    public String getVertexShaderName() {
        return this.vertName;
    }

    public String getShaderLanguage() {
        return this.shaderLang;
    }

    public boolean addWorldParam(String name) {
        if (this.worldBinds == null) {
            this.worldBinds = new ArrayList();
        }
        try {
            this.worldBinds.add(UniformBinding.valueOf(name));
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public List<UniformBinding> getWorldBindings() {
        return this.worldBinds;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.name, "name", null);
        oc.write(this.vertName, "vertName", null);
        oc.write(this.fragName, "fragName", null);
        oc.write(this.shaderLang, "shaderLang", null);
        oc.write(this.presetDefines, "presetDefines", null);
        oc.write(this.lightMode, "lightMode", LightMode.Disable);
        oc.write(this.shadowMode, "shadowMode", ShadowMode.Disable);
        oc.write(this.renderState, "renderState", null);
        oc.write(this.usesShaders, "usesShaders", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.name = ic.readString("name", null);
        this.vertName = ic.readString("vertName", null);
        this.fragName = ic.readString("fragName", null);
        this.shaderLang = ic.readString("shaderLang", null);
        this.presetDefines = (DefineList)ic.readSavable("presetDefines", null);
        this.lightMode = ic.readEnum("lightMode", LightMode.class, LightMode.Disable);
        this.shadowMode = ic.readEnum("shadowMode", ShadowMode.class, ShadowMode.Disable);
        this.renderState = (RenderState)ic.readSavable("renderState", null);
        this.usesShaders = ic.readBoolean("usesShaders", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShadowMode {
        Disable,
        InPass,
        PostPass;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LightMode {
        Disable,
        SinglePass,
        MultiPass,
        FixedPipeline;

    }
}

