/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.asset.GeneratedTextureKey;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.IAlphaMask;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.shader.VarType;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaterialHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MaterialHelper.class.getName());
    protected static final float DEFAULT_SHININESS = 20.0f;
    public static final String TEXTURE_TYPE_3D = "Texture";
    public static final String TEXTURE_TYPE_COLOR = "ColorMap";
    public static final String TEXTURE_TYPE_DIFFUSE = "DiffuseMap";
    public static final String TEXTURE_TYPE_NORMAL = "NormalMap";
    public static final String TEXTURE_TYPE_SPECULAR = "SpecularMap";
    public static final String TEXTURE_TYPE_GLOW = "GlowMap";
    public static final String TEXTURE_TYPE_ALPHA = "AlphaMap";
    public static final Integer ALPHA_MASK_NONE = 0;
    public static final Integer ALPHA_MASK_CIRCLE = 1;
    public static final Integer ALPHA_MASK_CONE = 2;
    public static final Integer ALPHA_MASK_HYPERBOLE = 3;
    protected final Map<Integer, IAlphaMask> alphaMasks = new HashMap<Integer, IAlphaMask>();
    protected RenderState.FaceCullMode faceCullMode;

    public MaterialHelper(String blenderVersion) {
        super(blenderVersion);
        this.alphaMasks.put(ALPHA_MASK_NONE, new IAlphaMask(){

            public void setImageSize(int width, int height) {
            }

            public byte getAlpha(float x, float y) {
                return -1;
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CIRCLE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1])));
                return (byte)(d >= this.r ? 0 : 255);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_CONE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1])));
                return (byte)(d >= this.r ? 0.0f : -255.0f * d / this.r + 255.0f);
            }
        });
        this.alphaMasks.put(ALPHA_MASK_HYPERBOLE, new IAlphaMask(){
            private float r;
            private float[] center;

            public void setImageSize(int width, int height) {
                this.r = (float)Math.min(width, height) * 0.5f;
                this.center = new float[]{(float)width * 0.5f, (float)height * 0.5f};
            }

            public byte getAlpha(float x, float y) {
                float d = FastMath.abs(FastMath.sqrt((x - this.center[0]) * (x - this.center[0]) + (y - this.center[1]) * (y - this.center[1]))) / this.r;
                return d >= 1.0f ? (byte)0 : (byte)((-FastMath.sqrt((2.0f - d) * d) + 1.0f) * 255.0f);
            }
        });
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    public Material toMaterial(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Loading material.");
        if (structure == null) {
            return dataRepository.getDefaultMaterial();
        }
        Material result = (Material)dataRepository.getLoadedFeature(structure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        MaterialContext materialContext = new MaterialContext(structure, dataRepository);
        LOGGER.log(Level.INFO, "Material's name: {0}", materialContext.name);
        HashMap<String, Texture> texturesMap = new HashMap<String, Texture>();
        Texture.Type firstTextureType = null;
        if ((dataRepository.getBlenderKey().getFeaturesToLoad() & 1) != 0) {
            TextureHelper textureHelper = (TextureHelper)dataRepository.getHelper(TextureHelper.class);
            for (int i = 0; i < materialContext.texturesCount; ++i) {
                Structure mtex = materialContext.mTexs.get(i);
                int texflag = ((Number)mtex.getFieldValue("texflag")).intValue();
                boolean negateTexture = (texflag & 4) == 0;
                int mapto = ((Number)mtex.getFieldValue("mapto")).intValue();
                if (mapto == 0) continue;
                Structure tex = materialContext.textures.get(i);
                Texture texture = textureHelper.getTexture(tex, dataRepository);
                if (texture != null) {
                    if (firstTextureType == null) {
                        firstTextureType = texture.getType();
                    } else if (firstTextureType != texture.getType()) {
                        LOGGER.warning("The texture with the name: " + texture.getName() + " is of different type than the first applied texture! It will not be applied!");
                        continue;
                    }
                    texture.setMinFilter(Texture.MinFilter.Trilinear);
                    if ((mapto & 1) != 0) {
                        int blendType = ((Number)mtex.getFieldValue("blendtype")).intValue();
                        float[] color = new float[]{((Number)mtex.getFieldValue("r")).floatValue(), ((Number)mtex.getFieldValue("g")).floatValue(), ((Number)mtex.getFieldValue("b")).floatValue()};
                        float colfac = ((Number)mtex.getFieldValue("colfac")).floatValue();
                        texture = textureHelper.blendTexture(new float[]{1.0f, 1.0f, 1.0f}, texture, color, colfac, blendType, negateTexture, dataRepository);
                        texture.setWrap(Texture.WrapMode.Repeat);
                        if (materialContext.shadeless) {
                            texturesMap.put(firstTextureType == Texture.Type.ThreeDimensional ? TEXTURE_TYPE_3D : TEXTURE_TYPE_COLOR, texture);
                        } else {
                            texturesMap.put(firstTextureType == Texture.Type.ThreeDimensional ? TEXTURE_TYPE_3D : TEXTURE_TYPE_DIFFUSE, texture);
                        }
                    }
                    if (firstTextureType == Texture.Type.TwoDimensional) {
                        if ((mapto & 2) != 0 && !materialContext.shadeless) {
                            Texture normalMapTexture;
                            if (texture.getKey() instanceof GeneratedTextureKey) {
                                normalMapTexture = textureHelper.convertToNormalMapTexture(texture, ((Number)mtex.getFieldValue("norfac")).floatValue());
                                normalMapTexture.setMinFilter(Texture.MinFilter.Trilinear);
                            } else {
                                normalMapTexture = texture;
                            }
                            texturesMap.put(TEXTURE_TYPE_NORMAL, normalMapTexture);
                        }
                        if ((mapto & 4) != 0 && !materialContext.shadeless) {
                            texturesMap.put(TEXTURE_TYPE_SPECULAR, texture);
                        }
                        if ((mapto & 0x40) != 0) {
                            texturesMap.put(TEXTURE_TYPE_GLOW, texture);
                        }
                        if ((mapto & 0x80) == 0 || materialContext.shadeless) continue;
                        texturesMap.put(TEXTURE_TYPE_ALPHA, texture);
                        continue;
                    }
                    LOGGER.warning("The following mappings: [Nor, Spec, Alpha] are available for 2D textures only!");
                    continue;
                }
                LOGGER.log(Level.WARNING, "Texture not found!");
            }
        }
        if (firstTextureType == Texture.Type.ThreeDimensional) {
            result = new Material(dataRepository.getAssetManager(), "jme3test/texture/tex3D.j3md");
        } else {
            result = materialContext.shadeless ? new Material(dataRepository.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md") : new Material(dataRepository.getAssetManager(), "Common/MatDefs/Light/Lighting.j3md");
            if (materialContext.vertexColor) {
                result.setBoolean(materialContext.shadeless ? "VertexColor" : "UseVertexColor", true);
            }
            ColorRGBA diffuseColor = null;
            if (materialContext.shadeless) {
                diffuseColor = ColorRGBA.White.clone();
            } else {
                result.setBoolean("UseMaterialColors", Boolean.TRUE);
                DiffuseShader diffuseShader = this.getDiffuseShader(structure);
                result.setBoolean("Minnaert", diffuseShader == DiffuseShader.MINNAERT);
                diffuseColor = this.getDiffuseColor(structure, diffuseShader);
                if (!materialContext.transparent) {
                    diffuseColor.a = 1.0f;
                }
                result.setColor("Diffuse", diffuseColor);
                SpecularShader specularShader = this.getSpecularShader(structure);
                result.setBoolean("WardIso", specularShader == SpecularShader.WARDISO);
                result.setColor("Specular", this.getSpecularColor(structure, specularShader));
                result.setColor("Ambient", this.getAmbientColor(structure));
                result.setFloat("Shininess", this.getShininess(structure));
            }
        }
        for (Map.Entry textureEntry : texturesMap.entrySet()) {
            result.setTexture((String)textureEntry.getKey(), (Texture)textureEntry.getValue());
        }
        result.getAdditionalRenderState().setFaceCullMode(this.faceCullMode);
        if (materialContext.transparent) {
            result.setTransparent(true);
            result.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }
        dataRepository.setMaterialContext(result, materialContext);
        dataRepository.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, result);
        return result;
    }

    public Material getNonTexturedMaterial(Material material, int imageType) {
        String[] textureParamNames = new String[]{TEXTURE_TYPE_DIFFUSE, TEXTURE_TYPE_NORMAL, TEXTURE_TYPE_GLOW, TEXTURE_TYPE_SPECULAR, TEXTURE_TYPE_ALPHA};
        HashMap<String, Texture> textures = new HashMap<String, Texture>(textureParamNames.length);
        for (String textureParamName : textureParamNames) {
            MatParamTexture matParamTexture = material.getTextureParam(textureParamName);
            if (matParamTexture == null) continue;
            textures.put(textureParamName, matParamTexture.getTextureValue());
        }
        if (textures.isEmpty()) {
            return material;
        }
        for (Map.Entry textureParamName : textures.entrySet()) {
            String name = ((Texture)textureParamName.getValue()).getName();
            try {
                int type = Integer.parseInt(name);
                if (type != imageType) continue;
                material.clearParam((String)textureParamName.getKey());
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "The name of the texture does not contain the texture type value! {0} will not be removed!", name);
            }
        }
        Material result = material.clone();
        for (Map.Entry textureEntry : textures.entrySet()) {
            material.setTexture((String)textureEntry.getKey(), (Texture)textureEntry.getValue());
        }
        return result;
    }

    public Material getParticlesMaterial(Material material, Integer alphaMaskIndex, DataRepository dataRepository) {
        MatParam glowColor;
        Material result = new Material(dataRepository.getAssetManager(), "Common/MatDefs/Misc/Particle.j3md");
        MatParam diffuseMap = material.getParam(TEXTURE_TYPE_DIFFUSE);
        if (diffuseMap != null) {
            Texture texture = ((Texture)diffuseMap.getValue()).clone();
            Image image = texture.getImage();
            ByteBuffer sourceBB = image.getData(0);
            sourceBB.rewind();
            int w = image.getWidth();
            int h = image.getHeight();
            ByteBuffer bb = BufferUtils.createByteBuffer(w * h * 4);
            IAlphaMask iAlphaMask = this.alphaMasks.get(alphaMaskIndex);
            iAlphaMask.setImageSize(w, h);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(sourceBB.get());
                    bb.put(iAlphaMask.getAlpha(x, y));
                }
            }
            image = new Image(Image.Format.RGBA8, w, h, bb);
            texture.setImage(image);
            result.setTextureParam(TEXTURE_TYPE_3D, VarType.Texture2D, texture);
        }
        if ((glowColor = material.getParam("GlowColor")) != null) {
            ColorRGBA color = (ColorRGBA)glowColor.getValue();
            result.setParam("GlowColor", VarType.Vector3, (Object)color);
        }
        return result;
    }

    public boolean hasTexture(Material material) {
        if (material != null) {
            if (material.getTextureParam(TEXTURE_TYPE_3D) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_ALPHA) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_COLOR) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_DIFFUSE) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_GLOW) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_NORMAL) != null) {
                return true;
            }
            if (material.getTextureParam(TEXTURE_TYPE_SPECULAR) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean hasTexture(Material material, String textureType) {
        if (material != null) {
            return material.getTextureParam(textureType) != null;
        }
        return false;
    }

    public ColorRGBA getDiffuseColor(Structure materialStructure, DiffuseShader diffuseShader) {
        int commonMapto = ((Number)materialStructure.getFieldValue("mapto")).intValue();
        float r = ((Number)materialStructure.getFieldValue("r")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("g")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("b")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        if ((commonMapto & 1) == 1) {
            return new ColorRGBA(r, g, b, alpha);
        }
        switch (diffuseShader) {
            case FRESNEL: 
            case ORENNAYAR: 
            case TOON: {
                break;
            }
            case MINNAERT: 
            case LAMBERT: {
                float ref = ((Number)materialStructure.getFieldValue("ref")).floatValue();
                r *= ref;
                g *= ref;
                b *= ref;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown diffuse shader type: " + diffuseShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    public DiffuseShader getDiffuseShader(Structure materialStructure) {
        int diff_shader = ((Number)materialStructure.getFieldValue("diff_shader")).intValue();
        return DiffuseShader.values()[diff_shader];
    }

    public ColorRGBA getAmbientColor(Structure materialStructure) {
        float r = ((Number)materialStructure.getFieldValue("ambr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("ambg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("ambb")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        return new ColorRGBA(r, g, b, alpha);
    }

    public SpecularShader getSpecularShader(Structure materialStructure) {
        int spec_shader = ((Number)materialStructure.getFieldValue("spec_shader")).intValue();
        return SpecularShader.values()[spec_shader];
    }

    public ColorRGBA getSpecularColor(Structure materialStructure, SpecularShader specularShader) {
        float r = ((Number)materialStructure.getFieldValue("specr")).floatValue();
        float g = ((Number)materialStructure.getFieldValue("specg")).floatValue();
        float b = ((Number)materialStructure.getFieldValue("specb")).floatValue();
        float alpha = ((Number)materialStructure.getFieldValue("alpha")).floatValue();
        switch (specularShader) {
            case BLINN: 
            case COOKTORRENCE: 
            case TOON: 
            case WARDISO: {
                break;
            }
            case PHONG: {
                float spec = ((Number)materialStructure.getFieldValue("spec")).floatValue();
                r *= spec * 0.5f;
                g *= spec * 0.5f;
                b *= spec * 0.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown specular shader type: " + specularShader.toString());
            }
        }
        return new ColorRGBA(r, g, b, alpha);
    }

    public float getShininess(Structure materialStructure) {
        float shininess = ((Number)materialStructure.getFieldValue("emit")).floatValue();
        return shininess > 0.0f ? shininess : 20.0f;
    }

    public Material[] getMaterials(Structure structureWithMaterials, DataRepository dataRepository) throws BlenderFileException {
        List<Structure> materialStructures;
        Pointer ppMaterials = (Pointer)structureWithMaterials.getFieldValue("mat");
        Material[] materials = null;
        if (ppMaterials.isNotNull() && (materialStructures = ppMaterials.fetchData(dataRepository.getInputStream())) != null && materialStructures.size() > 0) {
            MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
            materials = new Material[materialStructures.size()];
            int i = 0;
            for (Structure s : materialStructures) {
                Material material = (Material)dataRepository.getLoadedFeature(s.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
                if (material == null) {
                    material = materialHelper.toMaterial(s, dataRepository);
                }
                materials[i++] = material;
            }
        }
        return materials;
    }

    public void rgbToHsv(float r, float g, float b, float[] hsv) {
        float cmax = r;
        float cmin = r;
        cmax = g > cmax ? g : cmax;
        cmin = g < cmin ? g : cmin;
        cmax = b > cmax ? b : cmax;
        cmin = b < cmin ? b : cmin;
        hsv[2] = cmax;
        if ((double)cmax != 0.0) {
            hsv[1] = (cmax - cmin) / cmax;
        } else {
            hsv[1] = 0.0f;
            hsv[0] = 0.0f;
        }
        if ((double)hsv[1] == 0.0) {
            hsv[0] = -1.0f;
        } else {
            float cdelta = cmax - cmin;
            float rc = (cmax - r) / cdelta;
            float gc = (cmax - g) / cdelta;
            float bc = (cmax - b) / cdelta;
            hsv[0] = r == cmax ? bc - gc : (g == cmax ? 2.0f + rc - bc : 4.0f + gc - rc);
            hsv[0] = hsv[0] * 60.0f;
            if (hsv[0] < 0.0f) {
                hsv[0] = hsv[0] + 360.0f;
            }
        }
        hsv[0] = hsv[0] / 360.0f;
        if (hsv[0] < 0.0f) {
            hsv[0] = 0.0f;
        }
    }

    public void hsvToRgb(float h, float s, float v, float[] rgb) {
        h *= 360.0f;
        if ((double)s == 0.0) {
            rgb[1] = rgb[2] = v;
            rgb[0] = rgb[2];
        } else {
            h = h == 360.0f ? 0.0f : (h /= 60.0f);
            int i = (int)Math.floor(h);
            float f = h - (float)i;
            float p = v * (1.0f - s);
            float q = v * (1.0f - s * f);
            float t = v * (1.0f - s * (1.0f - f));
            switch (i) {
                case 0: {
                    rgb[0] = v;
                    rgb[1] = t;
                    rgb[2] = p;
                    break;
                }
                case 1: {
                    rgb[0] = q;
                    rgb[1] = v;
                    rgb[2] = p;
                    break;
                }
                case 2: {
                    rgb[0] = p;
                    rgb[1] = v;
                    rgb[2] = t;
                    break;
                }
                case 3: {
                    rgb[0] = p;
                    rgb[1] = q;
                    rgb[2] = v;
                    break;
                }
                case 4: {
                    rgb[0] = t;
                    rgb[1] = p;
                    rgb[2] = v;
                    break;
                }
                case 5: {
                    rgb[0] = v;
                    rgb[1] = p;
                    rgb[2] = q;
                }
            }
        }
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return (dataRepository.getBlenderKey().getFeaturesToLoad() & 3) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecularShader {
        COOKTORRENCE,
        PHONG,
        BLINN,
        TOON,
        WARDISO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffuseShader {
        LAMBERT,
        ORENNAYAR,
        TOON,
        MINNAERT,
        FRESNEL;

    }
}

