/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.MaterialList;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.util.xml.SAXUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SceneLoader
extends DefaultHandler
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private Stack<String> elementStack = new Stack();
    private String sceneName;
    private String folderName;
    private AssetManager assetManager;
    private MaterialList materialList;
    private Node root;
    private Node node;
    private Node entityNode;
    private Light light;
    private int nodeIdx = 0;
    private static volatile int sceneIdx = 0;

    public void startDocument() {
    }

    public void endDocument() {
    }

    private void reset() {
        this.elementStack.clear();
        this.nodeIdx = 0;
        this.root = null;
        this.node = null;
        this.entityNode = null;
        this.light = null;
    }

    private Quaternion parseQuat(Attributes attribs) throws SAXException {
        if (attribs.getValue("x") != null) {
            float x = SAXUtil.parseFloat(attribs.getValue("x"));
            float y = SAXUtil.parseFloat(attribs.getValue("y"));
            float z = SAXUtil.parseFloat(attribs.getValue("z"));
            float w = SAXUtil.parseFloat(attribs.getValue("w"));
            return new Quaternion(x, y, z, w);
        }
        if (attribs.getValue("qx") != null) {
            float x = SAXUtil.parseFloat(attribs.getValue("qx"));
            float y = SAXUtil.parseFloat(attribs.getValue("qy"));
            float z = SAXUtil.parseFloat(attribs.getValue("qz"));
            float w = SAXUtil.parseFloat(attribs.getValue("qw"));
            return new Quaternion(x, y, z, w);
        }
        if (attribs.getValue("angle") != null) {
            float angle = SAXUtil.parseFloat(attribs.getValue("angle"));
            float axisX = SAXUtil.parseFloat(attribs.getValue("axisX"));
            float axisY = SAXUtil.parseFloat(attribs.getValue("axisY"));
            float axisZ = SAXUtil.parseFloat(attribs.getValue("axisZ"));
            Quaternion q = new Quaternion();
            q.fromAngleAxis(angle, new Vector3f(axisX, axisY, axisZ));
            return q;
        }
        float angleX = SAXUtil.parseFloat(attribs.getValue("angleX"));
        float angleY = SAXUtil.parseFloat(attribs.getValue("angleY"));
        float angleZ = SAXUtil.parseFloat(attribs.getValue("angleZ"));
        Quaternion q = new Quaternion();
        q.fromAngles(angleX, angleY, angleZ);
        return q;
    }

    private void parseLightNormal(Attributes attribs) throws SAXException {
        assert (this.elementStack.peek().equals("light"));
        if (this.light instanceof DirectionalLight) {
            ((DirectionalLight)this.light).setDirection(SAXUtil.parseVector3(attribs));
        }
    }

    private void parseLightAttenuation(Attributes attribs) throws SAXException {
        assert (this.elementStack.peek().equals("light"));
        if (this.light instanceof PointLight) {
            float range = SAXUtil.parseFloat(attribs.getValue("range"));
            float constant = SAXUtil.parseFloat(attribs.getValue("constant"));
            float linear = SAXUtil.parseFloat(attribs.getValue("linear"));
            String quadraticStr = attribs.getValue("quadratic");
            if (quadraticStr == null) {
                quadraticStr = attribs.getValue("quadric");
            }
            float quadratic = SAXUtil.parseFloat(quadraticStr);
            if (constant == 1.0f && quadratic == 0.0f && linear > 0.0f) {
                range = 1.0f / linear;
            }
            ((PointLight)this.light).setRadius(range);
        }
    }

    private void parseLight(Attributes attribs) throws SAXException {
        assert (this.node != null);
        assert (this.node.getParent() != null);
        assert (this.elementStack.peek().equals("node"));
        String lightType = SAXUtil.parseString(attribs.getValue("type"), "point");
        if (lightType.equals("point")) {
            this.light = new PointLight();
        } else if (lightType.equals("directional") || lightType.equals("sun")) {
            this.light = new DirectionalLight();
            ((DirectionalLight)this.light).setDirection(Vector3f.UNIT_Z);
        } else if (lightType.equals("spotLight")) {
            logger.warning("No SpotLight class atm, using Pointlight instead.");
            this.light = new PointLight();
        } else {
            logger.log(Level.WARNING, "No matching jME3 LightType found for OGRE LightType: {0}", lightType);
        }
        logger.log(Level.FINEST, "{0} created.", this.light);
        if (!SAXUtil.parseBool(attribs.getValue("visible"), true)) {
            // empty if block
        }
        if (this.light != null) {
            this.node.getParent().addLight(this.light);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (qName.equals("scene")) {
            assert (this.elementStack.size() == 0);
            String version = attribs.getValue("formatVersion");
            if (version == null || !version.equals("1.0.0")) {
                logger.log(Level.WARNING, "Unrecognized version number in dotScene file: {0}", version);
            }
        } else if (qName.equals("nodes")) {
            assert (this.root == null);
            this.root = this.sceneName == null ? new Node("OgreDotScene" + ++sceneIdx) : new Node(this.sceneName + "-scene_node");
            this.node = this.root;
        } else if (qName.equals("externals")) {
            assert (this.elementStack.peek().equals("scene"));
        } else if (qName.equals("item")) {
            assert (this.elementStack.peek().equals("externals"));
        } else if (qName.equals("file")) {
            assert (this.elementStack.peek().equals("item"));
            String matFile = this.folderName + attribs.getValue("name");
            try {
                this.materialList = this.assetManager.loadAsset(new OgreMaterialKey(matFile));
            }
            catch (AssetNotFoundException ex) {
                this.materialList = null;
                logger.log(Level.WARNING, "Cannot locate material file: {0}", matFile);
            }
        } else if (qName.equals("node")) {
            String curElement = this.elementStack.peek();
            assert (curElement.equals("nodes") || curElement.equals("node"));
            String name = attribs.getValue("name");
            if (name == null) {
                name = "OgreNode-" + ++this.nodeIdx;
            }
            Node newNode = new Node(name);
            if (this.node != null) {
                this.node.attachChild(newNode);
            }
            this.node = newNode;
        } else if (qName.equals("property")) {
            if (this.node != null) {
                String type = attribs.getValue("type");
                String name = attribs.getValue("name");
                String data = attribs.getValue("data");
                if (type.equals("BOOL")) {
                    this.node.setUserData(name, Boolean.parseBoolean(data) || data.equals("1"));
                } else if (type.equals("FLOAT")) {
                    this.node.setUserData(name, Float.valueOf(Float.parseFloat(data)));
                } else if (type.equals("STRING")) {
                    this.node.setUserData(name, data);
                } else if (type.equals("INT")) {
                    this.node.setUserData(name, Integer.parseInt(data));
                }
            }
        } else if (qName.equals("entity")) {
            assert (this.elementStack.peek().equals("node"));
            String name = attribs.getValue("name");
            name = name == null ? "OgreEntity-" + ++this.nodeIdx : name + "-entity";
            String meshFile = attribs.getValue("meshFile");
            if (meshFile == null) {
                throw new SAXException("Required attribute 'meshFile' missing for 'entity' node");
            }
            String materialName = attribs.getValue("materialName");
            if (this.folderName != null) {
                meshFile = this.folderName + meshFile;
            }
            meshFile = meshFile + ".xml";
            this.entityNode = new Node(name);
            OgreMeshKey key = new OgreMeshKey(meshFile, this.materialList);
            Spatial ogreMesh = this.assetManager.loadAsset(key);
            if (ogreMesh == null) {
                meshFile = this.folderName + attribs.getValue("meshFile") + "xml";
                key = new OgreMeshKey(meshFile, this.materialList);
                ogreMesh = this.assetManager.loadAsset(key);
            }
            this.entityNode.attachChild(ogreMesh);
            this.node.attachChild(this.entityNode);
            this.node = null;
        } else if (qName.equals("position")) {
            this.node.setLocalTranslation(SAXUtil.parseVector3(attribs));
        } else if (qName.equals("quaternion") || qName.equals("rotation")) {
            this.node.setLocalRotation(this.parseQuat(attribs));
        } else if (qName.equals("scale")) {
            this.node.setLocalScale(SAXUtil.parseVector3(attribs));
        } else if (qName.equals("light")) {
            this.parseLight(attribs);
        } else if (qName.equals("colourDiffuse") || qName.equals("colorDiffuse")) {
            if (this.elementStack.peek().equals("light")) {
                if (this.light != null) {
                    this.light.setColor(SAXUtil.parseColor(attribs));
                }
            } else assert (this.elementStack.peek().equals("environment"));
        } else if (qName.equals("normal")) {
            this.parseLightNormal(attribs);
        } else if (qName.equals("lightAttenuation")) {
            this.parseLightAttenuation(attribs);
        }
        this.elementStack.push(qName);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("node")) {
            this.node = this.node.getParent();
        } else if (qName.equals("nodes")) {
            this.node = null;
        } else if (qName.equals("entity")) {
            this.node = this.entityNode.getParent();
            this.entityNode = null;
        } else if (qName.equals("light")) {
            this.root.updateGeometricState();
            if (this.light != null) {
                if (this.light instanceof DirectionalLight) {
                    DirectionalLight dl = (DirectionalLight)this.light;
                    Quaternion q = this.node.getWorldRotation();
                    Vector3f dir = dl.getDirection();
                    q.multLocal(dir);
                    dl.setDirection(dir);
                } else if (this.light instanceof PointLight) {
                    PointLight pl = (PointLight)this.light;
                    Vector3f pos = this.node.getWorldTranslation();
                    pl.setPosition(pos);
                }
            }
            this.light = null;
        }
        assert (this.elementStack.peek().equals(qName));
        this.elementStack.pop();
    }

    public void characters(char[] ch, int start, int length) {
    }

    public Object load(AssetInfo info) throws IOException {
        try {
            this.assetManager = info.getManager();
            this.sceneName = info.getKey().getName();
            String ext = info.getKey().getExtension();
            this.folderName = info.getKey().getFolder();
            this.sceneName = this.sceneName.substring(0, this.sceneName.length() - ext.length() - 1);
            try {
                this.materialList = this.assetManager.loadAsset(new OgreMaterialKey(this.sceneName + ".material"));
            }
            catch (AssetNotFoundException ex) {
                logger.log(Level.WARNING, "Cannot locate material file {0}", ex.getMessage());
                this.materialList = null;
            }
            this.reset();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = new InputStreamReader(info.openStream());
            xr.parse(new InputSource(r));
            r.close();
            return this.root;
        }
        catch (SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
        catch (ParserConfigurationException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

