/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class HDRLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(HDRLoader.class.getName());
    private boolean writeRGBE = false;
    private ByteBuffer rleTempBuffer;
    private ByteBuffer dataStore;
    private final float[] tempF = new float[3];

    public HDRLoader(boolean writeRGBE) {
        this.writeRGBE = writeRGBE;
    }

    public HDRLoader() {
    }

    public static final void convertFloatToRGBE(byte[] rgbe, float red, float green, float blue) {
        double max = red;
        if ((double)green > max) {
            max = green;
        }
        if ((double)blue > max) {
            max = blue;
        }
        if (max < 1.0E-32) {
            rgbe[3] = 0;
            rgbe[2] = 0;
            rgbe[1] = 0;
            rgbe[0] = 0;
        } else {
            double exp = Math.ceil(Math.log10(max) / Math.log10(2.0));
            double divider = Math.pow(2.0, exp);
            rgbe[0] = (byte)((double)red / divider * 255.0);
            rgbe[1] = (byte)((double)green / divider * 255.0);
            rgbe[2] = (byte)((double)blue / divider * 255.0);
            rgbe[3] = (byte)(exp + 128.0);
        }
    }

    public static final void convertRGBEtoFloat(byte[] rgbe, float[] rgbf) {
        int R2 = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 136);
        rgbf[0] = (float)R2 * e;
        rgbf[1] = (float)G * e;
        rgbf[2] = (float)B * e;
    }

    public static final void convertRGBEtoFloat2(byte[] rgbe, float[] rgbf) {
        int R2 = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 128);
        rgbf[0] = (float)R2 / 256.0f * e;
        rgbf[1] = (float)G / 256.0f * e;
        rgbf[2] = (float)B / 256.0f * e;
    }

    public static final void convertRGBEtoFloat3(byte[] rgbe, float[] rgbf) {
        int R2 = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 136);
        rgbf[0] = (float)R2 * e;
        rgbf[1] = (float)G * e;
        rgbf[2] = (float)B * e;
    }

    private short flip(int in) {
        return (short)(in << 8 & 0xFF00 | in >> 8);
    }

    private void writeRGBE(byte[] rgbe) {
        if (this.writeRGBE) {
            this.dataStore.put(rgbe);
        } else {
            HDRLoader.convertRGBEtoFloat(rgbe, this.tempF);
            this.dataStore.putShort(FastMath.convertFloatToHalf(this.tempF[0])).putShort(FastMath.convertFloatToHalf(this.tempF[1])).putShort(FastMath.convertFloatToHalf(this.tempF[2]));
        }
    }

    private String readString(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i;
        while ((i = is.read()) != 10 && i != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    private boolean decodeScanlineRLE(InputStream in, int width) throws IOException {
        if (this.rleTempBuffer == null) {
            this.rleTempBuffer = BufferUtils.createByteBuffer(width * 4);
        } else {
            this.rleTempBuffer.clear();
            if (this.rleTempBuffer.remaining() < width * 4) {
                this.rleTempBuffer = BufferUtils.createByteBuffer(width * 4);
            }
        }
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < width) {
                int val;
                int code = in.read();
                if (code > 128) {
                    code -= 128;
                    val = in.read();
                    while (code-- != 0) {
                        this.rleTempBuffer.put(j++ * 4 + i, (byte)val);
                    }
                    continue;
                }
                while (code-- != 0) {
                    val = in.read();
                    this.rleTempBuffer.put(j++ * 4 + i, (byte)val);
                }
            }
        }
        this.rleTempBuffer.rewind();
        byte[] rgbe = new byte[4];
        for (int i = 0; i < width; ++i) {
            this.rleTempBuffer.get(rgbe);
            this.writeRGBE(rgbe);
        }
        return true;
    }

    private boolean decodeScanlineUncompressed(InputStream in, int width) throws IOException {
        byte[] rgbe = new byte[4];
        for (int i = 0; i < width; i += 3) {
            if (in.read(rgbe) < 1) {
                return false;
            }
            this.writeRGBE(rgbe);
        }
        return true;
    }

    private void decodeScanline(InputStream in, int width) throws IOException {
        if (width < 8 || width > Short.MAX_VALUE) {
            this.decodeScanlineUncompressed(in, width);
        }
        byte[] data = new byte[4];
        in.read(data);
        if (data[0] != 2 || data[1] != 2 || (data[2] & 0x80) != 0) {
            this.decodeScanlineUncompressed(in, width - 1);
        } else {
            int readWidth = (data[2] & 0xFF) << 8 | data[3] & 0xFF;
            if (readWidth != width) {
                throw new IOException("Illegal scanline width in HDR file: " + width + " != " + readWidth);
            }
            this.decodeScanlineRLE(in, width);
        }
    }

    public Image load(InputStream in, boolean flipY) throws IOException {
        String[] resData;
        float gamma = -1.0f;
        float exposure = -1.0f;
        float[] colorcorr = new float[]{-1.0f, -1.0f, -1.0f};
        int width = -1;
        int height = -1;
        boolean verifiedFormat = false;
        while (true) {
            String ln = this.readString(in);
            if ((ln = ln.trim()).startsWith("#") || ln.equals("")) {
                if (!ln.equals("#?RADIANCE") && !ln.equals("#?RGBE")) continue;
                verifiedFormat = true;
                continue;
            }
            if (ln.startsWith("+") || ln.startsWith("-")) {
                resData = ln.split(" ");
                if (resData.length != 4) {
                    throw new IOException("Invalid resolution string in HDR file");
                }
                if (!resData[0].equals("-Y") || !resData[2].equals("+X")) {
                    logger.warning("Flipping/Rotating attributes ignored!");
                }
                break;
            }
            int index = ln.indexOf("=");
            if (index < 1) {
                logger.fine("Ignored string: " + ln);
                continue;
            }
            String var = ln.substring(0, index).trim().toLowerCase();
            String value = ln.substring(index + 1).trim().toLowerCase();
            if (var.equals("format")) {
                if (value.equals("32-bit_rle_rgbe") || value.equals("32-bit_rle_xyze")) continue;
                throw new IOException("Unsupported format in HDR picture");
            }
            if (var.equals("exposure")) {
                exposure = Float.parseFloat(value);
                continue;
            }
            if (var.equals("gamma")) {
                gamma = Float.parseFloat(value);
                continue;
            }
            logger.warning("HDR Command ignored: " + ln);
        }
        width = Integer.parseInt(resData[3]);
        height = Integer.parseInt(resData[1]);
        assert (width != -1 && height != -1);
        if (!verifiedFormat) {
            logger.warning("Unsure if specified image is Radiance HDR");
        }
        System.gc();
        Image.Format pixelFormat = this.writeRGBE ? Image.Format.RGBA8 : Image.Format.RGB16F;
        this.dataStore = BufferUtils.createByteBuffer(width * height * pixelFormat.getBitsPerPixel());
        int bytesPerPixel = pixelFormat.getBitsPerPixel() / 8;
        int scanLineBytes = bytesPerPixel * width;
        for (int y = height - 1; y >= 0; --y) {
            if (flipY) {
                this.dataStore.position(scanLineBytes * y);
            }
            this.decodeScanline(in, width);
        }
        in.close();
        this.dataStore.rewind();
        return new Image(pixelFormat, width, height, this.dataStore);
    }

    public Object load(AssetInfo info) throws IOException {
        if (!(info.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        boolean flip = ((TextureKey)info.getKey()).isFlipY();
        InputStream in = info.openStream();
        Image img = this.load(in, flip);
        in.close();
        return img;
    }
}

