/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.app.AppTask;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionEventFactory;
import com.jme3.bullet.collision.PhysicsCollisionGroupListener;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.PhysicsRayTestResult;
import com.jme3.bullet.collision.PhysicsSweepTestResult;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsGhostObject;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsSpace {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    private long physicsSpaceId = 0L;
    private static ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>> pQueueTL = new ThreadLocal<ConcurrentLinkedQueue<AppTask<?>>>(){

        @Override
        protected ConcurrentLinkedQueue<AppTask<?>> initialValue() {
            return new ConcurrentLinkedQueue();
        }
    };
    private ConcurrentLinkedQueue<AppTask<?>> pQueue = new ConcurrentLinkedQueue();
    private static ThreadLocal<PhysicsSpace> physicsSpaceTL = new ThreadLocal();
    private BroadphaseType broadphaseType = BroadphaseType.DBVT;
    private Map<Long, PhysicsRigidBody> physicsNodes = new ConcurrentHashMap<Long, PhysicsRigidBody>();
    private List<PhysicsJoint> physicsJoints = new LinkedList<PhysicsJoint>();
    private List<PhysicsCollisionListener> collisionListeners = new LinkedList<PhysicsCollisionListener>();
    private List<PhysicsCollisionEvent> collisionEvents = new LinkedList<PhysicsCollisionEvent>();
    private Map<Integer, PhysicsCollisionGroupListener> collisionGroupListeners = new ConcurrentHashMap<Integer, PhysicsCollisionGroupListener>();
    private ConcurrentLinkedQueue<PhysicsTickListener> tickListeners = new ConcurrentLinkedQueue();
    private PhysicsCollisionEventFactory eventFactory = new PhysicsCollisionEventFactory();
    private Vector3f worldMin = new Vector3f(-10000.0f, -10000.0f, -10000.0f);
    private Vector3f worldMax = new Vector3f(10000.0f, 10000.0f, 10000.0f);
    private float accuracy = 0.016666668f;
    private int maxSubSteps = 4;
    private AssetManager debugManager;

    public static PhysicsSpace getPhysicsSpace() {
        return physicsSpaceTL.get();
    }

    public static void setLocalThreadPhysicsSpace(PhysicsSpace physicsSpace) {
        physicsSpaceTL.set(physicsSpace);
    }

    public PhysicsSpace() {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), BroadphaseType.DBVT);
    }

    public PhysicsSpace(BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public PhysicsSpace(Vector3f vector3f, Vector3f vector3f2) {
        this(vector3f, vector3f2, BroadphaseType.AXIS_SWEEP_3);
    }

    public PhysicsSpace(Vector3f vector3f, Vector3f vector3f2, BroadphaseType broadphaseType) {
        this.worldMin.set(vector3f);
        this.worldMax.set(vector3f2);
        this.broadphaseType = broadphaseType;
        this.create();
    }

    public void create() {
        this.physicsSpaceId = this.createPhysicsSpace(this.worldMin.x, this.worldMin.y, this.worldMin.z, this.worldMax.x, this.worldMax.y, this.worldMax.z, 3, false);
        pQueueTL.set(this.pQueue);
        physicsSpaceTL.set(this);
    }

    private native long createPhysicsSpace(float var1, float var2, float var3, float var4, float var5, float var6, int var7, boolean var8);

    private void preTick_native(float f) {
        AppTask<?> appTask = this.pQueue.poll();
        appTask = this.pQueue.poll();
        while (appTask != null) {
            while (appTask.isCancelled()) {
                appTask = this.pQueue.poll();
            }
            try {
                appTask.invoke();
            }
            catch (Exception exception) {
                Logger.getLogger(PhysicsSpace.class.getName()).log(Level.SEVERE, null, exception);
            }
            appTask = this.pQueue.poll();
        }
        for (PhysicsTickListener physicsTickListener : this.tickListeners) {
            physicsTickListener.prePhysicsTick(this, f);
        }
    }

    private void postTick_native(float f) {
        for (PhysicsTickListener physicsTickListener : this.tickListeners) {
            physicsTickListener.physicsTick(this, f);
        }
    }

    private void addCollision_native() {
    }

    private boolean needCollision_native(PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2) {
        return false;
    }

    public void addCollisionEvent(PhysicsCollisionObject physicsCollisionObject, PhysicsCollisionObject physicsCollisionObject2, long l) {
        this.collisionEvents.add(this.eventFactory.getEvent(1, physicsCollisionObject, physicsCollisionObject2, l));
    }

    public void update(float f) {
        this.update(f, this.maxSubSteps);
    }

    public void update(float f, int n) {
        this.stepSimulation(this.physicsSpaceId, f, n, this.accuracy);
    }

    private native void stepSimulation(long var1, float var3, int var4, float var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distributeEvents() {
        List<PhysicsCollisionEvent> list = this.collisionEvents;
        synchronized (list) {
            Iterator<PhysicsCollisionEvent> iterator = this.collisionEvents.iterator();
            while (iterator.hasNext()) {
                PhysicsCollisionEvent physicsCollisionEvent = iterator.next();
                for (PhysicsCollisionListener physicsCollisionListener : this.collisionListeners) {
                    physicsCollisionListener.collision(physicsCollisionEvent);
                }
                this.eventFactory.recycle(physicsCollisionEvent);
                iterator.remove();
            }
        }
    }

    public static <V> Future<V> enqueueOnThisThread(Callable<V> callable) {
        AppTask appTask = new AppTask(callable);
        System.out.println("created apptask");
        pQueueTL.get().add(appTask);
        return appTask;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask appTask = new AppTask(callable);
        this.pQueue.add(appTask);
        return appTask;
    }

    public void add(Object object) {
        if (object instanceof PhysicsControl) {
            ((PhysicsControl)object).setPhysicsSpace(this);
        } else if (object instanceof Spatial) {
            Spatial spatial = (Spatial)object;
            PhysicsControl physicsControl = (PhysicsControl)spatial.getControl(PhysicsControl.class);
            physicsControl.setPhysicsSpace(this);
        } else if (object instanceof PhysicsCollisionObject) {
            this.addCollisionObject((PhysicsCollisionObject)object);
        } else if (object instanceof PhysicsJoint) {
            this.addJoint((PhysicsJoint)object);
        } else {
            throw new UnsupportedOperationException("Cannot add this kind of object to the physics space.");
        }
    }

    public void addCollisionObject(PhysicsCollisionObject physicsCollisionObject) {
        if (physicsCollisionObject instanceof PhysicsGhostObject) {
            this.addGhostObject((PhysicsGhostObject)physicsCollisionObject);
        } else if (physicsCollisionObject instanceof PhysicsRigidBody) {
            this.addRigidBody((PhysicsRigidBody)physicsCollisionObject);
        } else if (physicsCollisionObject instanceof PhysicsVehicle) {
            this.addRigidBody((PhysicsVehicle)physicsCollisionObject);
        } else if (physicsCollisionObject instanceof PhysicsCharacter) {
            this.addCharacter((PhysicsCharacter)physicsCollisionObject);
        }
    }

    public void remove(Object object) {
        if (object instanceof PhysicsControl) {
            ((PhysicsControl)object).setPhysicsSpace(null);
        } else if (object instanceof Spatial) {
            Spatial spatial = (Spatial)object;
            PhysicsControl physicsControl = (PhysicsControl)spatial.getControl(PhysicsControl.class);
            physicsControl.setPhysicsSpace(null);
        } else if (object instanceof PhysicsCollisionObject) {
            this.removeCollisionObject((PhysicsCollisionObject)object);
        } else if (object instanceof PhysicsJoint) {
            this.removeJoint((PhysicsJoint)object);
        } else {
            throw new UnsupportedOperationException("Cannot remove this kind of object from the physics space.");
        }
    }

    public void removeCollisionObject(PhysicsCollisionObject physicsCollisionObject) {
        if (physicsCollisionObject instanceof PhysicsGhostObject) {
            this.removeGhostObject((PhysicsGhostObject)physicsCollisionObject);
        } else if (physicsCollisionObject instanceof PhysicsRigidBody) {
            this.removeRigidBody((PhysicsRigidBody)physicsCollisionObject);
        } else if (physicsCollisionObject instanceof PhysicsCharacter) {
            this.removeCharacter((PhysicsCharacter)physicsCollisionObject);
        }
    }

    public void addAll(Spatial spatial) {
        Spatial spatial2;
        Object object;
        Object object2;
        if (spatial.getControl(RigidBodyControl.class) != null) {
            object2 = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            if (!this.physicsNodes.containsValue(object2)) {
                ((RigidBodyControl)object2).setPhysicsSpace(this);
            }
            object = ((PhysicsRigidBody)object2).getJoints();
            spatial2 = object.iterator();
            while (spatial2.hasNext()) {
                PhysicsJoint physicsJoint = spatial2.next();
                if (!this.physicsNodes.containsValue(physicsJoint.getBodyA())) {
                    if (physicsJoint.getBodyA() instanceof PhysicsControl) {
                        this.add(physicsJoint.getBodyA());
                    } else {
                        this.addRigidBody(physicsJoint.getBodyA());
                    }
                }
                if (!this.physicsNodes.containsValue(physicsJoint.getBodyB())) {
                    if (physicsJoint.getBodyA() instanceof PhysicsControl) {
                        this.add(physicsJoint.getBodyB());
                    } else {
                        this.addRigidBody(physicsJoint.getBodyB());
                    }
                }
                if (this.physicsJoints.contains(physicsJoint)) continue;
                this.addJoint(physicsJoint);
            }
        } else if (spatial.getControl(PhysicsControl.class) != null) {
            ((PhysicsControl)spatial.getControl(PhysicsControl.class)).setPhysicsSpace(this);
        }
        if (spatial instanceof Node) {
            object2 = ((Node)spatial).getChildren();
            object = object2.iterator();
            while (object.hasNext()) {
                spatial2 = (Spatial)object.next();
                this.addAll(spatial2);
            }
        }
    }

    public void removeAll(Spatial spatial) {
        Spatial spatial2;
        Object object;
        Object object2;
        if (spatial.getControl(RigidBodyControl.class) != null) {
            object2 = (RigidBodyControl)spatial.getControl(RigidBodyControl.class);
            if (this.physicsNodes.containsValue(object2)) {
                ((RigidBodyControl)object2).setPhysicsSpace(null);
            }
            object = ((PhysicsRigidBody)object2).getJoints();
            spatial2 = object.iterator();
            while (spatial2.hasNext()) {
                PhysicsJoint physicsJoint = spatial2.next();
                if (this.physicsNodes.containsValue(physicsJoint.getBodyA())) {
                    if (physicsJoint.getBodyA() instanceof PhysicsControl) {
                        this.remove(physicsJoint.getBodyA());
                    } else {
                        this.removeRigidBody(physicsJoint.getBodyA());
                    }
                }
                if (this.physicsNodes.containsValue(physicsJoint.getBodyB())) {
                    if (physicsJoint.getBodyA() instanceof PhysicsControl) {
                        this.remove(physicsJoint.getBodyB());
                    } else {
                        this.removeRigidBody(physicsJoint.getBodyB());
                    }
                }
                if (!this.physicsJoints.contains(physicsJoint)) continue;
                this.removeJoint(physicsJoint);
            }
        } else if (spatial.getControl(PhysicsControl.class) != null) {
            ((PhysicsControl)spatial.getControl(PhysicsControl.class)).setPhysicsSpace(null);
        }
        if (spatial instanceof Node) {
            object2 = ((Node)spatial).getChildren();
            object = object2.iterator();
            while (object.hasNext()) {
                spatial2 = (Spatial)object.next();
                this.removeAll(spatial2);
            }
        }
    }

    private native void addCollisionObject(long var1, long var3);

    private native void removeCollisionObject(long var1, long var3);

    private native void addRigidBody(long var1, long var3);

    private native void removeRigidBody(long var1, long var3);

    private native void addCharacterObject(long var1, long var3);

    private native void removeCharacterObject(long var1, long var3);

    private native void addAction(long var1, long var3);

    private native void removeAction(long var1, long var3);

    private native void addVehicle(long var1, long var3);

    private native void removeVehicle(long var1, long var3);

    private native void addConstraint(long var1, long var3);

    private native void removeConstraint(long var1, long var3);

    private void addGhostObject(PhysicsGhostObject physicsGhostObject) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Adding ghost object {0} to physics space.", Long.toHexString(physicsGhostObject.getObjectId()));
        this.addCollisionObject(this.physicsSpaceId, physicsGhostObject.getObjectId());
    }

    private void removeGhostObject(PhysicsGhostObject physicsGhostObject) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Removing ghost object {0} from physics space.", Long.toHexString(physicsGhostObject.getObjectId()));
        this.removeCollisionObject(this.physicsSpaceId, physicsGhostObject.getObjectId());
    }

    private void addCharacter(PhysicsCharacter physicsCharacter) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Adding character {0} to physics space.", Long.toHexString(physicsCharacter.getObjectId()));
        this.addCharacterObject(this.physicsSpaceId, physicsCharacter.getObjectId());
        this.addAction(this.physicsSpaceId, physicsCharacter.getControllerId());
    }

    private void removeCharacter(PhysicsCharacter physicsCharacter) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Removing character {0} from physics space.", Long.toHexString(physicsCharacter.getObjectId()));
        this.removeAction(this.physicsSpaceId, physicsCharacter.getControllerId());
        this.removeCharacterObject(this.physicsSpaceId, physicsCharacter.getObjectId());
    }

    private void addRigidBody(PhysicsRigidBody physicsRigidBody) {
        this.physicsNodes.put(physicsRigidBody.getObjectId(), physicsRigidBody);
        boolean bl = false;
        if (physicsRigidBody.isKinematic()) {
            bl = true;
            physicsRigidBody.setKinematic(false);
        }
        this.addRigidBody(this.physicsSpaceId, physicsRigidBody.getObjectId());
        if (bl) {
            physicsRigidBody.setKinematic(true);
        }
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Adding RigidBody {0} to physics space.", physicsRigidBody.getObjectId());
        if (physicsRigidBody instanceof PhysicsVehicle) {
            Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Adding vehicle constraint {0} to physics space.", Long.toHexString(((PhysicsVehicle)physicsRigidBody).getVehicleId()));
            ((PhysicsVehicle)physicsRigidBody).createVehicle(this);
            this.addVehicle(this.physicsSpaceId, ((PhysicsVehicle)physicsRigidBody).getVehicleId());
        }
    }

    private void removeRigidBody(PhysicsRigidBody physicsRigidBody) {
        if (physicsRigidBody instanceof PhysicsVehicle) {
            Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Removing vehicle constraint {0} from physics space.", Long.toHexString(((PhysicsVehicle)physicsRigidBody).getVehicleId()));
            this.removeVehicle(this.physicsSpaceId, ((PhysicsVehicle)physicsRigidBody).getVehicleId());
        }
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Removing RigidBody {0} from physics space.", Long.toHexString(physicsRigidBody.getObjectId()));
        this.physicsNodes.remove(physicsRigidBody.getObjectId());
        this.removeRigidBody(this.physicsSpaceId, physicsRigidBody.getObjectId());
    }

    private void addJoint(PhysicsJoint physicsJoint) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Adding Joint {0} to physics space.", Long.toHexString(physicsJoint.getObjectId()));
        this.physicsJoints.add(physicsJoint);
        this.addConstraint(this.physicsSpaceId, physicsJoint.getObjectId());
    }

    private void removeJoint(PhysicsJoint physicsJoint) {
        Logger.getLogger(PhysicsSpace.class.getName()).log(Level.INFO, "Removing Joint {0} from physics space.", Long.toHexString(physicsJoint.getObjectId()));
        this.physicsJoints.remove(physicsJoint);
        this.removeConstraint(this.physicsSpaceId, physicsJoint.getObjectId());
    }

    public void setGravity(Vector3f vector3f) {
        this.setGravity(this.physicsSpaceId, vector3f);
    }

    private native void setGravity(long var1, Vector3f var3);

    public void addTickListener(PhysicsTickListener physicsTickListener) {
        this.tickListeners.add(physicsTickListener);
    }

    public void removeTickListener(PhysicsTickListener physicsTickListener) {
        this.tickListeners.remove(physicsTickListener);
    }

    public void addCollisionListener(PhysicsCollisionListener physicsCollisionListener) {
        this.collisionListeners.add(physicsCollisionListener);
    }

    public void removeCollisionListener(PhysicsCollisionListener physicsCollisionListener) {
        this.collisionListeners.remove(physicsCollisionListener);
    }

    public void addCollisionGroupListener(PhysicsCollisionGroupListener physicsCollisionGroupListener, int n) {
        this.collisionGroupListeners.put(n, physicsCollisionGroupListener);
    }

    public void removeCollisionGroupListener(int n) {
        this.collisionGroupListeners.remove(n);
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f vector3f, Vector3f vector3f2) {
        LinkedList<PhysicsRayTestResult> linkedList = new LinkedList<PhysicsRayTestResult>();
        return linkedList;
    }

    public List<PhysicsRayTestResult> rayTest(Vector3f vector3f, Vector3f vector3f2, List<PhysicsRayTestResult> list) {
        list.clear();
        return list;
    }

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape collisionShape, Transform transform, Transform transform2) {
        LinkedList<PhysicsSweepTestResult> linkedList = new LinkedList<PhysicsSweepTestResult>();
        return linkedList;
    }

    public List<PhysicsSweepTestResult> sweepTest(CollisionShape collisionShape, Transform transform, Transform transform2, List<PhysicsSweepTestResult> list) {
        list.clear();
        return list;
    }

    public void destroy() {
        this.physicsNodes.clear();
        this.physicsJoints.clear();
    }

    public long getSpaceId() {
        return this.physicsSpaceId;
    }

    public BroadphaseType getBroadphaseType() {
        return this.broadphaseType;
    }

    public void setBroadphaseType(BroadphaseType broadphaseType) {
        this.broadphaseType = broadphaseType;
    }

    public void setMaxSubSteps(int n) {
        this.maxSubSteps = n;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float f) {
        this.accuracy = f;
    }

    public Vector3f getWorldMin() {
        return this.worldMin;
    }

    public void setWorldMin(Vector3f vector3f) {
        this.worldMin.set(vector3f);
    }

    public Vector3f getWorldMax() {
        return this.worldMax;
    }

    public void setWorldMax(Vector3f vector3f) {
        this.worldMax.set(vector3f);
    }

    public void enableDebug(AssetManager assetManager) {
        this.debugManager = assetManager;
    }

    public void disableDebug() {
        this.debugManager = null;
    }

    public AssetManager getDebugManager() {
        return this.debugManager;
    }

    public static native void initNativePhysics();

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Finalizing PhysicsSpace {0}", Long.toHexString(this.physicsSpaceId));
        this.finalizeNative(this.physicsSpaceId);
    }

    private native void finalizeNative(long var1);

    public static enum BroadphaseType {
        SIMPLE,
        AXIS_SWEEP_3,
        AXIS_SWEEP_3_32,
        DBVT;

    }
}

