/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.infos.RigidBodyMotionState;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicsRigidBody
extends PhysicsCollisionObject {
    protected RigidBodyMotionState motionState = new RigidBodyMotionState();
    protected float mass = 1.0f;
    protected boolean kinematic = false;
    protected ArrayList<PhysicsJoint> joints = new ArrayList();

    public PhysicsRigidBody() {
    }

    public PhysicsRigidBody(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
        this.rebuildRigidBody();
    }

    public PhysicsRigidBody(CollisionShape collisionShape, float f) {
        this.collisionShape = collisionShape;
        this.mass = f;
        this.rebuildRigidBody();
    }

    protected void rebuildRigidBody() {
        boolean bl = false;
        if (this.collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId != 0L) {
            if (this.isInWorld(this.objectId)) {
                PhysicsSpace.getPhysicsSpace().remove(this);
                bl = true;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Clearing RigidBody {0}", Long.toHexString(this.objectId));
            this.finalizeNative(this.objectId);
        }
        this.preRebuild();
        this.objectId = this.createRigidBody(this.mass, this.motionState.getObjectId(), this.collisionShape.getObjectId());
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created RigidBody {0}", Long.toHexString(this.objectId));
        this.postRebuild();
        if (bl) {
            PhysicsSpace.getPhysicsSpace().add(this);
        }
    }

    protected void preRebuild() {
    }

    private native long createRigidBody(float var1, long var2, long var4);

    protected void postRebuild() {
        if (this.mass == 0.0f) {
            this.setStatic(this.objectId, true);
        } else {
            this.setStatic(this.objectId, false);
        }
        this.initUserPointer();
    }

    public RigidBodyMotionState getMotionState() {
        return this.motionState;
    }

    public boolean isInWorld() {
        return this.isInWorld(this.objectId);
    }

    private native boolean isInWorld(long var1);

    public void setPhysicsLocation(Vector3f vector3f) {
        this.setPhysicsLocation(this.objectId, vector3f);
    }

    private native void setPhysicsLocation(long var1, Vector3f var3);

    public void setPhysicsRotation(Matrix3f matrix3f) {
        this.setPhysicsRotation(this.objectId, matrix3f);
    }

    private native void setPhysicsRotation(long var1, Matrix3f var3);

    public void setPhysicsRotation(Quaternion quaternion) {
        this.setPhysicsRotation(this.objectId, quaternion);
    }

    private native void setPhysicsRotation(long var1, Quaternion var3);

    public Vector3f getPhysicsLocation(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.getPhysicsLocation(this.objectId, vector3f);
        return vector3f;
    }

    private native void getPhysicsLocation(long var1, Vector3f var3);

    public Quaternion getPhysicsRotation(Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = new Quaternion();
        }
        this.getPhysicsRotation(this.objectId, quaternion);
        return quaternion;
    }

    private native void getPhysicsRotation(long var1, Quaternion var3);

    public Matrix3f getPhysicsRotationMatrix(Matrix3f matrix3f) {
        if (matrix3f == null) {
            matrix3f = new Matrix3f();
        }
        this.getPhysicsRotationMatrix(this.objectId, matrix3f);
        return matrix3f;
    }

    private native void getPhysicsRotationMatrix(long var1, Matrix3f var3);

    public Vector3f getPhysicsLocation() {
        Vector3f vector3f = new Vector3f();
        this.getPhysicsLocation(this.objectId, vector3f);
        return vector3f;
    }

    public Quaternion getPhysicsRotation() {
        Quaternion quaternion = new Quaternion();
        this.getPhysicsRotation(this.objectId, quaternion);
        return quaternion;
    }

    public Matrix3f getPhysicsRotationMatrix() {
        Matrix3f matrix3f = new Matrix3f();
        this.getPhysicsRotationMatrix(this.objectId, matrix3f);
        return matrix3f;
    }

    public void setKinematic(boolean bl) {
        this.kinematic = bl;
        this.setKinematic(this.objectId, bl);
    }

    private native void setKinematic(long var1, boolean var3);

    public boolean isKinematic() {
        return this.kinematic;
    }

    public void setCcdSweptSphereRadius(float f) {
        this.setCcdSweptSphereRadius(this.objectId, f);
    }

    private native void setCcdSweptSphereRadius(long var1, float var3);

    public void setCcdMotionThreshold(float f) {
        this.setCcdMotionThreshold(this.objectId, f);
    }

    private native void setCcdMotionThreshold(long var1, float var3);

    public float getCcdSweptSphereRadius() {
        return this.getCcdSweptSphereRadius(this.objectId);
    }

    private native float getCcdSweptSphereRadius(long var1);

    public float getCcdMotionThreshold() {
        return this.getCcdMotionThreshold(this.objectId);
    }

    private native float getCcdMotionThreshold(long var1);

    public float getCcdSquareMotionThreshold() {
        return this.getCcdSquareMotionThreshold(this.objectId);
    }

    private native float getCcdSquareMotionThreshold(long var1);

    public float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
        if (this.collisionShape instanceof MeshCollisionShape && f != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId != 0L) {
            if (this.collisionShape != null) {
                this.updateMassProps(this.objectId, this.collisionShape.getObjectId(), f);
            }
            if (f == 0.0f) {
                this.setStatic(this.objectId, true);
            } else {
                this.setStatic(this.objectId, false);
            }
        }
    }

    private native void setStatic(long var1, boolean var3);

    private native long updateMassProps(long var1, long var3, float var5);

    public Vector3f getGravity() {
        return this.getGravity(null);
    }

    public Vector3f getGravity(Vector3f vector3f) {
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        this.getGravity(this.objectId, vector3f);
        return vector3f;
    }

    private native void getGravity(long var1, Vector3f var3);

    public void setGravity(Vector3f vector3f) {
        this.setGravity(this.objectId, vector3f);
    }

    private native void setGravity(long var1, Vector3f var3);

    public float getFriction() {
        return this.getFriction(this.objectId);
    }

    private native float getFriction(long var1);

    public void setFriction(float f) {
        this.setFriction(this.objectId, f);
    }

    private native void setFriction(long var1, float var3);

    public void setDamping(float f, float f2) {
        this.setDamping(this.objectId, f, f2);
    }

    private native void setDamping(long var1, float var3, float var4);

    private native void setAngularDamping(long var1, float var3);

    public float getLinearDamping() {
        return this.getLinearDamping(this.objectId);
    }

    private native float getLinearDamping(long var1);

    public float getAngularDamping() {
        return this.getAngularDamping(this.objectId);
    }

    private native float getAngularDamping(long var1);

    public float getRestitution() {
        return this.getRestitution(this.objectId);
    }

    private native float getRestitution(long var1);

    public void setRestitution(float f) {
        this.setRestitution(this.objectId, f);
    }

    private native void setRestitution(long var1, float var3);

    public Vector3f getAngularVelocity() {
        Vector3f vector3f = new Vector3f();
        this.getAngularVelocity(this.objectId, vector3f);
        return vector3f;
    }

    private native void getAngularVelocity(long var1, Vector3f var3);

    public void getAngularVelocity(Vector3f vector3f) {
        this.getAngularVelocity(this.objectId, vector3f);
    }

    public void setAngularVelocity(Vector3f vector3f) {
        this.setAngularVelocity(this.objectId, vector3f);
        this.activate();
    }

    private native void setAngularVelocity(long var1, Vector3f var3);

    public Vector3f getLinearVelocity() {
        Vector3f vector3f = new Vector3f();
        this.getLinearVelocity(this.objectId, vector3f);
        return vector3f;
    }

    private native void getLinearVelocity(long var1, Vector3f var3);

    public void getLinearVelocity(Vector3f vector3f) {
        this.getLinearVelocity(this.objectId, vector3f);
    }

    public void setLinearVelocity(Vector3f vector3f) {
        this.setLinearVelocity(this.objectId, vector3f);
        this.activate();
    }

    private native void setLinearVelocity(long var1, Vector3f var3);

    public void applyForce(Vector3f vector3f, Vector3f vector3f2) {
        this.applyForce(this.objectId, vector3f, vector3f2);
        this.activate();
    }

    private native void applyForce(long var1, Vector3f var3, Vector3f var4);

    public void applyCentralForce(Vector3f vector3f) {
        this.applyCentralForce(this.objectId, vector3f);
        this.activate();
    }

    private native void applyCentralForce(long var1, Vector3f var3);

    public void applyTorque(Vector3f vector3f) {
        this.applyTorque(this.objectId, vector3f);
        this.activate();
    }

    private native void applyTorque(long var1, Vector3f var3);

    public void applyImpulse(Vector3f vector3f, Vector3f vector3f2) {
        this.applyImpulse(this.objectId, vector3f, vector3f2);
        this.activate();
    }

    private native void applyImpulse(long var1, Vector3f var3, Vector3f var4);

    public void applyTorqueImpulse(Vector3f vector3f) {
        this.applyTorqueImpulse(this.objectId, vector3f);
        this.activate();
    }

    private native void applyTorqueImpulse(long var1, Vector3f var3);

    public void clearForces() {
        this.clearForces(this.objectId);
    }

    private native void clearForces(long var1);

    @Override
    public void setCollisionShape(CollisionShape collisionShape) {
        super.setCollisionShape(collisionShape);
        if (collisionShape instanceof MeshCollisionShape && this.mass != 0.0f) {
            throw new IllegalStateException("Dynamic rigidbody can not have mesh collision shape!");
        }
        if (this.objectId == 0L) {
            this.rebuildRigidBody();
        } else {
            this.setCollisionShape(this.objectId, collisionShape.getObjectId());
            this.updateMassProps(this.objectId, collisionShape.getObjectId(), this.mass);
        }
    }

    private native void setCollisionShape(long var1, long var3);

    public void activate() {
        this.activate(this.objectId);
    }

    private native void activate(long var1);

    public boolean isActive() {
        return this.isActive(this.objectId);
    }

    private native boolean isActive(long var1);

    public void setSleepingThresholds(float f, float f2) {
        this.setSleepingThresholds(this.objectId, f, f2);
    }

    private native void setSleepingThresholds(long var1, float var3, float var4);

    public void setLinearSleepingThreshold(float f) {
        this.setLinearSleepingThreshold(this.objectId, f);
    }

    private native void setLinearSleepingThreshold(long var1, float var3);

    public void setAngularSleepingThreshold(float f) {
        this.setAngularSleepingThreshold(this.objectId, f);
    }

    private native void setAngularSleepingThreshold(long var1, float var3);

    public float getLinearSleepingThreshold() {
        return this.getLinearSleepingThreshold(this.objectId);
    }

    private native float getLinearSleepingThreshold(long var1);

    public float getAngularSleepingThreshold() {
        return this.getAngularSleepingThreshold(this.objectId);
    }

    private native float getAngularSleepingThreshold(long var1);

    public float getAngularFactor() {
        return this.getAngularFactor(this.objectId);
    }

    private native float getAngularFactor(long var1);

    public void setAngularFactor(float f) {
        this.setAngularFactor(this.objectId, f);
    }

    private native void setAngularFactor(long var1, float var3);

    public void addJoint(PhysicsJoint physicsJoint) {
        if (!this.joints.contains(physicsJoint)) {
            this.joints.add(physicsJoint);
        }
        this.updateDebugShape();
    }

    public void removeJoint(PhysicsJoint physicsJoint) {
        this.joints.remove(physicsJoint);
    }

    public List<PhysicsJoint> getJoints() {
        return this.joints;
    }

    @Override
    protected Spatial getDebugShape() {
        Spatial spatial = super.getDebugShape();
        Node node = null;
        if (spatial instanceof Node) {
            node = (Node)spatial;
        } else {
            node = new Node("DebugShapeNode");
            node.attachChild(spatial);
        }
        int n = 0;
        for (PhysicsJoint physicsJoint : this.joints) {
            Vector3f vector3f = null;
            vector3f = physicsJoint.getBodyA() == this ? physicsJoint.getPivotA() : physicsJoint.getPivotB();
            Arrow arrow = new Arrow(vector3f);
            Geometry geometry = new Geometry("DebugBone" + n, (Mesh)arrow);
            geometry.setMaterial(this.debugMaterialGreen);
            node.attachChild((Spatial)geometry);
            ++n;
        }
        return node;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write(this.getMass(), "mass", 1.0f);
        outputCapsule.write((Savable)this.getGravity(), "gravity", (Savable)Vector3f.ZERO);
        outputCapsule.write(this.getFriction(), "friction", 0.5f);
        outputCapsule.write(this.getRestitution(), "restitution", 0.0f);
        outputCapsule.write(this.getAngularFactor(), "angularFactor", 1.0f);
        outputCapsule.write(this.kinematic, "kinematic", false);
        outputCapsule.write(this.getLinearDamping(), "linearDamping", 0.0f);
        outputCapsule.write(this.getAngularDamping(), "angularDamping", 0.0f);
        outputCapsule.write(this.getLinearSleepingThreshold(), "linearSleepingThreshold", 0.8f);
        outputCapsule.write(this.getAngularSleepingThreshold(), "angularSleepingThreshold", 1.0f);
        outputCapsule.write(this.getCcdMotionThreshold(), "ccdMotionThreshold", 0.0f);
        outputCapsule.write(this.getCcdSweptSphereRadius(), "ccdSweptSphereRadius", 0.0f);
        outputCapsule.write((Savable)this.getPhysicsLocation(new Vector3f()), "physicsLocation", (Savable)new Vector3f());
        outputCapsule.write((Savable)this.getPhysicsRotationMatrix(new Matrix3f()), "physicsRotation", (Savable)new Matrix3f());
        outputCapsule.writeSavableArrayList(this.joints, "joints", null);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        float f;
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.mass = f = inputCapsule.readFloat("mass", 1.0f);
        this.rebuildRigidBody();
        this.setGravity((Vector3f)inputCapsule.readSavable("gravity", (Savable)Vector3f.ZERO.clone()));
        this.setFriction(inputCapsule.readFloat("friction", 0.5f));
        this.setKinematic(inputCapsule.readBoolean("kinematic", false));
        this.setRestitution(inputCapsule.readFloat("restitution", 0.0f));
        this.setAngularFactor(inputCapsule.readFloat("angularFactor", 1.0f));
        this.setDamping(inputCapsule.readFloat("linearDamping", 0.0f), inputCapsule.readFloat("angularDamping", 0.0f));
        this.setSleepingThresholds(inputCapsule.readFloat("linearSleepingThreshold", 0.8f), inputCapsule.readFloat("angularSleepingThreshold", 1.0f));
        this.setCcdMotionThreshold(inputCapsule.readFloat("ccdMotionThreshold", 0.0f));
        this.setCcdSweptSphereRadius(inputCapsule.readFloat("ccdSweptSphereRadius", 0.0f));
        this.setPhysicsLocation((Vector3f)inputCapsule.readSavable("physicsLocation", (Savable)new Vector3f()));
        this.setPhysicsRotation((Matrix3f)inputCapsule.readSavable("physicsRotation", (Savable)new Matrix3f()));
        this.joints = inputCapsule.readSavableArrayList("joints", null);
    }
}

