/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class AlternativeViewpointCapability
extends CapabilityBase {
    private StateChangedObservable viewPointChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToViewPointChange(AlternativeViewpointCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromViewPointChange(AlternativeViewpointCapability.this.toNative(), hCallback);
        }
    };

    public AlternativeViewpointCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    boolean isViewpointSupported(ProductionNode other) {
        return NativeMethods.xnIsViewPointSupported(this.toNative(), other.toNative());
    }

    public void setViewpoint(ProductionNode other) throws StatusException {
        int status = NativeMethods.xnSetViewPoint(this.toNative(), other.toNative());
        WrapperUtils.throwOnError(status);
    }

    void resetViewpoint() throws StatusException {
        int status = NativeMethods.xnResetViewPoint(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    boolean isViewpointAs(ProductionNode other) {
        return NativeMethods.xnIsViewPointAs(this.toNative(), other.toNative());
    }

    public IStateChangedObservable getViewPointChangedEvent() {
        return this.viewPointChanged;
    }
}

