/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.BoundingBox3D;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.GesturePositionEventArgs;
import org.OpenNI.GestureProgressEventArgs;
import org.OpenNI.GestureRecognizedEventArgs;
import org.OpenNI.IObservable;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class GestureGenerator
extends Generator {
    private Observable<GestureRecognizedEventArgs> gestureRecognizedEvent = new Observable<GestureRecognizedEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, "callback", null, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), hCallback);
        }

        public void callback(String gesture, Point3D idPosition, Point3D endPosition) {
            this.notify(new GestureRecognizedEventArgs(gesture, idPosition, endPosition));
        }
    };
    private Observable<GestureProgressEventArgs> gestureProgressEvent = new Observable<GestureProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, null, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), hCallback);
        }

        public void callback(String gesture, Point3D position, float progress) {
            this.notify(new GestureProgressEventArgs(gesture, position, progress));
        }
    };
    private Observable<GesturePositionEventArgs> gestureIntermediateStageCompletedEvent = new Observable<GesturePositionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), hCallback);
        }

        public void callback(String gesture, Point3D position) {
            this.notify(new GesturePositionEventArgs(gesture, position));
        }
    };
    private Observable<GesturePositionEventArgs> gestureReadyForNextIntermediateStageEvent = new Observable<GesturePositionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), hCallback);
        }

        public void callback(String gesture, Point3D position) {
            this.notify(new GesturePositionEventArgs(gesture, position));
        }
    };
    private StateChangedObservable gestureChangedEvent = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToGestureChange(GestureGenerator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromGestureChange(GestureGenerator.this.toNative(), hCallback);
        }
    };

    GestureGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static GestureGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateGestureGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        GestureGenerator result = (GestureGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.GESTURE);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static GestureGenerator create(Context context, Query query) throws GeneralException {
        return GestureGenerator.create(context, query, null);
    }

    public static GestureGenerator create(Context context) throws GeneralException {
        return GestureGenerator.create(context, null, null);
    }

    public void addGesture(String gesture) throws StatusException {
        int status = NativeMethods.xnAddGesture(this.toNative(), gesture);
        WrapperUtils.throwOnError(status);
    }

    public void addGesture(String gesture, BoundingBox3D area) throws StatusException {
        if (area == null) {
            this.addGesture(gesture);
            return;
        }
        int status = NativeMethods.xnAddGesture(this.toNative(), gesture, area.getMins().getX(), area.getMins().getY(), area.getMins().getZ(), area.getMaxs().getX(), area.getMaxs().getY(), area.getMaxs().getZ());
        WrapperUtils.throwOnError(status);
    }

    public void removeGesture(String gesture) throws StatusException {
        int status = NativeMethods.xnRemoveGesture(this.toNative(), gesture);
        WrapperUtils.throwOnError(status);
    }

    public boolean isGestureAvailable(String gesture) {
        return NativeMethods.xnIsGestureAvailable(this.toNative(), gesture);
    }

    public boolean isGestureProgressSupported(String gesture) {
        return NativeMethods.xnIsGestureProgressSupported(this.toNative(), gesture);
    }

    public String[] enumerateAllGestures() throws StatusException {
        OutArg<String[]> gestures = new OutArg<String[]>();
        int status = NativeMethods.xnEnumerateAllGestures(this.toNative(), gestures);
        WrapperUtils.throwOnError(status);
        return (String[])gestures.value;
    }

    public String[] getAllActiveGestures() throws StatusException {
        OutArg<String[]> gestures = new OutArg<String[]>();
        int status = NativeMethods.xnGetAllActiveGestures(this.toNative(), gestures);
        WrapperUtils.throwOnError(status);
        return (String[])gestures.value;
    }

    public IObservable<GestureRecognizedEventArgs> getGestureRecognizedEvent() {
        return this.gestureRecognizedEvent;
    }

    public IObservable<GestureProgressEventArgs> getGestureProgressEvent() {
        return this.gestureProgressEvent;
    }

    public IObservable<GesturePositionEventArgs> getGestureIntermediateStageCompletedEvent() {
        return this.gestureIntermediateStageCompletedEvent;
    }

    public IObservable<GesturePositionEventArgs> getGestureReadyForNextIntermediateStageEvent() {
        return this.gestureReadyForNextIntermediateStageEvent;
    }

    public IStateChangedObservable getGestureChangedEvent() {
        return this.gestureChangedEvent;
    }
}

