/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class MirrorCapability
extends CapabilityBase {
    private StateChangedObservable mirrorChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToMirrorChange(MirrorCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromMirrorChange(MirrorCapability.this.toNative(), hCallback);
        }
    };

    public MirrorCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public boolean isMirrored() {
        return NativeMethods.xnIsMirrored(this.toNative());
    }

    public void setMirror(boolean isMirrored) throws StatusException {
        int status = NativeMethods.xnSetMirror(this.toNative(), isMirrored);
        WrapperUtils.throwOnError(status);
    }

    public IStateChangedObservable getMirrorChangedEvent() {
        return this.mirrorChanged;
    }
}

