/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfoList;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.PlayerSeekOrigin;
import org.OpenNI.ProductionNode;
import org.OpenNI.RecordMedium;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Player
extends ProductionNode {
    private StateChangedObservable eofReached = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToEndOfFileReached(Player.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromEndOfFileReached(Player.this.toNative(), hCallback);
        }
    };

    Player(Context context, long nodeHandle, boolean addRef) throws StatusException {
        super(context, nodeHandle, addRef);
    }

    public static Player create(Context context, String formatName) throws GeneralException {
        OutArg<Long> phPlayer = new OutArg<Long>();
        int status = NativeMethods.xnCreatePlayer(context.toNative(), formatName, phPlayer);
        WrapperUtils.throwOnError(status);
        Player player = (Player)context.createProductionNodeObject((Long)phPlayer.value, NodeType.PLAYER);
        NativeMethods.xnProductionNodeRelease((Long)phPlayer.value);
        return player;
    }

    public String getFormat() {
        return NativeMethods.xnGetPlayerSupportedFormat(this.toNative());
    }

    public void setSource(RecordMedium medium, String name) throws StatusException {
        int status = NativeMethods.xnSetPlayerSource(this.toNative(), medium.toNative(), name);
        WrapperUtils.throwOnError(status);
    }

    public RecordMedium getSourceMedium() throws StatusException {
        OutArg<Integer> pMedium = new OutArg<Integer>();
        OutArg<String> pDest = new OutArg<String>();
        int status = NativeMethods.xnGetPlayerSource(this.toNative(), pMedium, pDest);
        WrapperUtils.throwOnError(status);
        return RecordMedium.fromNative((Integer)pMedium.value);
    }

    public String getSource() throws StatusException {
        OutArg<Integer> pMedium = new OutArg<Integer>();
        OutArg<String> pDest = new OutArg<String>();
        int status = NativeMethods.xnGetPlayerSource(this.toNative(), pMedium, pDest);
        WrapperUtils.throwOnError(status);
        return (String)pDest.value;
    }

    public void setRepeat(boolean repeat) throws StatusException {
        int status = NativeMethods.xnSetPlayerRepeat(this.toNative(), repeat);
        WrapperUtils.throwOnError(status);
    }

    public void readNext() throws StatusException {
        int status = NativeMethods.xnPlayerReadNext(this.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void seekToTimestamp(PlayerSeekOrigin origin, long offset) throws StatusException {
        int status = NativeMethods.xnSeekPlayerToTimeStamp(this.toNative(), offset, origin.toNative());
        WrapperUtils.throwOnError(status);
    }

    public void seekToFrame(ProductionNode node, PlayerSeekOrigin origin, int offset) throws StatusException {
        int status = NativeMethods.xnSeekPlayerToFrame(this.toNative(), node.getName(), offset, origin.toNative());
        WrapperUtils.throwOnError(status);
    }

    public long tellTimestamp() throws StatusException {
        OutArg<Long> pnTimestamp = new OutArg<Long>();
        int status = NativeMethods.xnTellPlayerTimestamp(this.toNative(), pnTimestamp);
        WrapperUtils.throwOnError(status);
        return (Long)pnTimestamp.value;
    }

    public int tellFrame(ProductionNode node) throws StatusException {
        OutArg<Integer> pnFrameID = new OutArg<Integer>();
        int status = NativeMethods.xnTellPlayerFrame(this.toNative(), node.getName(), pnFrameID);
        WrapperUtils.throwOnError(status);
        return (Integer)pnFrameID.value;
    }

    public int getNumberOfFrames(ProductionNode node) throws StatusException {
        OutArg<Integer> pnFrames = new OutArg<Integer>();
        int status = NativeMethods.xnGetPlayerNumFrames(this.toNative(), node.getName(), pnFrames);
        WrapperUtils.throwOnError(status);
        return (Integer)pnFrames.value;
    }

    public NodeInfoList enumerateNodes() throws StatusException {
        OutArg<Long> ppList = new OutArg<Long>();
        int status = NativeMethods.xnEnumeratePlayerNodes(this.toNative(), ppList);
        WrapperUtils.throwOnError(status);
        return new NodeInfoList((Long)ppList.value);
    }

    public boolean isEOF() {
        return NativeMethods.xnIsPlayerAtEOF(this.toNative());
    }

    public IStateChangedObservable getEOFReachedEvent() {
        return this.eofReached;
    }

    public double getPlaybackSpeed() {
        return NativeMethods.xnGetPlaybackSpeed(this.toNative());
    }

    public void setPlaybackSpeed(double speed) throws StatusException {
        int status = NativeMethods.xnSetPlaybackSpeed(this.toNative(), speed);
        WrapperUtils.throwOnError(status);
    }
}

