/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class ScriptNode
extends ProductionNode {
    ScriptNode(Context context, long nodeHandle, boolean addRef) throws StatusException {
        super(context, nodeHandle, addRef);
    }

    public static ScriptNode create(Context context, String formatName) throws GeneralException {
        OutArg<Long> phScriptNode = new OutArg<Long>();
        int status = NativeMethods.xnCreateScriptNode(context.toNative(), formatName, phScriptNode);
        WrapperUtils.throwOnError(status);
        ScriptNode ScriptNode2 = (ScriptNode)context.createProductionNodeObject((Long)phScriptNode.value, NodeType.SCRIPT_NODE);
        NativeMethods.xnProductionNodeRelease((Long)phScriptNode.value);
        return ScriptNode2;
    }

    public String getSupportedFormat() {
        return NativeMethods.xnScriptNodeGetSupportedFormat(this.toNative());
    }

    public void loadScriptFromFile(String fileName) throws StatusException {
        int status = NativeMethods.xnLoadScriptFromFile(this.toNative(), fileName);
        WrapperUtils.throwOnError(status);
    }

    public void loadScriptFromString(String script) throws StatusException {
        int status = NativeMethods.xnLoadScriptFromString(this.toNative(), script);
        WrapperUtils.throwOnError(status);
    }

    public void Run(EnumerationErrors errors) throws StatusException {
        int status = NativeMethods.xnScriptNodeRun(this.toNative(), errors.toNative());
        WrapperUtils.throwOnError(status);
    }
}

