/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.IObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.PoseDetectionCapability;
import org.OpenNI.Query;
import org.OpenNI.SceneMetaData;
import org.OpenNI.SkeletonCapability;
import org.OpenNI.StatusException;
import org.OpenNI.UserEventArgs;
import org.OpenNI.WrapperUtils;

public class UserGenerator
extends Generator {
    private Observable<UserEventArgs> newUserEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, "callback", null, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), hCallback);
        }

        public void callback(int user) {
            this.notify(new UserEventArgs(user));
        }
    };
    private Observable<UserEventArgs> lostUserEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, null, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), hCallback);
        }

        public void callback(int user) {
            this.notify(new UserEventArgs(user));
        }
    };
    private Observable<UserEventArgs> userExitEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToUserExit(UserGenerator.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), hCallback);
        }

        public void callback(int user) {
            this.notify(new UserEventArgs(user));
        }
    };
    private Observable<UserEventArgs> userReenterEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> phCallback) throws StatusException {
            return NativeMethods.xnRegisterToUserReEnter(UserGenerator.this.toNative(), this, "callback", phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), hCallback);
        }

        public void callback(int user) {
            this.notify(new UserEventArgs(user));
        }
    };

    UserGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static UserGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateUserGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        UserGenerator result = (UserGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.USER);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static UserGenerator create(Context context, Query query) throws GeneralException {
        return UserGenerator.create(context, query, null);
    }

    public static UserGenerator create(Context context) throws GeneralException {
        return UserGenerator.create(context, null, null);
    }

    public int getNumberOfUsers() {
        return NativeMethods.xnGetNumberOfUsers(this.toNative());
    }

    public int[] getUsers() throws StatusException {
        OutArg<Integer[]> users = new OutArg<Integer[]>();
        int status = NativeMethods.xnGetUsers(this.toNative(), users);
        WrapperUtils.throwOnError(status);
        int[] outUsers = new int[((Integer[])users.value).length];
        for (int i = 0; i < ((Integer[])users.value).length; ++i) {
            outUsers[i] = ((Integer[])users.value)[i];
        }
        return outUsers;
    }

    public Point3D getUserCoM(int id) throws StatusException {
        OutArg<Point3D> com = new OutArg<Point3D>();
        int status = NativeMethods.xnGetUserCoM(this.toNative(), id, com);
        WrapperUtils.throwOnError(status);
        return (Point3D)com.value;
    }

    public void getUserPixels(int user, SceneMetaData smd) {
        NativeMethods.xnGetUserPixels(this.toNative(), user, smd);
    }

    public SceneMetaData getUserPixels(int user) {
        SceneMetaData smd = new SceneMetaData();
        this.getUserPixels(user, smd);
        return smd;
    }

    public PoseDetectionCapability getPoseDetectionCapability() throws StatusException {
        return new PoseDetectionCapability(this);
    }

    public SkeletonCapability getSkeletonCapability() throws StatusException {
        return new SkeletonCapability(this);
    }

    public IObservable<UserEventArgs> getNewUserEvent() {
        return this.newUserEvent;
    }

    public IObservable<UserEventArgs> getLostUserEvent() {
        return this.lostUserEvent;
    }

    public IObservable<UserEventArgs> getUserExitEvent() {
        return this.userExitEvent;
    }

    public IObservable<UserEventArgs> getUserReenterEvent() {
        return this.userReenterEvent;
    }
}

