/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.BoundingBox3D;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class UserPositionCapability
extends CapabilityBase {
    private StateChangedObservable userPositionChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToUserPositionChange(UserPositionCapability.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromUserPositionChange(UserPositionCapability.this.toNative(), hCallback);
        }
    };

    public UserPositionCapability(ProductionNode node) throws StatusException {
        super(node);
    }

    public int getSupportedCount() {
        return NativeMethods.xnGetSupportedUserPositionsCount(this.toNative());
    }

    public void setUserPosition(int index, BoundingBox3D position) throws StatusException {
        Point3D leftBottomNear = position.getLeftBottomNear();
        Point3D rightTopFar = position.getRightTopFar();
        int status = NativeMethods.xnSetUserPosition(this.toNative(), index, leftBottomNear.getX(), leftBottomNear.getY(), leftBottomNear.getZ(), rightTopFar.getX(), rightTopFar.getY(), rightTopFar.getZ());
        WrapperUtils.throwOnError(status);
    }

    public BoundingBox3D getUserPosition(int index) throws StatusException {
        OutArg<BoundingBox3D> position = new OutArg<BoundingBox3D>();
        int status = NativeMethods.xnGetUserPosition(this.toNative(), index, position);
        WrapperUtils.throwOnError(status);
        return (BoundingBox3D)position.value;
    }

    public IStateChangedObservable getUserPositionChangedEvent() {
        return this.userPositionChanged;
    }
}

