package mygame;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue.Bucket;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Line;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.OpenNI.*;
import org.OpenNI.IObserver;
import org.OpenNI.PoseDetectionEventArgs;
import projectkyoto.jme3.mmd.CartoonEdgeProcessor;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.jme3.mmd.UpdateControl;
import projectkyoto.jme3.mmd.nativebullet.PhysicsControl;

/**
 * test
 * @author normenhansen
 */
public class Main extends SimpleApplication {

    private Context context;
    private OutArg<ScriptNode> scriptNode;
    private ImageGenerator imageGen;
    UserGenerator userGen;
    DepthGenerator depthGen;
    SkeletonCapability skeleton;
    PoseDetectionCapability pose;
    private final String SAMPLE_XML_FILE = "SamplesConfig.xml";
    int width, height;
    Image image;
    ByteBuffer bb;
    ByteBuffer bb2;
    ShortBuffer userShortBuffer;
    Texture2D tex;
    Picture pic;
    Geometry geom[] = new Geometry[16];
    Material mat;

    public static void main(String[] args) {
        Main app = new Main();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        initKinect();
        Box b = new Box(Vector3f.ZERO, 1, 1, 1);
        Geometry geom = new Geometry("Box", b);

        mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Blue);
        geom.setMaterial(mat);

//        rootNode.attachChild(geom);
        initSkeletonGeoms();

        bb = ByteBuffer.allocateDirect(width * height * 3);
        bb2 = ByteBuffer.allocateDirect(width * height * 2);
        bb2.order(ByteOrder.LITTLE_ENDIAN);
        userShortBuffer = bb2.asShortBuffer();
        image = new Image(Image.Format.RGB8, width, height, bb);
        tex = new Texture2D(image);
        pic = new Picture("kinectImage", true);
        pic.setTexture(assetManager, tex, false);
        pic.setWidth(width);
        pic.setHeight(height);
        pic.setPosition(100, 100);
//        pic.getMaterial().getAdditionalRenderState().setDepthTest(true);
//        pic.getMaterial().getAdditionalRenderState().setDepthWrite(true);
        pic.getLocalTranslation().z = 10;

        rootNode.attachChild(pic);

        initModel();
        flyCam.setMoveSpeed(5f);
    }
    PMDNode pmdNode;

    void initModel() {
        pmdNode = (PMDNode) assetManager.loadModel("/Model/Lat式ミクVer2.3_Normal.pmd");
        rootNode.attachChild(pmdNode);
        pmdNode.scale(0.5f);
        CartoonEdgeProcessor cartoonEdgeProcess = new CartoonEdgeProcessor();
        viewPort.addProcessor(cartoonEdgeProcess);
        PointLight pl = new PointLight();
        pl.setColor(ColorRGBA.White.mult(0.5f));
        pl.setRadius(4f);

        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1, 0, -5).normalizeLocal());
        dl.setColor(ColorRGBA.White.mult(0.5f));
        rootNode.addLight(dl);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.2f));
        pmdNode.addLight(al);
    }

    void initKinect() {
        try {
            scriptNode = new OutArg<ScriptNode>();
            context = Context.createFromXmlFile(SAMPLE_XML_FILE, scriptNode);

            imageGen = ImageGenerator.create(context);
            MapOutputMode mom = imageGen.getMapOutputMode();
            width = mom.getXRes();
            height = mom.getYRes();
            imageGen.getNewDataAvailableEvent().addObserver(new IObserver<EventArgs>() {

                @Override
                public void update(IObservable<EventArgs> io, EventArgs args) {
//                    System.out.println("getNewDataAvailableEvent");
                }
            });

            userGen = UserGenerator.create(context);
            userGen.getNewUserEvent().addObserver(new IObserver<UserEventArgs>() {

                @Override
                public void update(IObservable<UserEventArgs> observable, UserEventArgs args) {
                    try {
                        System.out.println("NewUserEvent " + args.getId());
//                        pose.StartPoseDetection(skeleton.getSkeletonCalibrationPose(), args.getId());
                        skeleton.loadSkeletonCalibrationDatadFromFile(args.getId(), "c:\\tmp\\calibration.dat");
                        skeleton.startTracking(args.getId());
                        if (pmdNode.getControl(KinectControl4.class) == null) {
                            pmdNode.addControl(new KinectControl4(skeleton, args.getId()));
                            UpdateControl updateControl = new UpdateControl(pmdNode);
                            pmdNode.addControl(updateControl);
                        }
                    } catch (StatusException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            userGen.getLostUserEvent().addObserver(new IObserver<UserEventArgs>() {

                @Override
                public void update(IObservable<UserEventArgs> observable, UserEventArgs args) {
                    System.out.println("LostUserEvent " + args.getId());
                }
            });
            userGen.getUserExitEvent().addObserver(new IObserver<UserEventArgs>() {

                @Override
                public void update(IObservable<UserEventArgs> observable, UserEventArgs args) {
                    System.out.println("UserExitEvent " + args.getId());
                }
            });
            userGen.getUserReenterEvent().addObserver(new IObserver<UserEventArgs>() {

                @Override
                public void update(IObservable<UserEventArgs> observable, UserEventArgs args) {
                    System.out.println("UserReenterEvent " + args.getId());
                }
            });
            depthGen = DepthGenerator.create(context);
            depthGen.getAlternativeViewpointCapability().setViewpoint(imageGen);

            skeleton = userGen.getSkeletonCapability();
            String calibrationPose = skeleton.getSkeletonCalibrationPose();
            skeleton.getCalibrationStartEvent().addObserver(new IObserver<CalibrationStartEventArgs>() {

                @Override
                public void update(IObservable<CalibrationStartEventArgs> observable, CalibrationStartEventArgs args) {
                    System.out.println("calibrationStartEvent " + args.getUser());
                }
            });
            skeleton.getCalibrationCompleteEvent().addObserver(new IObserver<CalibrationProgressEventArgs>() {

                @Override
                public void update(IObservable<CalibrationProgressEventArgs> observable, CalibrationProgressEventArgs args) {
                    System.out.println("calibrationEndEvent " + args.getUser());
                    if (args.getStatus() == CalibrationProgressStatus.OK) {
                        try {
//                            skeleton.saveSkeletonCalibrationDataToFile(args.getUser(), "c:\\tmp\\calibration.dat");
                            System.out.println("starting tracking " + args.getUser());
                            skeleton.startTracking(args.getUser());
                        } catch (StatusException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        try {
                            pose.StartPoseDetection(skeleton.getSkeletonCalibrationPose(), args.getUser());
                        } catch (StatusException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            skeleton.setSkeletonProfile(SkeletonProfile.ALL);

            pose = userGen.getPoseDetectionCapability();
            pose.getPoseDetectedEvent().addObserver(new IObserver<PoseDetectionEventArgs>() {

                @Override
                public void update(IObservable<PoseDetectionEventArgs> observable, PoseDetectionEventArgs args) {
                    try {
                        System.out.println("poseDetectedEvent " + args.getUser() + " " + args.getPose());
                        pose.StopPoseDetection(args.getUser());
                        skeleton.requestSkeletonCalibration(args.getUser(), true);
                    } catch (StatusException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            pose.getOutOfPoseEvent().addObserver(new IObserver<PoseDetectionEventArgs>() {

                @Override
                public void update(IObservable<PoseDetectionEventArgs> observable, PoseDetectionEventArgs args) {
                    System.out.println("outOfPoseEvent " + args.getUser() + " " + args.getPose());
                }
            });

            context.startGeneratingAll();
        } catch (GeneralException ex) {
            ex.printStackTrace();
        }
    }

    void initSkeletonGeoms() {
        for (int i = 0; i < geom.length; i++) {
            geom[i] = new Geometry();
            Line line = new Line(new Vector3f(10, 10, -10), new Vector3f(5000, 5000, -10));
            line.setLineWidth(5);
            geom[i].setMesh(line);
            geom[i].setMaterial(mat);
            geom[i].setQueueBucket(Bucket.Gui);
            guiNode.attachChild(geom[i]);
        }

    }

    @Override
    public void simpleUpdate(float tpf) {
        try {
            //TODO: add update code
            context.waitAndUpdateAll();
//            context.waitNoneUpdateAll();

        } catch (StatusException ex) {
            ex.printStackTrace();
        }
//        if (imageGen.isNewDataAvailable()) {
        updateKinectImage();
        if (userGen.getNumberOfUsers() > 0) {
            updateSkeletons();
        }
//        }
    }

    void updateKinectImage() {
        try {
            imageGen.getImageMap().copyToByteBuffer(bb);
//            bb.position(0);
//            bb2.position(0);
//            for(int i=bb2.capacity()-1;i>=0;i--) {
//                bb.put(bb2.get());
//            }
            bb.position(0);
            userGen.getUserPixels(0).getData().copyToByteBuffer(bb2);
            userShortBuffer.position(0);
            for (int i = userShortBuffer.capacity() - 1; i >= 0; i--) {
                short userId = userShortBuffer.get();
                if (userId == 0) {
                    bb.get();
                    bb.get();
                    bb.get();
                } else {
                    bb.put((byte) 0xff);
                    bb.put((byte) 0xff);
                    bb.put((byte) 0xff);
                }
            }
            image.setUpdateNeeded();
        } catch (GeneralException ex) {
            ex.printStackTrace();
        }
    }

    void updateSkeletons() {
        try {
            int i=0;
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.HEAD).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.NECK).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.NECK).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_SHOULDER).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_SHOULDER).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_ELBOW).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_ELBOW).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_HAND).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_SHOULDER).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.TORSO).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_SHOULDER).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.TORSO).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.NECK).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_SHOULDER).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_SHOULDER).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_ELBOW).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_ELBOW).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_HAND).getPosition());

            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.TORSO).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_HIP).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_HIP).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_KNEE).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_KNEE).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_FOOT).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.TORSO).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_HIP).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_HIP).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_KNEE).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_KNEE).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_FOOT).getPosition());
            updateSkeleton(geom[i++], skeleton.getSkeletonJointPosition(1, SkeletonJoint.LEFT_HIP).getPosition(),
                    skeleton.getSkeletonJointPosition(1, SkeletonJoint.RIGHT_HIP).getPosition());
        } catch (StatusException ex) {
            ex.printStackTrace();
        }
    }

    void updateSkeleton(Geometry geom, Point3D p1, Point3D p2) {
        try {
            if (p1.getZ() == 0 || p2.getZ() == 0) {
                return;
            }
            Line line = (Line) geom.getMesh();
            line.setLineWidth(3);
            Point3D real = depthGen.convertRealWorldToProjective(p1);
//            System.out.print("x = " + real.getX() + " y = " + real.getY());
            line.getStart().set(real.getX() + 100, height - real.getY() + 100, 10);
            real = depthGen.convertRealWorldToProjective(p2);
            line.getEnd().set(real.getX() + 100, height - real.getY() + 100, 10);
            line.updatePoints(line.getStart(), line.getEnd());
//            System.out.println("  x = " + real.getX() + " y = " + real.getY());
        } catch (StatusException ex) {
            ex.printStackTrace();
        }
    }
}
