/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.DepthMap;
import org.OpenNI.DepthMetaData;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.FieldOfView;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.UserPositionCapability;
import org.OpenNI.WrapperUtils;

public class DepthGenerator
extends MapGenerator {
    private StateChangedObservable fovChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String cb, OutArg<Long> phCallback) {
            return NativeMethods.xnRegisterToDepthFieldOfViewChange(DepthGenerator.this.toNative(), this, cb, phCallback);
        }

        @Override
        protected void unregisterNative(long hCallback) {
            NativeMethods.xnUnregisterFromDepthFieldOfViewChange(DepthGenerator.this.toNative(), hCallback);
        }
    };
    private DepthMap currDepthMap;
    private int currDepthMapFrameID;

    DepthGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static DepthGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateDepthGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        DepthGenerator result = (DepthGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.DEPTH);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static DepthGenerator create(Context context, Query query) throws GeneralException {
        return DepthGenerator.create(context, query, null);
    }

    public static DepthGenerator create(Context context) throws GeneralException {
        return DepthGenerator.create(context, null, null);
    }

    public DepthMap getDepthMap() throws GeneralException {
        int frameID = this.getFrameID();
        if (this.currDepthMap == null || this.currDepthMapFrameID != frameID) {
            long ptr = NativeMethods.xnGetDepthMap(this.toNative());
            MapOutputMode mode = this.getMapOutputMode();
            this.currDepthMap = new DepthMap(ptr, mode.getXRes(), mode.getYRes());
            this.currDepthMapFrameID = frameID;
        }
        return this.currDepthMap;
    }

    public int getDeviceMaxDepth() {
        return NativeMethods.xnGetDeviceMaxDepth(this.toNative());
    }

    public FieldOfView getFieldOfView() throws StatusException {
        OutArg<Double> hFOV = new OutArg<Double>();
        OutArg<Double> vFOV = new OutArg<Double>();
        int status = NativeMethods.xnGetDepthFieldOfView(this.toNative(), hFOV, vFOV);
        WrapperUtils.throwOnError(status);
        return new FieldOfView((Double)hFOV.value, (Double)vFOV.value);
    }

    public IStateChangedObservable getFieldOfViewChangedEvent() {
        return this.fovChanged;
    }

    public Point3D[] convertProjectiveToRealWorld(Point3D[] projectivePoints) throws StatusException {
        Point3D[] realWorld = new Point3D[projectivePoints.length];
        int status = NativeMethods.xnConvertProjectiveToRealWorld(this.toNative(), projectivePoints, realWorld);
        WrapperUtils.throwOnError(status);
        return realWorld;
    }

    public Point3D convertProjectiveToRealWorld(Point3D projectivePoint) throws StatusException {
        Point3D[] projectivePoints = new Point3D[]{projectivePoint};
        return this.convertProjectiveToRealWorld(projectivePoints)[0];
    }

    public Point3D[] convertRealWorldToProjective(Point3D[] realWorldPoints) throws StatusException {
        Point3D[] projective = new Point3D[realWorldPoints.length];
        int status = NativeMethods.xnConvertRealWorldToProjective(this.toNative(), realWorldPoints, projective);
        WrapperUtils.throwOnError(status);
        return projective;
    }

    public Point3D convertRealWorldToProjective(Point3D realWorldPoint) throws StatusException {
        Point3D[] realWorldPoints = new Point3D[]{realWorldPoint};
        return this.convertRealWorldToProjective(realWorldPoints)[0];
    }

    public UserPositionCapability getUserPositionCapability() throws StatusException {
        return new UserPositionCapability(this);
    }

    public void getMetaData(DepthMetaData depthMD) {
        NativeMethods.xnGetDepthMetaData(this.toNative(), depthMD);
    }

    public DepthMetaData getMetaData() {
        DepthMetaData depthMD = new DepthMetaData();
        this.getMetaData(depthMD);
        return depthMD;
    }
}

