/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.IRMap;
import org.OpenNI.IRMetaData;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Query;
import org.OpenNI.WrapperUtils;

public class IRGenerator
extends MapGenerator {
    private IRMap currIRMap;
    private int currIRMapFrameID;

    IRGenerator(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static IRGenerator create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateIRGenerator(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        IRGenerator result = (IRGenerator)context.createProductionNodeObject((Long)handle.value, NodeType.IR);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static IRGenerator create(Context context, Query query) throws GeneralException {
        return IRGenerator.create(context, query, null);
    }

    public static IRGenerator create(Context context) throws GeneralException {
        return IRGenerator.create(context, null, null);
    }

    public IRMap getIRMap() throws GeneralException {
        int frameID = this.getFrameID();
        if (this.currIRMap == null || this.currIRMapFrameID != frameID) {
            long ptr = NativeMethods.xnGetIRMap(this.toNative());
            MapOutputMode mode = this.getMapOutputMode();
            this.currIRMap = new IRMap(ptr, mode.getXRes(), mode.getYRes());
            this.currIRMapFrameID = frameID;
        }
        return this.currIRMap;
    }

    public void getMetaData(IRMetaData IRMD) {
        NativeMethods.xnGetIRMetaData(this.toNative(), IRMD);
    }

    public IRMetaData getMetaData() {
        IRMetaData IRMD = new IRMetaData();
        this.getMetaData(IRMD);
        return IRMD;
    }
}

