/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.OpenNI.NativeMethods;

public class Map {
    protected long ptr;
    protected int xRes;
    protected int yRes;
    protected int bytesPerPixel;

    Map() {
    }

    Map(long ptr, int xRes, int yRes, int bytesPerPixel) {
        this.ptr = ptr;
        this.xRes = xRes;
        this.yRes = yRes;
        this.bytesPerPixel = bytesPerPixel;
    }

    public long getNativePtr() {
        return this.ptr;
    }

    public void setNativePtr(long ptr) {
        this.ptr = ptr;
    }

    protected ByteBuffer createByteBuffer() {
        int size = this.xRes * this.yRes * this.bytesPerPixel;
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        NativeMethods.copyToBuffer(buffer, this.ptr, size);
        return buffer;
    }

    protected ByteBuffer copyToByteBuffer(ByteBuffer buffer) {
        int size = this.xRes * this.yRes * this.bytesPerPixel;
        if (size > buffer.capacity()) {
            throw new BufferOverflowException();
        }
        NativeMethods.copyToBuffer(buffer, this.ptr, size);
        return buffer;
    }

    protected long getPixelPtr(int x, int y) {
        return this.ptr + (long)((y * this.xRes + x) * this.bytesPerPixel);
    }

    public int getXRes() {
        return this.xRes;
    }

    public void setXRes(int xRes) {
        this.xRes = xRes;
    }

    public int getYRes() {
        return this.yRes;
    }

    public void setYRes(int yRes) {
        this.yRes = yRes;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    protected void setBytesPerPixel(int bytesPerPixel) {
        this.bytesPerPixel = bytesPerPixel;
    }
}

