/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Plane3D;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.SceneMap;
import org.OpenNI.SceneMetaData;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SceneAnalyzer
extends MapGenerator {
    private SceneMap currSceneMap;
    private int currSceneMapFrameID;

    SceneAnalyzer(Context context, long nodeHandle, boolean addRef) throws GeneralException {
        super(context, nodeHandle, addRef);
    }

    public static SceneAnalyzer create(Context context, Query query, EnumerationErrors errors) throws GeneralException {
        OutArg<Long> handle = new OutArg<Long>();
        int status = NativeMethods.xnCreateSceneAnalyzer(context.toNative(), handle, query == null ? 0L : query.toNative(), errors == null ? 0L : errors.toNative());
        WrapperUtils.throwOnError(status);
        SceneAnalyzer result = (SceneAnalyzer)context.createProductionNodeObject((Long)handle.value, NodeType.SCENE);
        NativeMethods.xnProductionNodeRelease((Long)handle.value);
        return result;
    }

    public static SceneAnalyzer create(Context context, Query query) throws GeneralException {
        return SceneAnalyzer.create(context, query, null);
    }

    public static SceneAnalyzer create(Context context) throws GeneralException {
        return SceneAnalyzer.create(context, null, null);
    }

    public SceneMap getSceneMap() throws GeneralException {
        int frameID = this.getFrameID();
        if (this.currSceneMap == null || this.currSceneMapFrameID != frameID) {
            long ptr = NativeMethods.xnGetLabelMap(this.toNative());
            MapOutputMode mode = this.getMapOutputMode();
            this.currSceneMap = new SceneMap(ptr, mode.getXRes(), mode.getYRes());
            this.currSceneMapFrameID = frameID;
        }
        return this.currSceneMap;
    }

    public void getMetaData(SceneMetaData sceneMD) {
        NativeMethods.xnGetSceneMetaData(this.toNative(), sceneMD);
    }

    public SceneMetaData getMetaData() {
        SceneMetaData sceneMD = new SceneMetaData();
        this.getMetaData(sceneMD);
        return sceneMD;
    }

    public Plane3D getFloor() throws StatusException {
        OutArg<Point3D> planeNormal = new OutArg<Point3D>();
        OutArg<Point3D> planePoint = new OutArg<Point3D>();
        int status = NativeMethods.xnGetFloor(this.toNative(), planeNormal, planePoint);
        WrapperUtils.throwOnError(status);
        return new Plane3D((Point3D)planeNormal.value, (Point3D)planePoint.value);
    }
}

