/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd.ik;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import projectkyoto.jme3.mmd.BoneUtil;
import projectkyoto.jme3.mmd.PMDNode;
import projectkyoto.mmd.file.PMDIKData;
import projectkyoto.mmd.file.PMDModel;

public class IKControl
extends AbstractControl {
    PMDNode pmdNode;
    int[] boneEnabled;
    private static final float kMinDistance = 1.0E-4f;
    private static final float kMinAngle = 1.0E-8f;
    private static final float kMinAxis = 1.0E-7f;
    private static final float kMinRotSum = 0.002f;
    private static final float kMinRotation = 1.0E-5f;
    float[] buf = new float[3];
    Vector3f tmpV1 = new Vector3f();
    Vector3f tmpV2 = new Vector3f();
    Vector3f tmpV3 = new Vector3f();
    Vector3f tmpV4 = new Vector3f();
    Vector3f tmpV5 = new Vector3f();
    Matrix4f tmpM41 = new Matrix4f();
    Matrix3f tmpM31 = new Matrix3f();
    Quaternion tmpQ1 = new Quaternion();

    public IKControl(PMDNode pmdNode) {
        this.pmdNode = pmdNode;
    }

    protected void controlUpdate(float tpf) {
        this.updateIKBoneRotation();
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateIKBoneRotation() {
        PMDModel pmdModel = this.pmdNode.getPmdModel();
        Skeleton skeleton = this.pmdNode.getSkeleton();
        block0: for (PMDIKData ikData : pmdModel.getIkList().getPmdIKData()) {
            if (this.boneEnabled != null && this.boneEnabled[ikData.getIkBoneIndex()] != 1) continue;
            Bone ikBone = skeleton.getBone(ikData.getIkBoneIndex());
            Bone targetBone = skeleton.getBone(ikData.getIkTargetBoneIndex());
            int iterations = ikData.getIterations();
            for (int iterationCount = 0; iterationCount < iterations; ++iterationCount) {
                int ikChainLength = ikData.getIkChainLength();
                int[] ikChildBoneIndex = ikData.getIkChildBoneIndex();
                for (int boneCount = 0; boneCount < ikChainLength; ++boneCount) {
                    float angle;
                    Bone currentBone = skeleton.getBone(ikChildBoneIndex[boneCount]);
                    Vector3f effectorModelPos = this.tmpV1.set(targetBone.getModelSpacePosition());
                    Vector3f targetModelPos = this.tmpV2.set(ikBone.getModelSpacePosition());
                    boolean hizaFlag = pmdModel.getBoneList().getBones()[ikData.getIkChildBoneIndex()[boneCount]].isHiza();
                    if (hizaFlag) {
                        if (ikData.getIkChainLength() < 2) {
                            pmdModel.getBoneList().getBones()[ikData.getIkChildBoneIndex()[boneCount]].setHiza(false);
                        } else {
                            this.hizaIK(ikData);
                            continue block0;
                        }
                    }
                    Matrix4f m = BoneUtil.getModelToBoneMatrix(currentBone, this.tmpM41, this.tmpM31);
                    Vector3f targetBonePos = this.tmpV3;
                    m.mult(targetModelPos, targetBonePos);
                    Vector3f effectorBonePos = this.tmpV4;
                    m.mult(effectorModelPos, effectorBonePos);
                    if (targetBonePos.distanceSquared(effectorBonePos) < 1.0E-4f) continue block0;
                    Quaternion rot = this.tmpQ1;
                    targetBonePos.normalizeLocal();
                    effectorBonePos.normalizeLocal();
                    float dot = targetBonePos.dot(effectorBonePos);
                    if (dot > 1.0f || !(FastMath.abs((float)(angle = FastMath.acos((float)dot))) >= 1.0E-8f)) continue;
                    if (angle < -ikData.getControlWeight()) {
                        angle = -ikData.getControlWeight();
                    } else if (angle > ikData.getControlWeight()) {
                        angle = ikData.getControlWeight();
                    }
                    Vector3f axis = effectorBonePos.cross(targetBonePos, this.tmpV5);
                    if (axis.lengthSquared() < 1.0E-7f && iterationCount > 0) continue;
                    axis.normalizeLocal();
                    rot.fromAngleNormalAxis(angle, axis);
                    if (hizaFlag) {
                        if (iterationCount == -1) {
                            if (angle < 0.0f) {
                                angle = -angle;
                                rot.fromAngleAxis(angle, axis);
                            }
                        } else {
                            rot.toAngles(this.buf);
                            float x = this.buf[0];
                            Quaternion currentRot = currentBone.getLocalRotation();
                            currentRot.toAngles(this.buf);
                            float x2 = this.buf[0];
                            if (x2 + x > (float)Math.PI) {
                                x = (float)Math.PI - x2;
                            }
                            if (0.002f > x + x2) {
                                x = 0.002f - x2;
                            }
                            if (x + x2 < 0.0f) {
                                x = -(x + x2) - x2;
                            } else if (x < -ikData.getControlWeight()) {
                                x = -ikData.getControlWeight();
                            } else if (x > ikData.getControlWeight()) {
                                x = ikData.getControlWeight();
                            }
                            if (FastMath.abs((float)x) < 1.0E-5f) continue;
                            rot.fromAngles(x, 0.0f, 0.0f);
                        }
                    }
                    currentBone.getLocalRotation().multLocal(rot);
                    this.updateWorldVectors(currentBone);
                }
            }
        }
    }

    void hizaIK(PMDIKData ikData) {
        Skeleton skeleton = this.pmdNode.getSkeleton();
        Bone ikBone = skeleton.getBone(ikData.getIkBoneIndex());
        Bone targetBone = skeleton.getBone(ikData.getIkTargetBoneIndex());
        Bone hizaBone = skeleton.getBone(ikData.getIkChildBoneIndex()[0]);
        Bone ashiBone = skeleton.getBone(ikData.getIkChildBoneIndex()[1]);
        hizaBone.getLocalRotation().fromAngles(0.0f, 0.0f, 0.0f);
        this.updateWorldVectors(hizaBone);
        Vector3f effectorModelPos = this.tmpV1.set(targetBone.getModelSpacePosition());
        Vector3f targetModelPos = this.tmpV2.set(ikBone.getModelSpacePosition());
        float aSquared = hizaBone.getModelSpacePosition().distanceSquared(ashiBone.getModelSpacePosition());
        float bSquared = hizaBone.getModelSpacePosition().distanceSquared(effectorModelPos);
        float cSquared = targetModelPos.distanceSquared(ashiBone.getModelSpacePosition());
        float a = FastMath.sqrt((float)aSquared);
        float b = FastMath.sqrt((float)bSquared);
        float c = FastMath.sqrt((float)cSquared);
        if (a + b < c) {
            hizaBone.getLocalRotation().toAngles(this.buf);
            hizaBone.getLocalRotation().fromAngles(0.0f, this.buf[1], this.buf[2]);
            this.updateWorldVectors(hizaBone);
            effectorModelPos = this.tmpV1.set(targetBone.getModelSpacePosition());
            Matrix4f m = BoneUtil.getModelToBoneMatrix(ashiBone, this.tmpM41, this.tmpM31);
            Vector3f targetBonePos = this.tmpV3;
            m.mult(targetModelPos, targetBonePos);
            Vector3f effectorBonePos = this.tmpV4;
            m.mult(effectorModelPos, effectorBonePos);
            if (targetBonePos.distanceSquared(effectorBonePos) < 1.0E-4f) {
                return;
            }
            targetBonePos.normalizeLocal();
            effectorBonePos.normalizeLocal();
            float dot = effectorBonePos.dot(targetBonePos);
            float angle = FastMath.acos((float)dot);
            Vector3f axis = effectorBonePos.cross(targetBonePos, this.tmpV5);
            axis.normalizeLocal();
            Quaternion rot = this.tmpQ1;
            rot.fromAngleAxis(angle, axis);
            ashiBone.getLocalRotation().multLocal(rot);
            this.updateWorldVectors(ashiBone);
        } else if (FastMath.abs((float)(a - b)) < c) {
            Quaternion rot = this.tmpQ1;
            float angle = (float)Math.PI - FastMath.acos((float)((cSquared - aSquared - bSquared) / (-2.0f * a * b)));
            rot.fromAngles(angle, 0.0f, 0.0f);
            hizaBone.getLocalRotation().set(rot);
            this.updateWorldVectors(hizaBone);
            effectorModelPos = this.tmpV1.set(targetBone.getModelSpacePosition());
            Matrix4f m = BoneUtil.getModelToBoneMatrix(ashiBone, this.tmpM41, this.tmpM31);
            Vector3f targetBonePos = this.tmpV3;
            m.mult(ashiBone.getModelSpacePosition(), targetBonePos);
            m.mult(targetModelPos, targetBonePos);
            Vector3f effectorBonePos = this.tmpV4;
            m.mult(effectorModelPos, effectorBonePos);
            if (targetBonePos.distanceSquared(effectorBonePos) < 1.0E-4f) {
                return;
            }
            targetBonePos.normalizeLocal();
            effectorBonePos.normalizeLocal();
            float dot = effectorBonePos.dot(targetBonePos);
            float angle2 = FastMath.acos((float)dot);
            Vector3f axis = effectorBonePos.cross(targetBonePos, this.tmpV5);
            axis.normalizeLocal();
            Quaternion rot2 = this.tmpQ1;
            rot2.fromAngleNormalAxis(angle2, axis);
            ashiBone.getLocalRotation().multLocal(rot2);
            this.updateWorldVectors(ashiBone);
        } else {
            Quaternion rot = this.tmpQ1;
            float angle = 0.0f;
            rot.fromAngles(angle, 0.0f, 0.0f);
            hizaBone.getLocalRotation().set(rot);
            this.updateWorldVectors(hizaBone);
            effectorModelPos = this.tmpV1.set(targetBone.getModelSpacePosition());
            Matrix4f m = BoneUtil.getModelToBoneMatrix(ashiBone, this.tmpM41, this.tmpM31);
            Vector3f targetBonePos = this.tmpV3;
            m.mult(targetModelPos, targetBonePos);
            Vector3f effectorBonePos = this.tmpV4;
            m.mult(effectorModelPos, effectorBonePos);
            if (targetBonePos.distanceSquared(effectorBonePos) < 1.0E-4f) {
                return;
            }
            targetBonePos.normalizeLocal();
            effectorBonePos.normalizeLocal();
            float dot = effectorBonePos.dot(targetBonePos);
            float angle3 = FastMath.acos((float)dot);
            Vector3f axis = effectorBonePos.cross(targetBonePos, this.tmpV5);
            axis.normalizeLocal();
            Quaternion rot3 = this.tmpQ1;
            rot3.fromAngleAxis(angle3, axis);
            ashiBone.getLocalRotation().multLocal(rot3);
            this.updateWorldVectors(ashiBone);
        }
    }

    void updateWorldVectors(Bone bone) {
        bone.updateWorldVectors();
        ArrayList children = bone.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Bone childBone = (Bone)children.get(i);
            this.updateWorldVectors(childBone);
        }
    }

    public int[] getBoneEnabled() {
        return this.boneEnabled;
    }

    public void setBoneEnabled(int[] boneEnabled) {
        this.boneEnabled = boneEnabled;
    }
}

