/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;

public class Coords2d
implements Serializable {
    private float u;
    private float v;

    public String toString() {
        return "{u = " + this.u + " v = " + this.v + "}";
    }

    public Coords2d(float u, float v) {
        this.u = u;
        this.v = v;
    }

    public Coords2d(DataInputStreamLittleEndian is) throws IOException {
        this.u = is.readFloat();
        this.v = is.readFloat();
    }

    public Coords2d readFromStream(DataInputStreamLittleEndian is) throws IOException {
        this.u = is.readFloat();
        this.v = is.readFloat();
        return this;
    }

    public Coords2d readFromBuffer(ByteBuffer bb) {
        this.u = bb.getFloat();
        this.v = bb.getFloat();
        return this;
    }

    public Coords2d writeToBuffer(ByteBuffer bb) {
        bb.putFloat(this.u);
        bb.putFloat(this.v);
        return this;
    }

    public Coords2d() {
    }

    public float getU() {
        return this.u;
    }

    public void setU(float u) {
        this.u = u;
    }

    public float getV() {
        return this.v;
    }

    public void setV(float v) {
        this.v = v;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coords2d other = (Coords2d)obj;
        if (Float.floatToIntBits(this.u) != Float.floatToIntBits(other.u)) {
            return false;
        }
        return Float.floatToIntBits(this.v) == Float.floatToIntBits(other.v);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }
}

