/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import projectkyoto.mmd.file.Coords2d;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDUtil;

public class PMDVertex
implements Serializable {
    private Vector3f pos = new Vector3f();
    private Vector3f normal = new Vector3f();
    private Coords2d uv = new Coords2d();
    private int boneNum1;
    private int boneNum2;
    private byte boneWeight;
    private byte edgeFlag;

    public String toString() {
        return "{pos = " + this.pos + " normal = " + this.normal + " uv = " + this.uv + " boneNum1 = " + this.boneNum1 + " boneNum2 = " + this.boneNum2 + " boneWeight = " + this.boneWeight + " edgeFlag = " + this.edgeFlag + "}";
    }

    public PMDVertex readFromStream(DataInputStreamLittleEndian is) throws IOException {
        PMDUtil.readVector3f(is, this.pos);
        PMDUtil.readVector3f(is, this.normal);
        this.uv.readFromStream(is);
        this.boneNum1 = is.readUnsignedShort();
        this.boneNum2 = is.readUnsignedShort();
        this.boneWeight = is.readByte();
        this.edgeFlag = is.readByte();
        return this;
    }

    public PMDVertex readFromBuffer(ByteBuffer bb) {
        PMDUtil.readVector3f(bb, this.pos);
        PMDUtil.readVector3f(bb, this.normal);
        this.uv.readFromBuffer(bb);
        this.boneNum1 = bb.getShort();
        this.boneNum2 = bb.getShort();
        this.boneWeight = bb.get();
        this.edgeFlag = bb.get();
        return this;
    }

    public PMDVertex writeToBuffer(ByteBuffer bb) {
        PMDUtil.writeVector3f(bb, this.pos);
        PMDUtil.writeVector3f(bb, this.normal);
        this.uv.writeToBuffer(bb);
        bb.putShort((short)this.boneNum1);
        bb.putShort((short)this.boneNum2);
        bb.put(this.boneWeight);
        bb.put(this.edgeFlag);
        return this;
    }

    public int getBoneNum1() {
        return this.boneNum1;
    }

    public void setBoneNum1(int boneNum1) {
        this.boneNum1 = boneNum1;
    }

    public int getBoneNum2() {
        return this.boneNum2;
    }

    public void setBoneNum2(int boneNum2) {
        this.boneNum2 = boneNum2;
    }

    public byte getBoneWeight() {
        return this.boneWeight;
    }

    public void setBoneWeight(byte boneWeight) {
        this.boneWeight = boneWeight;
    }

    public byte getEdgeFlag() {
        return this.edgeFlag;
    }

    public void setEdgeFlag(byte edgeFlag) {
        this.edgeFlag = edgeFlag;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public Coords2d getUv() {
        return this.uv;
    }

    public void setUv(Coords2d uv) {
        this.uv = uv;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMDVertex other = (PMDVertex)obj;
        if (!(this.pos == other.pos || this.pos != null && this.pos.equals((Tuple3f)other.pos))) {
            return false;
        }
        if (!(this.normal == other.normal || this.normal != null && this.normal.equals((Tuple3f)other.normal))) {
            return false;
        }
        if (!(this.uv == other.uv || this.uv != null && this.uv.equals(other.uv))) {
            return false;
        }
        if (this.boneNum1 != other.boneNum1) {
            return false;
        }
        if (this.boneNum2 != other.boneNum2) {
            return false;
        }
        if (this.boneWeight != other.boneWeight) {
            return false;
        }
        return this.edgeFlag == other.edgeFlag;
    }

    public boolean equals2(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.pos != null ? this.pos.hashCode() : 0);
        return hash;
    }

    public static int size() {
        return 38;
    }
}

