/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompoundCollisionShape
extends CollisionShape {
    protected ArrayList<ChildCollisionShape> children = new ArrayList();

    public CompoundCollisionShape() {
        this.objectId = this.createShape();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Shape {0}", Long.toHexString(this.objectId));
    }

    public void addChildShape(CollisionShape collisionShape, Vector3f vector3f) {
        this.addChildShape(collisionShape, vector3f, new Matrix3f());
    }

    public void addChildShape(CollisionShape collisionShape, Vector3f vector3f, Matrix3f matrix3f) {
        if (collisionShape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        this.children.add(new ChildCollisionShape(vector3f.clone(), matrix3f.clone(), collisionShape));
        this.addChildShape(this.objectId, collisionShape.getObjectId(), vector3f, matrix3f);
    }

    private void addChildShapeDirect(CollisionShape collisionShape, Vector3f vector3f, Matrix3f matrix3f) {
        if (collisionShape instanceof CompoundCollisionShape) {
            throw new IllegalStateException("CompoundCollisionShapes cannot have CompoundCollisionShapes as children!");
        }
        this.addChildShape(this.objectId, collisionShape.getObjectId(), vector3f, matrix3f);
    }

    public void removeChildShape(CollisionShape collisionShape) {
        this.removeChildShape(this.objectId, collisionShape.getObjectId());
        Iterator<ChildCollisionShape> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ChildCollisionShape childCollisionShape = iterator.next();
            if (childCollisionShape.shape != collisionShape) continue;
            iterator.remove();
        }
    }

    public List<ChildCollisionShape> getChildren() {
        return this.children;
    }

    @Override
    public void setScale(Vector3f vector3f) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "CompoundCollisionShape cannot be scaled");
    }

    private native long createShape();

    private native long addChildShape(long var1, long var3, Vector3f var5, Matrix3f var6);

    private native long removeChildShape(long var1, long var3);

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.writeSavableArrayList(this.children, "children", new ArrayList());
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.children = inputCapsule.readSavableArrayList("children", new ArrayList());
        this.setScale(this.scale);
        this.setMargin(this.margin);
        this.loadChildren();
    }

    private void loadChildren() {
        for (ChildCollisionShape childCollisionShape : this.children) {
            this.addChildShapeDirect(childCollisionShape.shape, childCollisionShape.location, childCollisionShape.rotation);
        }
    }
}

