/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConeJoint
extends PhysicsJoint {
    protected Matrix3f rotA;
    protected Matrix3f rotB;
    protected float swingSpan1 = 1.0E30f;
    protected float swingSpan2 = 1.0E30f;
    protected float twistSpan = 1.0E30f;
    protected boolean angularOnly = false;

    public ConeJoint() {
    }

    public ConeJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2, Matrix3f matrix3f, Matrix3f matrix3f2) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.rotA = matrix3f;
        this.rotB = matrix3f2;
        this.createJoint();
    }

    public void setLimit(float f, float f2, float f3) {
        this.swingSpan1 = f;
        this.swingSpan2 = f2;
        this.twistSpan = f3;
        this.setLimit(this.objectId, f, f2, f3);
    }

    private native void setLimit(long var1, float var3, float var4, float var5);

    public void setAngularOnly(boolean bl) {
        this.angularOnly = bl;
        this.setAngularOnly(this.objectId, bl);
    }

    private native void setAngularOnly(long var1, boolean var3);

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.rotA, "rotA", (Savable)new Matrix3f());
        outputCapsule.write((Savable)this.rotB, "rotB", (Savable)new Matrix3f());
        outputCapsule.write(this.angularOnly, "angularOnly", false);
        outputCapsule.write(this.swingSpan1, "swingSpan1", 1.0E30f);
        outputCapsule.write(this.swingSpan2, "swingSpan2", 1.0E30f);
        outputCapsule.write(this.twistSpan, "twistSpan", 1.0E30f);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.rotA = (Matrix3f)inputCapsule.readSavable("rotA", (Savable)new Matrix3f());
        this.rotB = (Matrix3f)inputCapsule.readSavable("rotB", (Savable)new Matrix3f());
        this.angularOnly = inputCapsule.readBoolean("angularOnly", false);
        this.swingSpan1 = inputCapsule.readFloat("swingSpan1", 1.0E30f);
        this.swingSpan2 = inputCapsule.readFloat("swingSpan2", 1.0E30f);
        this.twistSpan = inputCapsule.readFloat("twistSpan", 1.0E30f);
        this.createJoint();
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.rotA, this.pivotB, this.rotB);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
        this.setLimit(this.objectId, this.swingSpan1, this.swingSpan2, this.twistSpan);
        this.setAngularOnly(this.objectId, this.angularOnly);
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8);
}

