/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PhysicsJoint
implements Savable {
    protected long objectId = 0L;
    protected PhysicsRigidBody nodeA;
    protected PhysicsRigidBody nodeB;
    protected Vector3f pivotA;
    protected Vector3f pivotB;
    protected boolean collisionBetweenLinkedBodys = true;

    public PhysicsJoint() {
    }

    public PhysicsJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2) {
        this.nodeA = physicsRigidBody;
        this.nodeB = physicsRigidBody2;
        this.pivotA = vector3f;
        this.pivotB = vector3f2;
        physicsRigidBody.addJoint(this);
        physicsRigidBody2.addJoint(this);
    }

    public float getAppliedImpulse() {
        return this.getAppliedImpulse(this.objectId);
    }

    private native float getAppliedImpulse(long var1);

    public long getObjectId() {
        return this.objectId;
    }

    public boolean isCollisionBetweenLinkedBodys() {
        return this.collisionBetweenLinkedBodys;
    }

    public void setCollisionBetweenLinkedBodys(boolean bl) {
        this.collisionBetweenLinkedBodys = bl;
    }

    public PhysicsRigidBody getBodyA() {
        return this.nodeA;
    }

    public PhysicsRigidBody getBodyB() {
        return this.nodeB;
    }

    public Vector3f getPivotA() {
        return this.pivotA;
    }

    public Vector3f getPivotB() {
        return this.pivotB;
    }

    public void destroy() {
        this.getBodyA().removeJoint(this);
        this.getBodyB().removeJoint(this);
    }

    public void write(JmeExporter jmeExporter) throws IOException {
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.nodeA, "nodeA", null);
        outputCapsule.write((Savable)this.nodeB, "nodeB", null);
        outputCapsule.write((Savable)this.pivotA, "pivotA", null);
        outputCapsule.write((Savable)this.pivotB, "pivotB", null);
    }

    public void read(JmeImporter jmeImporter) throws IOException {
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.nodeA = (PhysicsRigidBody)inputCapsule.readSavable("nodeA", (Savable)new PhysicsRigidBody());
        this.nodeB = (PhysicsRigidBody)inputCapsule.readSavable("nodeB", (Savable)new PhysicsRigidBody());
        this.pivotA = (Vector3f)inputCapsule.readSavable("pivotA", (Savable)new Vector3f());
        this.pivotB = (Vector3f)inputCapsule.readSavable("pivotB", (Savable)new Vector3f());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing Joint {0}", Long.toHexString(this.objectId));
        this.finalizeNative(this.objectId);
    }

    private native void finalizeNative(long var1);
}

