/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplHandler {
    private static final Logger logger = Logger.getLogger(ImplHandler.class.getName());
    private final AssetManager owner;
    private final ArrayList<ImplThreadLocal> genericLocators = new ArrayList();
    private final HashMap<String, ImplThreadLocal> loaders = new HashMap();

    public ImplHandler(AssetManager owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetInfo tryLocate(AssetKey key) {
        ArrayList<ImplThreadLocal> arrayList = this.genericLocators;
        synchronized (arrayList) {
            if (this.genericLocators.size() == 0) {
                return null;
            }
            for (ImplThreadLocal local : this.genericLocators) {
                AssetInfo info;
                AssetLocator locator = (AssetLocator)local.get();
                if (local.getPath() != null) {
                    locator.setRootPath(local.getPath());
                }
                if ((info = locator.locate(this.owner, key)) == null) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocatorCount() {
        ArrayList<ImplThreadLocal> arrayList = this.genericLocators;
        synchronized (arrayList) {
            return this.genericLocators.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetLoader aquireLoader(AssetKey key) {
        HashMap<String, ImplThreadLocal> hashMap = this.loaders;
        synchronized (hashMap) {
            ImplThreadLocal local = this.loaders.get(key.getExtension());
            if (local != null) {
                AssetLoader loader = (AssetLoader)local.get();
                return loader;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoader(Class<?> loaderType, String ... extensions) {
        ImplThreadLocal local = new ImplThreadLocal(loaderType);
        for (String extension : extensions) {
            extension = extension.toLowerCase();
            HashMap<String, ImplThreadLocal> hashMap = this.loaders;
            synchronized (hashMap) {
                this.loaders.put(extension, local);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocator(Class<?> locatorType, String rootPath) {
        ImplThreadLocal local = new ImplThreadLocal(locatorType, rootPath);
        ArrayList<ImplThreadLocal> arrayList = this.genericLocators;
        synchronized (arrayList) {
            this.genericLocators.add(local);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocator(Class<?> locatorType, String rootPath) {
        ArrayList<ImplThreadLocal> arrayList = this.genericLocators;
        synchronized (arrayList) {
            Iterator<ImplThreadLocal> it = this.genericLocators.iterator();
            while (it.hasNext()) {
                ImplThreadLocal locator = it.next();
                if (!locator.getPath().equals(rootPath) || !locator.getTypeClass().equals(locatorType)) continue;
                it.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImplThreadLocal
    extends ThreadLocal {
        private final Class<?> type;
        private final String path;

        public ImplThreadLocal(Class<?> type) {
            this.type = type;
            this.path = null;
        }

        public ImplThreadLocal(Class<?> type, String path) {
            this.type = type;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public Class<?> getTypeClass() {
            return this.type;
        }

        protected Object initialValue() {
            try {
                return this.type.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.SEVERE, "Cannot create locator of type {0}, does the class have an empty and publically accessible constructor?", this.type.getName());
                logger.throwing(this.type.getName(), "<init>", ex);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.SEVERE, "Cannot create locator of type {0}, does the class have an empty and publically accessible constructor?", this.type.getName());
                logger.throwing(this.type.getName(), "<init>", ex);
            }
            return null;
        }
    }
}

