/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.IntMap;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchNode
extends Node
implements Savable {
    private static final Logger logger = Logger.getLogger(BatchNode.class.getName());
    protected Map<Material, Batch> batches = new HashMap<Material, Batch>();

    public BatchNode() {
    }

    public BatchNode(String name) {
        super(name);
    }

    @Override
    public void updateGeometricState() {
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if (!this.children.isEmpty()) {
            for (Spatial child : (Spatial[])this.children.getArray()) {
                child.updateGeometricState();
            }
            for (Batch batch : this.batches.values()) {
                if (!batch.needMeshUpdate) continue;
                batch.geometry.getMesh().updateBound();
                batch.geometry.updateWorldBound();
                batch.needMeshUpdate = false;
            }
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    protected Transform getTransforms(Geometry geom) {
        return geom.getWorldTransform();
    }

    protected void updateSubBatch(Geometry bg) {
        Batch batch = this.batches.get(bg.getMaterial());
        if (batch != null) {
            Mesh mesh = batch.geometry.getMesh();
            FloatBuffer buf = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
            this.doTransformVerts(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
            mesh.getBuffer(VertexBuffer.Type.Position).updateData(buf);
            buf = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Normal).getData();
            this.doTransformNorm(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
            mesh.getBuffer(VertexBuffer.Type.Normal).updateData(buf);
            if (mesh.getBuffer(VertexBuffer.Type.Tangent) != null) {
                buf = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Tangent).getData();
                this.doTransformNorm(buf, 0, bg.startIndex, bg.startIndex + bg.getVertexCount(), buf, bg.cachedOffsetMat);
                mesh.getBuffer(VertexBuffer.Type.Tangent).updateData(buf);
            }
            batch.needMeshUpdate = true;
        }
    }

    public void batch() {
        this.doBatch();
        for (Batch batch : this.batches.values()) {
            batch.geometry.setIgnoreTransform(true);
        }
    }

    protected void doBatch() {
        HashMap<Material, List<Geometry>> matMap = new HashMap<Material, List<Geometry>>();
        this.gatherGeomerties(matMap, this);
        this.batches.clear();
        int nbGeoms = 0;
        for (Material material : matMap.keySet()) {
            Mesh m = new Mesh();
            List list = (List)matMap.get(material);
            nbGeoms += list.size();
            this.mergeGeometries(m, list);
            Batch batch = new Batch();
            batch.geometry = new Geometry(this.name + "-batch" + this.batches.size());
            batch.geometry.setMaterial(material);
            this.attachChild(batch.geometry);
            batch.geometry.setMesh(m);
            batch.geometry.getMesh().updateCounts();
            batch.geometry.getMesh().updateBound();
            this.batches.put(material, batch);
        }
        logger.log(Level.INFO, "Batched {0} geometries in {1} batches.", new Object[]{nbGeoms, this.batches.size()});
    }

    private void gatherGeomerties(Map<Material, List<Geometry>> map, Spatial n) {
        if (n.getClass() == Geometry.class) {
            if (!this.isBatch(n)) {
                Geometry g = (Geometry)n;
                if (g.getMaterial() == null) {
                    throw new IllegalStateException("No material is set for Geometry: " + g.getName() + " please set a material before batching");
                }
                List<Geometry> list = map.get(g.getMaterial());
                if (list == null) {
                    list = new ArrayList<Geometry>();
                    map.put(g.getMaterial(), list);
                }
                list.add(g);
            }
        } else if (n instanceof Node) {
            for (Spatial child : ((Node)n).getChildren()) {
                if (child instanceof BatchNode) continue;
                this.gatherGeomerties(map, child);
            }
        }
    }

    private boolean isBatch(Spatial s) {
        for (Batch batch : this.batches.values()) {
            if (batch.geometry != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMaterial(Material material) {
        throw new UnsupportedOperationException("Unsupported for now, please set the material on the geoms before batching");
    }

    public Material getMaterial() {
        if (!this.batches.isEmpty()) {
            Batch b = this.batches.get(this.batches.keySet().iterator().next());
            return b.geometry.getMaterial();
        }
        return null;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
    }

    private void mergeGeometries(Mesh outMesh, List<Geometry> geometries) {
        int[] compsForBuf = new int[VertexBuffer.Type.values().length];
        VertexBuffer.Format[] formatForBuf = new VertexBuffer.Format[compsForBuf.length];
        int totalVerts = 0;
        int totalTris = 0;
        int totalLodLevels = 0;
        Mesh.Mode mode = null;
        for (Geometry geom : geometries) {
            int components;
            Mesh.Mode listMode;
            totalVerts += geom.getVertexCount();
            totalTris += geom.getTriangleCount();
            totalLodLevels = Math.min(totalLodLevels, geom.getMesh().getNumLodLevels());
            switch (geom.getMesh().getMode()) {
                case Points: {
                    listMode = Mesh.Mode.Points;
                    components = 1;
                    break;
                }
                case LineLoop: 
                case LineStrip: 
                case Lines: {
                    listMode = Mesh.Mode.Lines;
                    components = 2;
                    break;
                }
                case TriangleFan: 
                case TriangleStrip: 
                case Triangles: {
                    listMode = Mesh.Mode.Triangles;
                    components = 3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            for (IntMap.Entry<VertexBuffer> entry : geom.getMesh().getBuffers()) {
                compsForBuf[entry.getKey()] = entry.getValue().getNumComponents();
                formatForBuf[entry.getKey()] = entry.getValue().getFormat();
            }
            if (mode != null && mode != listMode) {
                throw new UnsupportedOperationException("Cannot combine different primitive types: " + (Object)((Object)mode) + " != " + (Object)((Object)listMode));
            }
            mode = listMode;
            compsForBuf[VertexBuffer.Type.Index.ordinal()] = components;
        }
        outMesh.setMode(mode);
        formatForBuf[VertexBuffer.Type.Index.ordinal()] = totalVerts >= 65536 ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort;
        for (int i = 0; i < compsForBuf.length; ++i) {
            if (compsForBuf[i] == 0) continue;
            Buffer data = i == VertexBuffer.Type.Index.ordinal() ? VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalTris) : VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalVerts);
            VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.values()[i]);
            vb.setupData(VertexBuffer.Usage.Static, compsForBuf[i], formatForBuf[i], data);
            outMesh.setBuffer(vb);
        }
        int globalVertIndex = 0;
        int globalTriIndex = 0;
        for (Geometry geom : geometries) {
            Mesh inMesh = geom.getMesh();
            geom.batch(this, globalVertIndex);
            int n = inMesh.getVertexCount();
            int geomTriCount = inMesh.getTriangleCount();
            for (int bufType = 0; bufType < compsForBuf.length; ++bufType) {
                FloatBuffer outPos;
                VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                if (outBuf == null) continue;
                if (VertexBuffer.Type.Index.ordinal() == bufType) {
                    int components = compsForBuf[bufType];
                    IndexBuffer inIdx = inMesh.getIndicesAsList();
                    IndexBuffer outIdx = outMesh.getIndexBuffer();
                    for (int tri = 0; tri < geomTriCount; ++tri) {
                        for (int comp = 0; comp < components; ++comp) {
                            int idx = inIdx.get(tri * components + comp) + globalVertIndex;
                            outIdx.put((globalTriIndex + tri) * components + comp, idx);
                        }
                    }
                    continue;
                }
                if (VertexBuffer.Type.Position.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos);
                    continue;
                }
                if (VertexBuffer.Type.Normal.ordinal() == bufType || VertexBuffer.Type.Tangent.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getData();
                    outPos = (FloatBuffer)outBuf.getData();
                    this.doCopyBuffer(inPos, globalVertIndex, outPos);
                    continue;
                }
                for (int vert = 0; vert < n; ++vert) {
                    int curGlobalVertIndex = globalVertIndex + vert;
                    inBuf.copyElement(vert, outBuf, curGlobalVertIndex);
                }
            }
            globalVertIndex += n;
            globalTriIndex += geomTriCount;
        }
    }

    private void doTransformVerts(FloatBuffer inBuf, int offset, int start, int end, FloatBuffer outBuf, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = start; i < end; ++i) {
            int index = i * 3;
            pos.x = inBuf.get(index);
            pos.y = inBuf.get(index + 1);
            pos.z = inBuf.get(index + 2);
            transform.mult(pos, pos);
            outBuf.put(index += offset, pos.x);
            outBuf.put(index + 1, pos.y);
            outBuf.put(index + 2, pos.z);
        }
        vars.release();
    }

    private void doTransformNorm(FloatBuffer inBuf, int offset, int start, int end, FloatBuffer outBuf, Matrix4f transform) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = start; i < end; ++i) {
            int index = i * 3;
            pos.x = inBuf.get(index);
            pos.y = inBuf.get(index + 1);
            pos.z = inBuf.get(index + 2);
            transform.multNormal(pos, pos);
            outBuf.put(index += offset, pos.x);
            outBuf.put(index + 1, pos.y);
            outBuf.put(index + 2, pos.z);
        }
        vars.release();
    }

    private void doCopyBuffer(FloatBuffer inBuf, int offset, FloatBuffer outBuf) {
        TempVars vars = TempVars.get();
        Vector3f pos = vars.vect1;
        offset *= 3;
        for (int i = 0; i < inBuf.capacity() / 3; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            outBuf.put(offset + i * 3 + 0, pos.x);
            outBuf.put(offset + i * 3 + 1, pos.y);
            outBuf.put(offset + i * 3 + 2, pos.z);
        }
        vars.release();
    }

    protected class Batch {
        Geometry geometry;
        boolean needMeshUpdate = false;

        protected Batch() {
        }
    }
}

